/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.ds.DataSheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DialogEditColumns
extends JDialog
implements ActionListener {
    private JButton bappend;
    private JButton bdelete;
    private JButton bmoveup;
    private JButton bmovedn;
    private JButton baccept;
    private JButton breject;
    private JTable table;
    private SchemaDataModel model;
    private DataSheet ds;
    private ArrayList<Integer> idx = new ArrayList();
    private ArrayList<String> name = new ArrayList();
    private ArrayList<Integer> type = new ArrayList();
    private ArrayList<String> descr = new ArrayList();
    private int[] resultOldPos = null;
    private int[] resultNewPos = null;
    private int[] resultType = null;
    private String[] resultName = null;
    private String[] resultDescr = null;

    public DialogEditColumns(Frame Parent, DataSheet DS) {
        super(Parent, "Edit Column Layout", true);
        this.ds = DS;
        this.setLayout(new BorderLayout());
        for (int n = 0; n < this.ds.numCols(); ++n) {
            this.idx.add(new Integer(n + 1));
            this.name.add(this.ds.colName(n));
            this.type.add(new Integer(this.ds.colType(n)));
            this.descr.add(this.ds.colDescr(n));
        }
        this.model = new SchemaDataModel(this.idx, this.name, this.type, this.descr);
        this.table = new JTable(this.model);
        this.setColumnModel();
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        this.bappend = new JButton("Append");
        this.bappend.addActionListener(this);
        this.bappend.setMnemonic(80);
        this.bdelete = new JButton("Delete");
        this.bdelete.addActionListener(this);
        this.bdelete.setMnemonic(68);
        this.bmoveup = new JButton("Move Up");
        this.bmoveup.addActionListener(this);
        this.bmoveup.setMnemonic(85);
        this.bmovedn = new JButton("Move Down");
        this.bmovedn.addActionListener(this);
        this.bmovedn.setMnemonic(78);
        this.baccept = new JButton("Accept");
        this.baccept.addActionListener(this);
        this.baccept.setMnemonic(65);
        this.breject = new JButton("Reject");
        this.breject.addActionListener(this);
        this.breject.setMnemonic(82);
        buttons.add(this.bappend);
        buttons.add(this.bdelete);
        buttons.add(this.bmoveup);
        buttons.add(this.bmovedn);
        buttons.add(this.baccept);
        buttons.add(this.breject);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)buttons, "South");
        this.pack();
    }

    private void setColumnModel() {
        JComboBox<String> colTypes = new JComboBox<String>();
        colTypes.addItem(DataSheet.typeName(1));
        colTypes.addItem(DataSheet.typeName(2));
        colTypes.addItem(DataSheet.typeName(4));
        colTypes.addItem(DataSheet.typeName(3));
        colTypes.addItem(DataSheet.typeName(5));
        this.table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(colTypes));
        this.table.setPreferredScrollableViewportSize(new Dimension(350, 200));
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setMaxWidth(150);
        this.table.getColumnModel().getColumn(2).setMaxWidth(100);
    }

    private void actionAppend() {
        this.idx.add(0);
        this.name.add("");
        this.type.add(2);
        this.descr.add("");
        this.model.fireTableStructureChanged();
        this.setColumnModel();
    }

    private void actionDelete() {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.idx.remove(i);
        this.name.remove(i);
        this.type.remove(i);
        this.descr.remove(i);
        this.model.fireTableStructureChanged();
        this.setColumnModel();
    }

    private void actionMove(int Dir) {
        int i = this.table.getSelectedRow();
        if (i < 0 || i + Dir < 0 || i + Dir >= this.idx.size()) {
            return;
        }
        this.idx.add(i + Dir, this.idx.remove(i));
        this.name.add(i + Dir, this.name.remove(i));
        this.type.add(i + Dir, this.type.remove(i));
        this.descr.add(i + Dir, this.descr.remove(i));
        this.model.fireTableStructureChanged();
        this.setColumnModel();
        this.table.changeSelection(i + Dir, this.table.getSelectedColumn(), false, false);
    }

    private void actionAccept() {
        int n;
        for (int n2 = 0; n2 < this.idx.size(); ++n2) {
            if (this.name.get(n2).length() != 0) continue;
            JOptionPane.showMessageDialog(null, "All columns must be named.", "Invalid", 0);
            return;
        }
        int nsz = this.ds.numCols();
        boolean[] retained = new boolean[this.ds.numCols()];
        for (int n3 = 0; n3 < this.idx.size(); ++n3) {
            int i = this.idx.get(n3);
            if (i == 0) {
                ++nsz;
                continue;
            }
            retained[i - 1] = true;
        }
        int[] oldIdx = new int[nsz];
        int[] newIdx = new int[nsz];
        int[] newType = new int[nsz];
        String[] newName = new String[nsz];
        String[] newDescr = new String[nsz];
        int pos = 0;
        for (n = 0; n < this.idx.size(); ++n) {
            oldIdx[n] = this.idx.get(n) - 1;
            newIdx[n] = pos++;
            newName[n] = this.name.get(n);
            newType[n] = this.type.get(n);
            newDescr[n] = this.descr.get(n);
        }
        for (n = 0; n < retained.length; ++n) {
            if (retained[n]) continue;
            oldIdx[pos] = n;
            newIdx[pos] = -1;
            ++pos;
        }
        String explan = "";
        for (int n4 = 0; n4 < oldIdx.length; ++n4) {
            if (oldIdx[n4] < 0 && newIdx[n4] >= 0) {
                explan = explan + "New column: [" + newName[n4] + "], type: " + DataSheet.typeName(newType[n4]) + "\n";
                continue;
            }
            if (oldIdx[n4] >= 0 && newIdx[n4] < 0) {
                explan = explan + "Delete column: [" + this.ds.colName(oldIdx[n4]) + "]\n";
                continue;
            }
            if (oldIdx[n4] < 0 || newIdx[n4] < 0) continue;
            if (newName[n4].compareTo(this.ds.colName(oldIdx[n4])) != 0) {
                explan = explan + "Rename [" + this.ds.colName(oldIdx[n4]) + "] to [" + newName[n4] + "]\n";
            }
            if (newDescr[n4].compareTo(this.ds.colDescr(oldIdx[n4])) != 0) {
                explan = explan + "Change description for [" + newName[n4] + "]\n";
            }
            if (this.ds.colType(oldIdx[n4]) != newType[n4]) {
                explan = explan + "Change type of [" + newName[n4] + "] to: " + DataSheet.typeName(newType[n4]) + "\n";
            }
            if (newIdx[n4] == oldIdx[n4]) continue;
            explan = explan + "Reorder [" + newName[n4] + "] from #" + (oldIdx[n4] + 1) + " to #" + (newIdx[n4] + 1) + "\n";
        }
        if (explan.length() == 0) {
            this.setVisible(false);
            return;
        }
        Object[] opt = new String[]{"Yes", "No"};
        if (JOptionPane.showOptionDialog(null, explan, "Apply Changes?", 0, 0, null, opt, opt[0]) != 0) {
            return;
        }
        this.resultOldPos = oldIdx;
        this.resultNewPos = newIdx;
        this.resultName = newName;
        this.resultType = newType;
        this.resultDescr = newDescr;
        this.setVisible(false);
    }

    private void actionReject() {
        this.setVisible(false);
    }

    public boolean execute() {
        this.setVisible(true);
        return this.resultOldPos != null;
    }

    public int[] resultOldPos() {
        return this.resultOldPos;
    }

    public int[] resultNewPos() {
        return this.resultNewPos;
    }

    public String[] resultName() {
        return this.resultName;
    }

    public int[] resultType() {
        return this.resultType;
    }

    public String[] resultDescr() {
        return this.resultDescr;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bappend) {
            this.actionAppend();
        } else if (e.getSource() == this.bdelete) {
            this.actionDelete();
        } else if (e.getSource() == this.bmoveup) {
            this.actionMove(-1);
        } else if (e.getSource() == this.bmovedn) {
            this.actionMove(1);
        } else if (e.getSource() == this.baccept) {
            this.actionAccept();
        } else if (e.getSource() == this.breject) {
            this.actionReject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SchemaDataModel
    extends AbstractTableModel {
        ArrayList<Integer> idx;
        ArrayList<String> name;
        ArrayList<Integer> type;
        ArrayList<String> descr;

        public SchemaDataModel(ArrayList<Integer> Idx, ArrayList<String> Name, ArrayList<Integer> Type2, ArrayList<String> Descr) {
            this.idx = Idx;
            this.name = Name;
            this.type = Type2;
            this.descr = Descr;
        }

        @Override
        public String getColumnName(int col) {
            String[] COLNAMES = new String[]{"#", "Name", "Type", "Description"};
            return COLNAMES[col];
        }

        @Override
        public int getRowCount() {
            return this.idx.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                int i = this.idx.get(row);
                return i == 0 ? "" : "" + i;
            }
            if (col == 1) {
                return this.name.get(row);
            }
            if (col == 2) {
                return DataSheet.typeName(this.type.get(row));
            }
            if (col == 3) {
                return this.descr.get(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.name.set(row, (String)value);
            } else if (col == 2) {
                String t = (String)value;
                if (t.compareTo(DataSheet.typeName(1)) == 0) {
                    this.type.set(row, 1);
                } else if (t.compareTo(DataSheet.typeName(2)) == 0) {
                    this.type.set(row, 2);
                } else if (t.compareTo(DataSheet.typeName(4)) == 0) {
                    this.type.set(row, 4);
                } else if (t.compareTo(DataSheet.typeName(3)) == 0) {
                    this.type.set(row, 3);
                } else if (t.compareTo(DataSheet.typeName(5)) == 0) {
                    this.type.set(row, 5);
                }
            } else if (col == 3) {
                this.descr.set(row, (String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

