/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.ArrangeMeasurement;
import WIMSchem.EditorPane;
import WIMSchem.MainApplet;
import WIMSchem.Molecule;
import WIMSchem.Util;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ArrangeMolecule {
    private Molecule mol;
    private double scale;
    private ArrangeMeasurement measure;
    public static final int SHOW_ELEMENTS = 0;
    public static final int SHOW_ALL_ELEMENTS = 1;
    public static final int SHOW_INDEXES = 2;
    public static final int SHOW_RINGID = 3;
    public static final int SHOW_PRIORITY = 4;
    public static final int SHOW_MAPNUM = 5;
    public int unselected_color = 0;
    private int elementMode;
    private boolean showHydrogens;
    private double fontSize;
    private double lineSize;
    private double bondSep;
    private boolean devRounding;
    private boolean annotRS = false;
    private boolean annotEZ = false;
    public static final int BLINE_NORMAL = 1;
    public static final int BLINE_INCLINED = 2;
    public static final int BLINE_DECLINED = 3;
    public static final int BLINE_UNKNOWN = 4;
    public static final int BLINE_DOTTED = 5;
    private ArrayList<APoint> points = new ArrayList();
    private ArrayList<BLine> lines = new ArrayList();

    public ArrangeMolecule(Molecule mol, ArrangeMeasurement measure) {
        this.mol = mol;
        this.measure = measure;
        this.scale = measure.scale();
        this.elementMode = 0;
        this.showHydrogens = true;
        this.fontSize = 0.6 * this.scale;
        this.lineSize = 0.075 * this.scale;
        this.bondSep = 0.2 * this.scale;
        this.devRounding = true;
    }

    public void setShowHydrogens(boolean v) {
        this.showHydrogens = v;
    }

    public void setElementMode(int v) {
        this.elementMode = v;
    }

    public void setFontSizeAng(double v) {
        this.fontSize = v * this.scale;
    }

    public void setFontSizeDev(double v) {
        this.fontSize = v;
    }

    public void setLineSizeAng(double v) {
        this.lineSize = v * this.scale;
    }

    public void setDevRounding(boolean v) {
        this.devRounding = v;
    }

    public void setAnnotRS(boolean v) {
        this.annotRS = v;
    }

    public void setAnnotEZ(boolean v) {
        this.annotEZ = v;
    }

    public boolean getShowHydrogens() {
        return this.showHydrogens;
    }

    public int getElementMode() {
        return this.elementMode;
    }

    public double getFontSizeDev() {
        return this.fontSize;
    }

    public double getLineSizeDev() {
        return this.lineSize;
    }

    public boolean getDevRounding() {
        return this.devRounding;
    }

    public boolean getAnnotRS() {
        return this.annotRS;
    }

    public boolean getAnnotEZ() {
        return this.annotEZ;
    }

    public void arrange() {
        int n;
        int i;
        if (MainApplet.viewC) {
            this.elementMode = 1;
        }
        if (MainApplet.viewH) {
            this.showHydrogens = true;
        }
        for (int n2 = 1; n2 <= this.mol.numAtoms(); ++n2) {
            APoint a = new APoint();
            a.anum = n2;
            a.fsz = this.fontSize;
            a.bold = this.mol.atomMapNum(n2) > 0;
            a.col = this.unselected_color;
            if (MainApplet.USER_SELECTION) {
                if (EditorPane.atomselection[n2]) {
                    a.col = MainApplet.ATOM_SELECT_HTML_COLOR;
                }
            } else if (MainApplet.SUPERUSER_SELECTION && MainApplet.ExternalAtomSelection != null) {
                for (int p = 0; p < MainApplet.ExternalAtomSelection.length; ++p) {
                    if (n2 != MainApplet.ExternalAtomSelection[p]) continue;
                    a.col = MainApplet.SelectedAtomColorInt[p];
                }
            }
            a.cx = this.measure.angToX(this.mol.atomX(n2));
            a.cy = this.measure.angToY(this.mol.atomY(n2));
            a.rh = 0.0;
            a.rw = 0.0;
            if (this.devRounding) {
                a.cx = Math.round(a.cx);
                a.cy = Math.round(a.cy);
            }
            switch (this.elementMode) {
                case 0: {
                    a.text = this.mol.atomExplicit(n2) ? this.mol.atomElement(n2) : null;
                    break;
                }
                case 1: {
                    a.text = this.mol.atomElement(n2);
                    break;
                }
                case 2: {
                    a.text = String.valueOf(n2);
                    break;
                }
                case 3: {
                    a.text = String.valueOf(this.mol.atomRingBlock(n2));
                    break;
                }
                case 4: {
                    a.text = String.valueOf(this.mol.atomPriority(n2));
                    break;
                }
                case 5: {
                    a.text = this.mol.atomMapNum(n2) > 0 ? String.valueOf(this.mol.atomMapNum(n2)) : "";
                    break;
                }
                default: {
                    a.text = "?";
                }
            }
            if (a.text != null) {
                double[] wad = this.measure.measureText(a.text, a.fsz);
                a.rw = 0.5 * wad[0];
                a.rh = 0.5 * wad[1];
            }
            this.points.add(a);
        }
        boolean[] bdbl = new boolean[this.mol.numBonds()];
        for (int n3 = 1; n3 <= this.mol.numBonds(); ++n3) {
            bdbl[n3 - 1] = this.mol.bondOrder(n3) == 2;
            double x1 = this.pointCX(this.mol.bondFrom(n3) - 1);
            double y1 = this.pointCY(this.mol.bondFrom(n3) - 1);
            double x2 = this.pointCX(this.mol.bondTo(n3) - 1);
            double y2 = this.pointCY(this.mol.bondTo(n3) - 1);
            int scol = this.unselected_color;
            if (MainApplet.USER_SELECTION) {
                if (EditorPane.bondselection[n3]) {
                    scol = MainApplet.BOND_SELECT_HTML_COLOR;
                }
            } else if (MainApplet.SUPERUSER_SELECTION && MainApplet.ExternalBondSelection != null) {
                for (int p = 0; p < MainApplet.ExternalBondSelection.length; ++p) {
                    if (n3 != MainApplet.ExternalBondSelection[p]) continue;
                    scol = MainApplet.SelectedBondColorInt[p];
                }
            }
            if (this.mol.bondOrder(n3) == 2) continue;
            double[] xy1 = this.backOffAtom(this.mol.bondFrom(n3) - 1, x1, y1, x2, y2);
            double[] xy2 = this.backOffAtom(this.mol.bondTo(n3) - 1, x2, y2, x1, y1);
            double sz = this.lineSize;
            if (this.mol.atomMapNum(this.mol.bondFrom(n3)) > 0 && this.mol.atomMapNum(this.mol.bondTo(n3)) > 0) {
                sz *= 1.6666666666666667;
            }
            int ltype = 1;
            if (this.mol.bondType(n3) == 1) {
                ltype = 2;
            } else if (this.mol.bondType(n3) == 2) {
                ltype = 3;
            } else if (this.mol.bondType(n3) == 3) {
                ltype = 4;
            } else if (this.mol.bondOrder(n3) <= 0) {
                ltype = 5;
            }
            int bo = this.mol.bondOrder(n3);
            if (bo == 0) {
                double dx = xy2[0] - xy1[0];
                double dy = xy2[1] - xy1[1];
                double d = Math.sqrt(dx * dx + dy * dy);
                double ox = dx / d * this.bondSep;
                double oy = dy / d * this.bondSep;
                if (this.mol.atomAdjCount(this.mol.bondFrom(n3)) > 1) {
                    xy1[0] = xy1[0] + ox;
                    xy1[1] = xy1[1] + oy;
                }
                if (this.mol.atomAdjCount(this.mol.bondTo(n3)) > 1) {
                    xy2[0] = xy2[0] - ox;
                    xy2[1] = xy2[1] - oy;
                }
            }
            if (bo <= 1 || this.mol.bondType(n3) != 0) {
                this.lines.add(new BLine(n3, ltype, xy1[0], xy1[1], xy2[0], xy2[1], sz, scol));
                continue;
            }
            double[] oxy = this.orthogonalDelta(xy1[0], xy1[1], xy2[0], xy2[1], this.bondSep);
            double v = -0.5 * (double)(bo - 1);
            int i2 = 0;
            while (i2 < bo) {
                this.lines.add(new BLine(n3, 1, xy1[0] + v * oxy[0], xy1[1] + v * oxy[1], xy2[0] + v * oxy[0], xy2[1] + v * oxy[1], sz, scol));
                ++i2;
                v += 1.0;
            }
        }
        int[][] rings = this.orderedRingList();
        for (i = 0; i < rings.length; ++i) {
            for (int j = 0; j < rings[i].length; ++j) {
                int k = this.mol.findBond(rings[i][j], rings[i][j < rings[i].length - 1 ? j + 1 : 0]);
                if (!bdbl[k - 1]) continue;
                this.processDoubleBond(k, rings[i]);
                bdbl[k - 1] = false;
            }
        }
        for (i = 1; i <= this.mol.numBonds(); ++i) {
            if (!bdbl[i - 1]) continue;
            this.processDoubleBond(i, this.priorityDoubleSubstit(i));
        }
        int[] hcount = new int[this.mol.numAtoms()];
        for (n = 1; n <= this.mol.numAtoms(); ++n) {
            hcount[n - 1] = this.pointText(n - 1) == null || !this.showHydrogens ? 0 : this.mol.atomHydrogens(n);
        }
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            if (hcount[n] <= 0) continue;
            if (this.quadrantOpen(n, 1, 0) && this.placeHydrogen(n, hcount[n], 1, 0)) {
                hcount[n] = 0;
                continue;
            }
            if (this.quadrantOpen(n, -1, 0) && this.placeHydrogen(n, hcount[n], -1, 0)) {
                hcount[n] = 0;
                continue;
            }
            if (this.quadrantOpen(n, 0, 1) && this.placeHydrogen(n, hcount[n], 0, 1)) {
                hcount[n] = 0;
                continue;
            }
            if (!this.quadrantOpen(n, 0, -1) || !this.placeHydrogen(n, hcount[n], 0, -1)) continue;
            hcount[n] = 0;
        }
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            if (hcount[n] <= 0 || !this.placeHydrogen(n, hcount[n], 1, 0)) continue;
            hcount[n] = 0;
        }
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            if (hcount[n] <= 0 || !this.placeHydrogen(n, hcount[n], -1, 0)) continue;
            hcount[n] = 0;
        }
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            if (hcount[n] <= 0 || !this.placeHydrogen(n, hcount[n], 0, 1)) continue;
            hcount[n] = 0;
        }
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            if (hcount[n] <= 0 || !this.placeHydrogen(n, hcount[n], 0, -1)) continue;
            hcount[n] = 0;
        }
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            if (hcount[n] <= 0) continue;
            this.placeHydrogen(n, hcount[n], 0, 0);
        }
        for (n = 1; n <= this.mol.numAtoms(); ++n) {
            int scol = this.unselected_color;
            if (MainApplet.USER_SELECTION) {
                if (EditorPane.atomselection[n]) {
                    scol = MainApplet.ATOM_SELECT_HTML_COLOR;
                }
            } else if (MainApplet.SUPERUSER_SELECTION && MainApplet.ExternalAtomSelection != null) {
                for (int p = 0; p < MainApplet.ExternalAtomSelection.length; ++p) {
                    if (n != MainApplet.ExternalAtomSelection[p]) continue;
                    scol = MainApplet.SelectedAtomColorInt[p];
                }
            }
            String str = "";
            int chg = this.mol.atomCharge(n);
            if (chg == -1) {
                str = "-";
            } else if (chg == 1) {
                str = "+";
            } else if (chg < -1) {
                str = String.valueOf(chg);
            } else if (chg > 1) {
                str = "+" + String.valueOf(chg);
            }
            for (int i3 = this.mol.atomUnpaired(n); i3 > 0; --i3) {
                str = str + ".";
            }
            if (str.length() == 0) continue;
            this.annotateAtom(n, str, str.length() == 1 ? this.fontSize : 0.75 * this.fontSize, scol);
        }
        if (this.annotRS) {
            for (n = 1; n <= this.mol.numAtoms(); ++n) {
                int chi = this.mol.atomChirality(n);
                if (chi == 0) continue;
                String label = chi == 1 ? "R" : (chi == 2 ? "S" : "R/S");
                this.annotateAtom(n, label, 0.0, 255);
            }
        }
        if (this.annotEZ) {
            for (n = 1; n <= this.mol.numBonds(); ++n) {
                int chi = this.mol.bondStereo(n);
                if (chi == 0) continue;
                String label = chi == 1 ? "Z" : (chi == 2 ? "E" : "E/Z");
                this.annotateBond(n, label, 0.0, 255);
            }
        }
    }

    public void annotateAtom(int anum, String label, double fsz, int col) {
        if (fsz == 0.0) {
            fsz = this.fontSize;
        }
        double[] wad = this.measure.measureText(label, fsz);
        double rw = 0.5 * wad[0];
        double rh = 0.5 * wad[1];
        double[] pxy = this.anchorAnnotation(this.pointCX(anum - 1), this.pointCY(anum - 1), rw, rh);
        APoint a = new APoint();
        a.anum = 0;
        a.text = label;
        a.fsz = fsz;
        a.bold = false;
        a.col = col;
        a.cx = pxy[0];
        a.cy = pxy[1];
        a.rw = rw;
        a.rh = rh;
        this.points.add(a);
    }

    public void annotateBond(int bnum, String label, double fsz, int col) {
        if (fsz == 0.0) {
            fsz = this.fontSize;
        }
        double[] wad = this.measure.measureText(label, fsz);
        double rw = 0.5 * wad[0];
        double rh = 0.5 * wad[1];
        int bfr = this.mol.bondFrom(bnum);
        int bto = this.mol.bondTo(bnum);
        double[] pxy = this.anchorAnnotation(0.5 * (this.pointCX(bfr - 1) + this.pointCX(bto - 1)), 0.5 * (this.pointCY(bfr - 1) + this.pointCY(bto - 1)), rw, rh);
        APoint a = new APoint();
        a.anum = 0;
        a.text = label;
        a.fsz = fsz;
        a.bold = false;
        a.col = col;
        a.cx = pxy[0];
        a.cy = pxy[1];
        a.rw = rw;
        a.rh = rh;
        this.points.add(a);
    }

    public int numPoints() {
        return this.points.size();
    }

    public int pointANum(int N) {
        return this.points.get((int)N).anum;
    }

    public String pointText(int N) {
        return this.points.get((int)N).text;
    }

    public double pointFontSize(int N) {
        return this.points.get((int)N).fsz;
    }

    public boolean pointBold(int N) {
        return this.points.get((int)N).bold;
    }

    public int pointCol(int N) {
        return this.points.get((int)N).col;
    }

    public double pointCX(int N) {
        return this.points.get((int)N).cx;
    }

    public double pointCY(int N) {
        return this.points.get((int)N).cy;
    }

    public double pointRW(int N) {
        return this.points.get((int)N).rw;
    }

    public double pointRH(int N) {
        return this.points.get((int)N).rh;
    }

    public int numLines() {
        return this.lines.size();
    }

    public int lineBNum(int N) {
        return this.lines.get((int)N).bnum;
    }

    public int lineType(int N) {
        return this.lines.get((int)N).type;
    }

    public double lineX1(int N) {
        return this.lines.get((int)N).x1;
    }

    public double lineY1(int N) {
        return this.lines.get((int)N).y1;
    }

    public double lineX2(int N) {
        return this.lines.get((int)N).x2;
    }

    public double lineY2(int N) {
        return this.lines.get((int)N).y2;
    }

    public double lineSize(int N) {
        return this.lines.get((int)N).size;
    }

    public int lineCol(int N) {
        return this.lines.get((int)N).col;
    }

    private double[] backOffAtom(int N, double X, double Y, double FX, double FY) {
        double sqY;
        double EXT_RAD = 1.4;
        double cx = this.pointCX(N);
        double cy = this.pointCY(N);
        double rw = this.pointRW(N) * 1.4;
        double rh = this.pointRH(N) * 1.4;
        if (this.pointText(N) == null || rw <= 0.0 || rh <= 0.0) {
            return new double[]{X, Y};
        }
        double dx = X - cx;
        double dy = Y - cy;
        double sqX = Util.sqr(dx) / Util.sqr(rw);
        if (sqX + (sqY = Util.sqr(dy) / Util.sqr(rh)) >= 1.0) {
            return new double[]{X, Y};
        }
        dx = FX - cx;
        dy = FY - cy;
        sqX = Util.sqr(dx) / Util.sqr(rw);
        sqY = Util.sqr(dy) / Util.sqr(rh);
        double d = Math.sqrt(1.0 / (sqX + sqY));
        return new double[]{X + d * (FX - X), Y + d * (FY - Y)};
    }

    private int[][] orderedRingList() {
        ArrayList<int[]> rings = new ArrayList<int[]>();
        int[] SIZE_ORDER = new int[]{6, 5, 7, 4, 3};
        for (int i = 0; i < SIZE_ORDER.length; ++i) {
            int[][] nring = this.mol.findRingSize(SIZE_ORDER[i]);
            for (int j = 0; j < nring.length; ++j) {
                rings.add(nring[j]);
            }
        }
        ArrayList result = new ArrayList();
        while (rings.size() > 0) {
            int which = 0;
            for (int i = 0; i < rings.size(); ++i) {
                int ncon = 0;
                for (int j = 0; j < rings.size(); ++j) {
                    if (i == j) continue;
                    boolean shared = false;
                    int[] r1 = (int[])rings.get(i);
                    int[] r2 = (int[])rings.get(j);
                    block5: for (int k1 = 0; k1 < r1.length && !shared; ++k1) {
                        for (int k2 = 0; k2 < r2.length; ++k2) {
                            if (r1[k1] != r2[k2]) continue;
                            shared = true;
                            continue block5;
                        }
                    }
                    if (!shared) continue;
                    ++ncon;
                }
                if (ncon > true) continue;
                which = i;
                break;
            }
            result.add(rings.get(which));
            rings.remove(which);
        }
        return (int[][])result.toArray((T[])new int[result.size()][]);
    }

    private double[] orthogonalDelta(double X1, double Y1, double X2, double Y2, double D) {
        double ox = Y1 - Y2;
        double oy = X2 - X1;
        double dsq = ox * ox + oy * oy;
        double sc = dsq > 0.0 ? D / Math.sqrt(dsq) : 1.0;
        return new double[]{ox * sc, oy * sc};
    }

    private void processDoubleBond(int N, int[] Priority) {
        double theta;
        boolean ispri;
        int n;
        int bf = this.mol.bondFrom(N);
        int bt = this.mol.bondTo(N);
        int[] nf = this.mol.atomAdjList(bf);
        int[] nt = this.mol.atomAdjList(bt);
        double x1 = this.pointCX(bf - 1);
        double y1 = this.pointCY(bf - 1);
        double x2 = this.pointCX(bt - 1);
        double y2 = this.pointCY(bt - 1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double btheta = Math.atan2(dy, dx);
        int countFLeft = 0;
        int countFRight = 0;
        int countTLeft = 0;
        int countTRight = 0;
        int idxFLeft = 0;
        int idxFRight = 0;
        int idxTLeft = 0;
        int idxTRight = 0;
        boolean noshift = false;
        for (n = 0; n < nf.length; ++n) {
            if (nf[n] == bt) continue;
            if (this.mol.bondOrder(this.mol.findBond(bf, nf[n])) > 1) {
                noshift = true;
                break;
            }
            ispri = false;
            for (int i = 0; i < (Priority == null ? 0 : Priority.length); ++i) {
                if (Priority[i] != nf[n]) continue;
                ispri = true;
            }
            theta = Util.angleDiff(Math.atan2(this.pointCY(nf[n] - 1) - y1, this.pointCX(nf[n] - 1) - x1), btheta);
            if (theta > 0.0) {
                if (ispri) {
                    ++countFLeft;
                }
                idxFLeft = nf[n];
                continue;
            }
            if (ispri) {
                ++countFRight;
            }
            idxFRight = nf[n];
        }
        for (n = 0; n < nt.length; ++n) {
            if (nt[n] == bf) continue;
            if (this.mol.bondOrder(this.mol.findBond(bt, nt[n])) > 1) {
                noshift = true;
                break;
            }
            ispri = false;
            for (int i = 0; i < (Priority == null ? 0 : Priority.length); ++i) {
                if (Priority[i] != nt[n]) continue;
                ispri = true;
            }
            theta = Util.angleDiff(Math.atan2(this.pointCY(nt[n] - 1) - y2, this.pointCX(nt[n] - 1) - x2), btheta);
            if (theta > 0.0) {
                if (ispri) {
                    ++countTLeft;
                }
                idxTLeft = nt[n];
                continue;
            }
            if (ispri) {
                ++countTRight;
            }
            idxTRight = nt[n];
        }
        int side = 0;
        if (!(noshift || countFLeft > 1 || countFRight > 1 || countTLeft > 1 || countTRight > 1 || countFLeft > 0 && countFRight > 0 || countTLeft > 0 && countTRight > 0)) {
            if (countFLeft > 0 || countTLeft > 0) {
                side = 1;
            } else if (countFRight > 0 || countTRight > 0) {
                side = -1;
            }
        }
        double sz = this.lineSize;
        if (this.mol.atomMapNum(bf) > 0 && this.mol.atomMapNum(bt) > 0) {
            sz *= 1.6666666666666667;
        }
        double[] oxy = this.orthogonalDelta(x1, y1, x2, y2, this.bondSep);
        double ax1 = x1;
        double ay1 = y1;
        double ax2 = x2;
        double ay2 = y2;
        double bx1 = 0.0;
        double by1 = 0.0;
        double bx2 = 0.0;
        double by2 = 0.0;
        if (side == 0) {
            ax1 = x1 + 0.5 * oxy[0];
            ay1 = y1 + 0.5 * oxy[1];
            ax2 = x2 + 0.5 * oxy[0];
            ay2 = y2 + 0.5 * oxy[1];
            bx1 = x1 - 0.5 * oxy[0];
            by1 = y1 - 0.5 * oxy[1];
            bx2 = x2 - 0.5 * oxy[0];
            by2 = y2 - 0.5 * oxy[1];
        } else if (side > 0) {
            bx1 = x1 + oxy[0];
            by1 = y1 + oxy[1];
            bx2 = x2 + oxy[0];
            by2 = y2 + oxy[1];
            if (nf.length > 1 && this.pointText(bf - 1) == null) {
                bx1 += oxy[1];
                by1 -= oxy[0];
            }
            if (nt.length > 1 && this.pointText(bt - 1) == null) {
                bx2 -= oxy[1];
                by2 += oxy[0];
            }
        } else if (side < 0) {
            bx1 = x1 - oxy[0];
            by1 = y1 - oxy[1];
            bx2 = x2 - oxy[0];
            by2 = y2 - oxy[1];
            if (nf.length > 1 && this.pointText(bf - 1) == null) {
                bx1 += oxy[1];
                by1 -= oxy[0];
            }
            if (nt.length > 1 && this.pointText(bt - 1) == null) {
                bx2 -= oxy[1];
                by2 += oxy[0];
            }
        }
        double[] xy1 = this.backOffAtom(bf - 1, ax1, ay1, ax2, ay2);
        double[] xy2 = this.backOffAtom(bt - 1, ax2, ay2, ax1, ay1);
        ax1 = xy1[0];
        ay1 = xy1[1];
        ax2 = xy2[0];
        ay2 = xy2[1];
        xy1 = this.backOffAtom(bf - 1, bx1, by1, bx2, by2);
        xy2 = this.backOffAtom(bt - 1, bx2, by2, bx1, by1);
        bx1 = xy1[0];
        by1 = xy1[1];
        bx2 = xy2[0];
        by2 = xy2[1];
        if (this.devRounding) {
            boolean orthog;
            ax1 = Math.round(ax1);
            ay1 = Math.round(ay1);
            ax2 = Math.round(ax2);
            ay2 = Math.round(ay2);
            bx1 = Math.round(bx1);
            by1 = Math.round(by1);
            bx2 = Math.round(bx2);
            by2 = Math.round(by2);
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = 0;
            int dy2 = 0;
            double best = 1.0E10;
            double bondSepSq = Util.sqr(this.bondSep);
            int[] RDX1 = new int[]{0, -1, 1, 0, 0, 0, 0, 0, 0};
            int[] RDY1 = new int[]{0, 0, 0, -1, 1, 0, 0, 0, 0};
            int[] RDX2 = new int[]{0, 0, 0, 0, 0, -1, 1, 0, 0};
            int[] RDY2 = new int[]{0, 0, 0, 0, 0, 0, 0, -1, 1};
            boolean bl = orthog = Util.dblEqual(ax1, ax2) && Util.dblEqual(bx1, bx2) || Util.dblEqual(ay1, ay2) && Util.dblEqual(by1, by2);
            if (!orthog) {
                for (int n2 = 0; n2 < 9; ++n2) {
                    double ux1 = bx1 + (double)RDX1[n2];
                    double uy1 = by1 + (double)RDY1[n2];
                    double ux2 = bx2 + (double)RDX2[n2];
                    double uy2 = by2 + (double)RDY2[n2];
                    double ox = uy1 - uy2;
                    double oy = ux2 - ux1;
                    double[] ixy1 = this.lineIntersection(ux1, uy1, ux1 + ox, uy1 + oy, ax1, ay1, ax2, ay2);
                    double[] ixy2 = this.lineIntersection(ux2, uy2, ux2 + ox, uy2 + oy, ax1, ay1, ax2, ay2);
                    double dsq1 = Util.sqr(ixy1[0] - ux1) + Util.sqr(ixy1[1] - uy1);
                    double dsq2 = Util.sqr(ixy2[0] - ux2) + Util.sqr(ixy2[1] - uy2);
                    double score = Math.abs(dsq1 - bondSepSq) + Math.abs(dsq2 - bondSepSq);
                    if (!(score < best)) continue;
                    best = score;
                    dx1 = RDX1[n2];
                    dy1 = RDY1[n2];
                    dx2 = RDX2[n2];
                    dy2 = RDY2[n2];
                }
            }
            bx1 += (double)dx1;
            by1 += (double)dy1;
            bx2 += (double)dx2;
            by2 += (double)dy2;
        }
        int scol = this.unselected_color;
        if (MainApplet.USER_SELECTION) {
            if (EditorPane.bondselection[N]) {
                scol = MainApplet.BOND_SELECT_HTML_COLOR;
            }
        } else if (MainApplet.SUPERUSER_SELECTION && MainApplet.ExternalBondSelection != null) {
            for (int p = 0; p < MainApplet.ExternalBondSelection.length; ++p) {
                if (N != MainApplet.ExternalBondSelection[p]) continue;
                scol = MainApplet.SelectedBondColorInt[p];
            }
        }
        this.lines.add(new BLine(N, 1, ax1, ay1, ax2, ay2, sz, scol));
        this.lines.add(new BLine(N, 1, bx1, by1, bx2, by2, sz, scol));
        if (side == 0 && !noshift && this.mol.atomRingBlock(bf) == 0 && this.mol.atomRingBlock(bt) == 0) {
            if (this.pointText(bf - 1) == null) {
                this.adjustBondPosition(idxFLeft, bf, ax1, ay1);
                this.adjustBondPosition(idxFRight, bf, bx1, by1);
            }
            if (this.pointText(bt - 1) == null) {
                this.adjustBondPosition(idxTLeft, bt, ax2, ay2);
                this.adjustBondPosition(idxTRight, bt, bx2, by2);
            }
        }
    }

    private boolean quadrantOpen(int N, int DX, int DY) {
        int[] nbr = this.mol.atomAdjList(N + 1);
        for (int n = 0; n < nbr.length; ++n) {
            double ox = this.pointCX(nbr[n] - 1) - this.pointCX(N);
            double oy = this.pointCY(nbr[n] - 1) - this.pointCY(N);
            if (DX == 1 && DY == 0 && ox > 0.0) {
                return false;
            }
            if (DX == -1 && DY == 0 && ox < 0.0) {
                return false;
            }
            if (DX == 0 && DY == 1 && oy > 0.0) {
                return false;
            }
            if (DX != 0 || DY != -1 || !(oy < 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean placeHydrogen(int N, int HCount, int DX, int DY) {
        double KERN_CONST = 1.1;
        APoint a = this.points.get(N);
        double[] wad = this.measure.measureText("H", a.fsz);
        double cx = a.cx + (double)DX * (a.rw + 0.5 * wad[0]) * 1.1;
        double cy = a.cy + (double)DY * (a.rh + 0.5 * (wad[1] + wad[2])) * 1.1;
        double rw = 0.5 * wad[0];
        double rh = 0.5 * wad[1];
        String nstr = HCount > 1 ? String.valueOf(HCount) : null;
        double nsz = 0.5 * a.fsz;
        double[] nwad = nstr == null ? null : this.measure.measureText(nstr, nsz);
        double nx = 0.0;
        double ny = 0.0;
        double nw = 0.0;
        double nh = 0.0;
        if (nstr != null) {
            nw = 0.5 * nwad[0];
            nh = 0.5 * nwad[1];
        }
        if (DX != 0 || DY != 0) {
            if (this.boxOverlaps(cx - rw, cy - rh, 2.0 * rw, 2.0 * rh)) {
                return false;
            }
            if (nstr != null && DX == -1 && DY == 0) {
                cx -= nwad[0] * 1.1;
            }
        } else {
            double bestX = 0.0;
            double bestY = 0.0;
            double bestScore = 0.0;
            for (double th = 0.0; th < Math.PI * 2; th += 0.08726646259971647) {
                double tx = a.cx + a.rw * Math.cos(th);
                double ty = a.cy + a.rh * Math.sin(th);
                if (tx > a.cx && tx - rw < a.cx + a.rw) {
                    tx = a.cx + a.rw + rw;
                }
                if (tx < a.cx && tx + rw + nw * 3.0 > a.cx - a.rw) {
                    tx = a.cx - a.rw - rw - nw * 2.0 * 1.1;
                }
                if (ty > a.cy && ty - rh < a.cy + a.rh) {
                    ty = a.cy + a.rw + rw;
                }
                if (ty < a.cy && ty + rh > a.cy - a.rh) {
                    ty = a.cy - a.rh - rh;
                }
                double score = this.spatialCongestion(tx, ty) + (double)(this.boxOverlaps(tx - rw, ty - rh, 2.0 * rw, 2.0 * rh) ? 1000 : 0);
                if (th != 0.0 && !(score < bestScore)) continue;
                bestScore = score;
                bestX = tx;
                bestY = ty;
            }
            cx = bestX;
            cy = bestY;
        }
        if (nstr != null) {
            nx = cx + rw + 0.75 * nwad[0];
            ny = cy + 0.75 * rh;
        }
        APoint ah = new APoint();
        ah.anum = 0;
        ah.text = "H";
        ah.fsz = a.fsz;
        ah.bold = a.bold;
        ah.col = a.col;
        ah.cx = cx;
        ah.cy = cy;
        ah.rw = rw;
        ah.rh = rh;
        this.points.add(ah);
        if (nstr != null) {
            APoint an = new APoint();
            an.anum = 0;
            an.text = nstr;
            an.fsz = 0.5 * a.fsz;
            an.bold = a.bold;
            an.col = a.col;
            an.cx = nx;
            an.cy = ny;
            an.rw = nw;
            an.rh = nh;
            this.points.add(an);
        }
        return true;
    }

    private void adjustBondPosition(int bf, int bt, double x, double y) {
        for (int n = 0; n < this.numLines(); ++n) {
            BLine b = this.lines.get(n);
            if (this.mol.bondOrder(b.bnum) != 1 && this.mol.bondType(b.bnum) != 0) continue;
            if (this.mol.bondFrom(b.bnum) == bf && this.mol.bondTo(b.bnum) == bt) {
                b.x2 = x;
                b.y2 = y;
            }
            if (this.mol.bondFrom(b.bnum) != bt || this.mol.bondTo(b.bnum) != bf) continue;
            b.x1 = x;
            b.y1 = y;
        }
    }

    private int[] priorityDoubleSubstit(int N) {
        double theta;
        int n;
        int bf = this.mol.bondFrom(N);
        int bt = this.mol.bondTo(N);
        int[] nf = this.mol.atomAdjList(bf);
        int[] nt = this.mol.atomAdjList(bt);
        double x1 = this.pointCX(bf - 1);
        double y1 = this.pointCY(bf - 1);
        double x2 = this.pointCX(bt - 1);
        double y2 = this.pointCY(bt - 1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double btheta = Math.atan2(dy, dx);
        int idxFLeft = 0;
        int idxFRight = 0;
        int idxTLeft = 0;
        int idxTRight = 0;
        for (n = 0; n < nf.length; ++n) {
            if (nf[n] == bt) continue;
            theta = Util.angleDiff(Math.atan2(this.pointCY(nf[n] - 1) - y1, this.pointCX(nf[n] - 1) - x1), btheta);
            if (theta > 0.0) {
                if (idxFLeft != 0) {
                    return null;
                }
                idxFLeft = nf[n];
                continue;
            }
            if (idxFRight != 0) {
                return null;
            }
            idxFRight = nf[n];
        }
        for (n = 0; n < nt.length; ++n) {
            if (nt[n] == bf) continue;
            theta = Util.angleDiff(Math.atan2(this.pointCY(nt[n] - 1) - y2, this.pointCX(nt[n] - 1) - x2), btheta);
            if (theta > 0.0) {
                if (idxTLeft != 0) {
                    return null;
                }
                idxTLeft = nt[n];
                continue;
            }
            if (idxTRight != 0) {
                return null;
            }
            idxTRight = nt[n];
        }
        int sumFrom = (idxFLeft > 0 ? 1 : 0) + (idxFRight > 0 ? 1 : 0);
        int sumTo = (idxTLeft > 0 ? 1 : 0) + (idxTRight > 0 ? 1 : 0);
        if (sumFrom == 1 && sumTo == 0) {
            return new int[]{idxFLeft > 0 ? idxFLeft : idxFRight};
        }
        if (sumFrom == 0 && sumTo == 1) {
            return new int[]{idxTLeft > 0 ? idxTLeft : idxTRight};
        }
        if (sumFrom == 1 && sumTo == 1) {
            double congestRight;
            if (idxFLeft > 0 && idxTLeft > 0) {
                return new int[]{idxFLeft, idxTLeft};
            }
            if (idxFRight > 0 && idxTRight > 0) {
                return new int[]{idxFRight, idxTRight};
            }
            double[] oxy = this.orthogonalDelta(x1, y1, x2, y2, this.bondSep);
            double congestLeft = this.spatialCongestion(0.5 * (x1 + x2) + oxy[0], 0.5 * (y1 + y2) + oxy[1]);
            if (congestLeft < (congestRight = this.spatialCongestion(0.5 * (x1 + x2) - oxy[0], 0.5 * (y1 + y2) - oxy[1]))) {
                return new int[]{idxFLeft > 0 ? idxFLeft : idxTLeft};
            }
            return new int[]{idxFRight > 0 ? idxFRight : idxTRight};
        }
        if (sumFrom == 2 && sumTo == 1) {
            if (idxTLeft == 0) {
                return new int[]{idxFRight, idxTRight};
            }
            return new int[]{idxFLeft, idxTLeft};
        }
        if (sumFrom == 1 && sumTo == 2) {
            if (idxFLeft == 0) {
                return new int[]{idxFRight, idxTRight};
            }
            return new int[]{idxFLeft, idxTLeft};
        }
        return null;
    }

    private double[] lineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double u = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
        return new double[]{x1 + u * (x2 - x1), y1 + u * (y2 - y1)};
    }

    private double spatialCongestion(double x, double y) {
        double congest = 0.0;
        for (int n = 0; n < this.numPoints(); ++n) {
            congest += 1.0 / (Util.sqr(this.pointCX(n) - x) + Util.sqr(this.pointCY(n) - y));
        }
        return congest;
    }

    private boolean boxOverlaps(double x, double y, double w, double h) {
        int n;
        Rectangle2D.Double box = new Rectangle2D.Double(x, y, w, h);
        for (n = 0; n < this.numPoints(); ++n) {
            double ah;
            APoint a = this.points.get(n);
            double aw = Math.max(a.rw, 1.0);
            if (!box.intersects(a.cx - aw, a.cy - (ah = Math.max(a.rh, 1.0)), 2.0 * aw, 2.0 * ah)) continue;
            return true;
        }
        for (n = 0; n < this.numLines(); ++n) {
            BLine b = this.lines.get(n);
            double dx = b.x2 - b.x1;
            double dy = b.y2 - b.y1;
            if (!box.intersects(Math.min(b.x1, b.x2) - 1.0, Math.min(b.y1, b.y2) - 1.0, Math.abs(dx) + 2.0, Math.abs(dy) + 2.0)) continue;
            double stepsz = 0.025 * (w + h) / Math.sqrt(dx * dx + dy * dy);
            for (double v = 0.0; v <= 1.0; v += stepsz) {
                if (!box.contains(b.x1 + v * dx, b.y1 + v * dy)) continue;
                return true;
            }
        }
        return false;
    }

    private double[] anchorAnnotation(double px, double py, double rw, double rh) {
        double stepext;
        if (!this.boxOverlaps(px, py, rw, rh)) {
            return new double[]{px, py};
        }
        double ext = stepext = 0.25 * this.scale;
        boolean lastChance = false;
        while (true) {
            double bestX = 0.0;
            double bestY = 0.0;
            double bestScore = -1.0;
            for (double th = 0.0; th < Math.PI * 2; th += 0.08726646259971647) {
                double tx = px + ext * Math.cos(th);
                double ty = py + ext * Math.sin(th);
                if (!lastChance && this.boxOverlaps(tx - rw, ty - rh, 2.0 * rw, 2.0 * rh)) continue;
                double score = this.spatialCongestion(tx, ty);
                if (!(bestScore < 0.0) && !(score < bestScore)) continue;
                bestScore = score;
                bestX = tx;
                bestY = ty;
            }
            if (bestScore >= 0.0) {
                return new double[]{bestX, bestY};
            }
            if (!((ext += stepext) > 3.0 * this.scale)) continue;
            ext = rw + rh;
            lastChance = true;
        }
    }

    class BLine {
        int bnum;
        int type;
        double x1;
        double y1;
        double x2;
        double y2;
        double size;
        int col;

        BLine() {
        }

        BLine(int bnum, int type, double x1, double y1, double x2, double y2, double size, int col) {
            this.bnum = bnum;
            this.type = type;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.size = size;
            this.col = col;
        }
    }

    class APoint {
        int anum;
        String text;
        double fsz;
        boolean bold;
        int col;
        double cx;
        double cy;
        double rw;
        double rh;

        APoint() {
        }
    }
}

