/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 Marvell International Ltd.
 *
 * Configuration and status register (CSR) type definitions for
 * Octeon pcieepx.
 */

#ifndef __CVMX_PCIEEPX_DEFS_H__
#define __CVMX_PCIEEPX_DEFS_H__

static inline u64 CVMX_PCIEEPX_CFG000(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000000ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000000ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000000ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000000ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000000ull;
	}
	return 0x0000030000000000ull;
}

static inline u64 CVMX_PCIEEPX_CFG001(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000004ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000004ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000004ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000004ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000004ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000004ull;
	}
	return 0x0000030000000004ull;
}

static inline u64 CVMX_PCIEEPX_CFG002(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000008ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000008ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000008ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000008ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000008ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000008ull;
	}
	return 0x0000030000000008ull;
}

static inline u64 CVMX_PCIEEPX_CFG003(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000000Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000000Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000000Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000000Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000000Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000000Cull;
	}
	return 0x000003000000000Cull;
}

static inline u64 CVMX_PCIEEPX_CFG004(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000010ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000010ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000010ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000010ull;
	}
	return 0x0000030000000010ull;
}

static inline u64 CVMX_PCIEEPX_CFG004_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000010ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030080000010ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030080000010ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000080000010ull;
	}
	return 0x0000030080000010ull;
}

static inline u64 CVMX_PCIEEPX_CFG005(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000014ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000014ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000014ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000014ull;
	}
	return 0x0000030000000014ull;
}

static inline u64 CVMX_PCIEEPX_CFG005_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000014ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030080000014ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030080000014ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000080000014ull;
	}
	return 0x0000030080000014ull;
}

static inline u64 CVMX_PCIEEPX_CFG006(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000018ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000018ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000018ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000018ull;
	}
	return 0x0000030000000018ull;
}

static inline u64 CVMX_PCIEEPX_CFG006_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000018ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030080000018ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030080000018ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000080000018ull;
	}
	return 0x0000030080000018ull;
}

static inline u64 CVMX_PCIEEPX_CFG007(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000001Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000001Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000001Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000001Cull;
	}
	return 0x000003000000001Cull;
}

static inline u64 CVMX_PCIEEPX_CFG007_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003008000001Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003008000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003008000001Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003008000001Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003008000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000008000001Cull;
	}
	return 0x000003008000001Cull;
}

static inline u64 CVMX_PCIEEPX_CFG008(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000020ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000020ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000020ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000020ull;
	}
	return 0x0000030000000020ull;
}

static inline u64 CVMX_PCIEEPX_CFG008_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000020ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030080000020ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030080000020ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000080000020ull;
	}
	return 0x0000030080000020ull;
}

static inline u64 CVMX_PCIEEPX_CFG009(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000024ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000024ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000024ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000024ull;
	}
	return 0x0000030000000024ull;
}

static inline u64 CVMX_PCIEEPX_CFG009_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000024ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030080000024ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030080000024ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000080000024ull;
	}
	return 0x0000030080000024ull;
}

static inline u64 CVMX_PCIEEPX_CFG010(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000028ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000028ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000028ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000028ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000028ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000028ull;
	}
	return 0x0000030000000028ull;
}

static inline u64 CVMX_PCIEEPX_CFG011(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000002Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000002Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000002Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000002Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000002Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000002Cull;
	}
	return 0x000003000000002Cull;
}

static inline u64 CVMX_PCIEEPX_CFG012(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000030ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000030ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000030ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000030ull;
	}
	return 0x0000030000000030ull;
}

static inline u64 CVMX_PCIEEPX_CFG012_MASK(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000030ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030080000030ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030080000030ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030080000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000080000030ull;
	}
	return 0x0000030080000030ull;
}

static inline u64 CVMX_PCIEEPX_CFG013(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000034ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000034ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000034ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000034ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000034ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000034ull;
	}
	return 0x0000030000000034ull;
}

static inline u64 CVMX_PCIEEPX_CFG015(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000003Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000003Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000003Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000003Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000003Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000003Cull;
	}
	return 0x000003000000003Cull;
}

static inline u64 CVMX_PCIEEPX_CFG016(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000040ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000040ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000040ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000040ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000040ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000040ull;
	}
	return 0x0000030000000040ull;
}

static inline u64 CVMX_PCIEEPX_CFG017(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000044ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000044ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000044ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000044ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000044ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000044ull;
	}
	return 0x0000030000000044ull;
}

static inline u64 CVMX_PCIEEPX_CFG020(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000050ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000050ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000050ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000050ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000050ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000050ull;
	}
	return 0x0000030000000050ull;
}

static inline u64 CVMX_PCIEEPX_CFG021(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000054ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000054ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000054ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000054ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000054ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000054ull;
	}
	return 0x0000030000000054ull;
}

static inline u64 CVMX_PCIEEPX_CFG022(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000058ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000058ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000058ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000058ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000058ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000058ull;
	}
	return 0x0000030000000058ull;
}

static inline u64 CVMX_PCIEEPX_CFG023(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000005Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000005Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000005Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000005Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000005Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000005Cull;
	}
	return 0x000003000000005Cull;
}

static inline u64 CVMX_PCIEEPX_CFG024(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000060ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000060ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000060ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000060ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000060ull + (offset) * 0x100000000ull;
	}
	return 0x0000030000000060ull;
}

static inline u64 CVMX_PCIEEPX_CFG025(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000064ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000064ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000064ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000064ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000064ull + (offset) * 0x100000000ull;
	}
	return 0x0000030000000064ull;
}

static inline u64 CVMX_PCIEEPX_CFG028(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000070ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000070ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000070ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000070ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000070ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000070ull;
	}
	return 0x0000030000000070ull;
}

static inline u64 CVMX_PCIEEPX_CFG029(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000074ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000074ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000074ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000074ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000074ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000074ull;
	}
	return 0x0000030000000074ull;
}

static inline u64 CVMX_PCIEEPX_CFG030(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000078ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000078ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000078ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000078ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000078ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000078ull;
	}
	return 0x0000030000000078ull;
}

static inline u64 CVMX_PCIEEPX_CFG031(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000007Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000007Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000007Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000007Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000007Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000007Cull;
	}
	return 0x000003000000007Cull;
}

static inline u64 CVMX_PCIEEPX_CFG032(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000080ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000080ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000080ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000080ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000080ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000080ull;
	}
	return 0x0000030000000080ull;
}

#define CVMX_PCIEEPX_CFG033(offset) (0x0000000000000084ull)
#define CVMX_PCIEEPX_CFG034(offset) (0x0000000000000088ull)
static inline u64 CVMX_PCIEEPX_CFG037(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000094ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000094ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000094ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000094ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000094ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000094ull;
	}
	return 0x0000030000000094ull;
}

static inline u64 CVMX_PCIEEPX_CFG038(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000098ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000098ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000098ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000098ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000098ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000098ull;
	}
	return 0x0000030000000098ull;
}

static inline u64 CVMX_PCIEEPX_CFG039(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000009Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000009Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000009Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000009Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000009Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000009Cull;
	}
	return 0x000003000000009Cull;
}

static inline u64 CVMX_PCIEEPX_CFG040(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000A0ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000A0ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000000A0ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000000A0ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000A0ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000000A0ull;
	}
	return 0x00000300000000A0ull;
}

#define CVMX_PCIEEPX_CFG041(offset) (0x00000000000000A4ull)
#define CVMX_PCIEEPX_CFG042(offset) (0x00000000000000A8ull)
static inline u64 CVMX_PCIEEPX_CFG044(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000000B0ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000000B0ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000B0ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000B0ull;
	}
	return 0x00000300000000B0ull;
}

static inline u64 CVMX_PCIEEPX_CFG045(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000000B4ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000000B4ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000B4ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000B4ull;
	}
	return 0x00000300000000B4ull;
}

static inline u64 CVMX_PCIEEPX_CFG046(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000000B8ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000000B8ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000B8ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000000B8ull;
	}
	return 0x00000300000000B8ull;
}

static inline u64 CVMX_PCIEEPX_CFG064(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000100ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000100ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000100ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000100ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000100ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000100ull;
	}
	return 0x0000030000000100ull;
}

static inline u64 CVMX_PCIEEPX_CFG065(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000104ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000104ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000104ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000104ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000104ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000104ull;
	}
	return 0x0000030000000104ull;
}

static inline u64 CVMX_PCIEEPX_CFG066(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000108ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000108ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000108ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000108ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000108ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000108ull;
	}
	return 0x0000030000000108ull;
}

static inline u64 CVMX_PCIEEPX_CFG067(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000010Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000010Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000010Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000010Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000010Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000010Cull;
	}
	return 0x000003000000010Cull;
}

static inline u64 CVMX_PCIEEPX_CFG068(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000110ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000110ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000110ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000110ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000110ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000110ull;
	}
	return 0x0000030000000110ull;
}

static inline u64 CVMX_PCIEEPX_CFG069(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000114ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000114ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000114ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000114ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000114ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000114ull;
	}
	return 0x0000030000000114ull;
}

static inline u64 CVMX_PCIEEPX_CFG070(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000118ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000118ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000118ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000118ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000118ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000118ull;
	}
	return 0x0000030000000118ull;
}

static inline u64 CVMX_PCIEEPX_CFG071(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000011Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000011Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000011Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000011Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000011Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000011Cull;
	}
	return 0x000003000000011Cull;
}

static inline u64 CVMX_PCIEEPX_CFG072(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000120ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000120ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000120ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000120ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000120ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000120ull;
	}
	return 0x0000030000000120ull;
}

static inline u64 CVMX_PCIEEPX_CFG073(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000124ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000124ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000124ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000124ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000124ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000124ull;
	}
	return 0x0000030000000124ull;
}

static inline u64 CVMX_PCIEEPX_CFG074(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000128ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000128ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000128ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000128ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000128ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000128ull;
	}
	return 0x0000030000000128ull;
}

static inline u64 CVMX_PCIEEPX_CFG078(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000138ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000138ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000138ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000138ull;
	}
	return 0x0000030000000138ull;
}

static inline u64 CVMX_PCIEEPX_CFG082(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000148ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000148ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000148ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000148ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000148ull + (offset) * 0x100000000ull;
	}
	return 0x0000030000000148ull;
}

static inline u64 CVMX_PCIEEPX_CFG083(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000014Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000014Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000014Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000014Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000014Cull + (offset) * 0x100000000ull;
	}
	return 0x000003000000014Cull;
}

#define CVMX_PCIEEPX_CFG084(offset) (0x0000030000000150ull + ((offset) & 3) * 0x100000000ull)
static inline u64 CVMX_PCIEEPX_CFG086(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000158ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000158ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000158ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000158ull;
	}
	return 0x0000030000000158ull;
}

static inline u64 CVMX_PCIEEPX_CFG087(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000015Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000015Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000015Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000015Cull;
	}
	return 0x000003000000015Cull;
}

static inline u64 CVMX_PCIEEPX_CFG088(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000160ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000160ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000160ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000160ull;
	}
	return 0x0000030000000160ull;
}

static inline u64 CVMX_PCIEEPX_CFG089(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000164ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000164ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000164ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000164ull;
	}
	return 0x0000030000000164ull;
}

static inline u64 CVMX_PCIEEPX_CFG090(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000168ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000168ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000168ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000168ull;
	}
	return 0x0000030000000168ull;
}

static inline u64 CVMX_PCIEEPX_CFG091(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000016Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000016Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000016Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000016Cull;
	}
	return 0x000003000000016Cull;
}

static inline u64 CVMX_PCIEEPX_CFG092(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000170ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000170ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000170ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000170ull;
	}
	return 0x0000030000000170ull;
}

static inline u64 CVMX_PCIEEPX_CFG094(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000178ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000178ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000178ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000178ull;
	}
	return 0x0000030000000178ull;
}

static inline u64 CVMX_PCIEEPX_CFG095(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000017Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000017Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000017Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000017Cull;
	}
	return 0x000003000000017Cull;
}

static inline u64 CVMX_PCIEEPX_CFG096(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000180ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000180ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000180ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000180ull;
	}
	return 0x0000030000000180ull;
}

static inline u64 CVMX_PCIEEPX_CFG097(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000184ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000184ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000184ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000184ull;
	}
	return 0x0000030000000184ull;
}

static inline u64 CVMX_PCIEEPX_CFG098(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000188ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000188ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000188ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000188ull;
	}
	return 0x0000030000000188ull;
}

static inline u64 CVMX_PCIEEPX_CFG099(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000018Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000018Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000018Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000018Cull;
	}
	return 0x000003000000018Cull;
}

static inline u64 CVMX_PCIEEPX_CFG100(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000190ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000190ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000190ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000190ull;
	}
	return 0x0000030000000190ull;
}

static inline u64 CVMX_PCIEEPX_CFG101(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000194ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000194ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000194ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000194ull;
	}
	return 0x0000030000000194ull;
}

static inline u64 CVMX_PCIEEPX_CFG102(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000198ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000198ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000198ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000198ull;
	}
	return 0x0000030000000198ull;
}

static inline u64 CVMX_PCIEEPX_CFG103(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000019Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000019Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000019Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000019Cull;
	}
	return 0x000003000000019Cull;
}

static inline u64 CVMX_PCIEEPX_CFG104(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001A0ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001A0ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001A0ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001A0ull;
	}
	return 0x00000300000001A0ull;
}

static inline u64 CVMX_PCIEEPX_CFG105(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001A4ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001A4ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001A4ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001A4ull;
	}
	return 0x00000300000001A4ull;
}

static inline u64 CVMX_PCIEEPX_CFG106(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001A8ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001A8ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001A8ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001A8ull;
	}
	return 0x00000300000001A8ull;
}

static inline u64 CVMX_PCIEEPX_CFG107(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001ACull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001ACull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001ACull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001ACull;
	}
	return 0x00000300000001ACull;
}

static inline u64 CVMX_PCIEEPX_CFG108(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001B0ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001B0ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001B0ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001B0ull;
	}
	return 0x00000300000001B0ull;
}

static inline u64 CVMX_PCIEEPX_CFG109(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001B4ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001B4ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001B4ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001B4ull;
	}
	return 0x00000300000001B4ull;
}

static inline u64 CVMX_PCIEEPX_CFG110(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001B8ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001B8ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001B8ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001B8ull;
	}
	return 0x00000300000001B8ull;
}

static inline u64 CVMX_PCIEEPX_CFG111(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001BCull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001BCull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001BCull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001BCull;
	}
	return 0x00000300000001BCull;
}

static inline u64 CVMX_PCIEEPX_CFG112(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000001C0ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000001C0ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001C0ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000001C0ull;
	}
	return 0x00000300000001C0ull;
}

static inline u64 CVMX_PCIEEPX_CFG448(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000700ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000700ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000700ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000700ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000700ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000700ull;
	}
	return 0x0000030000000700ull;
}

static inline u64 CVMX_PCIEEPX_CFG449(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000704ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000704ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000704ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000704ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000704ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000704ull;
	}
	return 0x0000030000000704ull;
}

static inline u64 CVMX_PCIEEPX_CFG450(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000708ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000708ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000708ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000708ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000708ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000708ull;
	}
	return 0x0000030000000708ull;
}

static inline u64 CVMX_PCIEEPX_CFG451(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000070Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000070Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000070Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000070Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000070Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000070Cull;
	}
	return 0x000003000000070Cull;
}

static inline u64 CVMX_PCIEEPX_CFG452(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000710ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000710ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000710ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000710ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000710ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000710ull;
	}
	return 0x0000030000000710ull;
}

static inline u64 CVMX_PCIEEPX_CFG453(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000714ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000714ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000714ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000714ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000714ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000714ull;
	}
	return 0x0000030000000714ull;
}

static inline u64 CVMX_PCIEEPX_CFG454(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000718ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000718ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000718ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000718ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000718ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000718ull;
	}
	return 0x0000030000000718ull;
}

static inline u64 CVMX_PCIEEPX_CFG455(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000071Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000071Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000071Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000071Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000071Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000071Cull;
	}
	return 0x000003000000071Cull;
}

static inline u64 CVMX_PCIEEPX_CFG456(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000720ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000720ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000720ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000720ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000720ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000720ull;
	}
	return 0x0000030000000720ull;
}

static inline u64 CVMX_PCIEEPX_CFG458(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000728ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000728ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000728ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000728ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000728ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000728ull;
	}
	return 0x0000030000000728ull;
}

static inline u64 CVMX_PCIEEPX_CFG459(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000072Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000072Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000072Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000072Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000072Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000072Cull;
	}
	return 0x000003000000072Cull;
}

static inline u64 CVMX_PCIEEPX_CFG460(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000730ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000730ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000730ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000730ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000730ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000730ull;
	}
	return 0x0000030000000730ull;
}

static inline u64 CVMX_PCIEEPX_CFG461(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000734ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000734ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000734ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000734ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000734ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000734ull;
	}
	return 0x0000030000000734ull;
}

static inline u64 CVMX_PCIEEPX_CFG462(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000738ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000738ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000738ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000738ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000738ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000738ull;
	}
	return 0x0000030000000738ull;
}

static inline u64 CVMX_PCIEEPX_CFG463(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000073Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000073Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000073Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000073Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000073Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000073Cull;
	}
	return 0x000003000000073Cull;
}

static inline u64 CVMX_PCIEEPX_CFG464(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000740ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000740ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000740ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000740ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000740ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000740ull;
	}
	return 0x0000030000000740ull;
}

static inline u64 CVMX_PCIEEPX_CFG465(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000744ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000744ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000744ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000744ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000744ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000744ull;
	}
	return 0x0000030000000744ull;
}

static inline u64 CVMX_PCIEEPX_CFG466(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000748ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000748ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000748ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000748ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000748ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000748ull;
	}
	return 0x0000030000000748ull;
}

static inline u64 CVMX_PCIEEPX_CFG467(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000074Cull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000074Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000074Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000074Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000074Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000074Cull;
	}
	return 0x000003000000074Cull;
}

static inline u64 CVMX_PCIEEPX_CFG468(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000750ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000750ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000750ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000750ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000750ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000750ull;
	}
	return 0x0000030000000750ull;
}

static inline u64 CVMX_PCIEEPX_CFG490(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000007A8ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000300000007A8ull + (offset) * 0x100000000ull;
	}
	return 0x00000000000007A8ull;
}

static inline u64 CVMX_PCIEEPX_CFG491(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000007ACull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000300000007ACull + (offset) * 0x100000000ull;
	}
	return 0x00000000000007ACull;
}

static inline u64 CVMX_PCIEEPX_CFG492(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000007B0ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000300000007B0ull + (offset) * 0x100000000ull;
	}
	return 0x00000000000007B0ull;
}

static inline u64 CVMX_PCIEEPX_CFG515(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000003000000080Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000003000000080Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000003000000080Cull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000003000000080Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000003000000080Cull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000080Cull;
	}
	return 0x000003000000080Cull;
}

static inline u64 CVMX_PCIEEPX_CFG516(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000810ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000810ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000810ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000810ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000810ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000810ull;
	}
	return 0x0000030000000810ull;
}

static inline u64 CVMX_PCIEEPX_CFG517(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000814ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000814ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000814ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000814ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000814ull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000814ull;
	}
	return 0x0000030000000814ull;
}

static inline u64 CVMX_PCIEEPX_CFG548(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000030000000890ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000030000000890ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000890ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000030000000890ull;
	}
	return 0x0000030000000890ull;
}

static inline u64 CVMX_PCIEEPX_CFG554(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000008A8ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000008A8ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000008A8ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000008A8ull;
	}
	return 0x00000300000008A8ull;
}

static inline u64 CVMX_PCIEEPX_CFG558(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000008B8ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000008B8ull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000008B8ull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000008B8ull;
	}
	return 0x00000300000008B8ull;
}

static inline u64 CVMX_PCIEEPX_CFG559(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000300000008BCull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000300000008BCull + (offset) * 0x100000000ull;

	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000300000008BCull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000300000008BCull;
	}
	return 0x00000300000008BCull;
}

/**
 * cvmx_pcieep#_cfg000
 *
 * This register contains the first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg000 {
	u32 u32;
	struct cvmx_pcieepx_cfg000_s {
		u32 devid : 16;
		u32 vendid : 16;
	} s;
	struct cvmx_pcieepx_cfg000_s cn52xx;
	struct cvmx_pcieepx_cfg000_s cn52xxp1;
	struct cvmx_pcieepx_cfg000_s cn56xx;
	struct cvmx_pcieepx_cfg000_s cn56xxp1;
	struct cvmx_pcieepx_cfg000_s cn61xx;
	struct cvmx_pcieepx_cfg000_s cn63xx;
	struct cvmx_pcieepx_cfg000_s cn63xxp1;
	struct cvmx_pcieepx_cfg000_s cn66xx;
	struct cvmx_pcieepx_cfg000_s cn68xx;
	struct cvmx_pcieepx_cfg000_s cn68xxp1;
	struct cvmx_pcieepx_cfg000_s cn70xx;
	struct cvmx_pcieepx_cfg000_s cn70xxp1;
	struct cvmx_pcieepx_cfg000_s cn73xx;
	struct cvmx_pcieepx_cfg000_s cn78xx;
	struct cvmx_pcieepx_cfg000_s cn78xxp1;
	struct cvmx_pcieepx_cfg000_s cnf71xx;
	struct cvmx_pcieepx_cfg000_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg000 cvmx_pcieepx_cfg000_t;

/**
 * cvmx_pcieep#_cfg001
 *
 * This register contains the second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg001 {
	u32 u32;
	struct cvmx_pcieepx_cfg001_s {
		u32 dpe : 1;
		u32 sse : 1;
		u32 rma : 1;
		u32 rta : 1;
		u32 sta : 1;
		u32 devt : 2;
		u32 mdpe : 1;
		u32 fbb : 1;
		u32 reserved_22_22 : 1;
		u32 m66 : 1;
		u32 cl : 1;
		u32 i_stat : 1;
		u32 reserved_11_18 : 8;
		u32 i_dis : 1;
		u32 fbbe : 1;
		u32 see : 1;
		u32 ids_wcc : 1;
		u32 per : 1;
		u32 vps : 1;
		u32 mwice : 1;
		u32 scse : 1;
		u32 me : 1;
		u32 msae : 1;
		u32 isae : 1;
	} s;
	struct cvmx_pcieepx_cfg001_s cn52xx;
	struct cvmx_pcieepx_cfg001_s cn52xxp1;
	struct cvmx_pcieepx_cfg001_s cn56xx;
	struct cvmx_pcieepx_cfg001_s cn56xxp1;
	struct cvmx_pcieepx_cfg001_s cn61xx;
	struct cvmx_pcieepx_cfg001_s cn63xx;
	struct cvmx_pcieepx_cfg001_s cn63xxp1;
	struct cvmx_pcieepx_cfg001_s cn66xx;
	struct cvmx_pcieepx_cfg001_s cn68xx;
	struct cvmx_pcieepx_cfg001_s cn68xxp1;
	struct cvmx_pcieepx_cfg001_s cn70xx;
	struct cvmx_pcieepx_cfg001_s cn70xxp1;
	struct cvmx_pcieepx_cfg001_s cn73xx;
	struct cvmx_pcieepx_cfg001_s cn78xx;
	struct cvmx_pcieepx_cfg001_s cn78xxp1;
	struct cvmx_pcieepx_cfg001_s cnf71xx;
	struct cvmx_pcieepx_cfg001_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg001 cvmx_pcieepx_cfg001_t;

/**
 * cvmx_pcieep#_cfg002
 *
 * This register contains the third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg002 {
	u32 u32;
	struct cvmx_pcieepx_cfg002_s {
		u32 bcc : 8;
		u32 sc : 8;
		u32 pi : 8;
		u32 rid : 8;
	} s;
	struct cvmx_pcieepx_cfg002_s cn52xx;
	struct cvmx_pcieepx_cfg002_s cn52xxp1;
	struct cvmx_pcieepx_cfg002_s cn56xx;
	struct cvmx_pcieepx_cfg002_s cn56xxp1;
	struct cvmx_pcieepx_cfg002_s cn61xx;
	struct cvmx_pcieepx_cfg002_s cn63xx;
	struct cvmx_pcieepx_cfg002_s cn63xxp1;
	struct cvmx_pcieepx_cfg002_s cn66xx;
	struct cvmx_pcieepx_cfg002_s cn68xx;
	struct cvmx_pcieepx_cfg002_s cn68xxp1;
	struct cvmx_pcieepx_cfg002_s cn70xx;
	struct cvmx_pcieepx_cfg002_s cn70xxp1;
	struct cvmx_pcieepx_cfg002_s cn73xx;
	struct cvmx_pcieepx_cfg002_s cn78xx;
	struct cvmx_pcieepx_cfg002_s cn78xxp1;
	struct cvmx_pcieepx_cfg002_s cnf71xx;
	struct cvmx_pcieepx_cfg002_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg002 cvmx_pcieepx_cfg002_t;

/**
 * cvmx_pcieep#_cfg003
 *
 * This register contains the fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg003 {
	u32 u32;
	struct cvmx_pcieepx_cfg003_s {
		u32 bist : 8;
		u32 mfd : 1;
		u32 chf : 7;
		u32 lt : 8;
		u32 cls : 8;
	} s;
	struct cvmx_pcieepx_cfg003_s cn52xx;
	struct cvmx_pcieepx_cfg003_s cn52xxp1;
	struct cvmx_pcieepx_cfg003_s cn56xx;
	struct cvmx_pcieepx_cfg003_s cn56xxp1;
	struct cvmx_pcieepx_cfg003_s cn61xx;
	struct cvmx_pcieepx_cfg003_s cn63xx;
	struct cvmx_pcieepx_cfg003_s cn63xxp1;
	struct cvmx_pcieepx_cfg003_s cn66xx;
	struct cvmx_pcieepx_cfg003_s cn68xx;
	struct cvmx_pcieepx_cfg003_s cn68xxp1;
	struct cvmx_pcieepx_cfg003_s cn70xx;
	struct cvmx_pcieepx_cfg003_s cn70xxp1;
	struct cvmx_pcieepx_cfg003_s cn73xx;
	struct cvmx_pcieepx_cfg003_s cn78xx;
	struct cvmx_pcieepx_cfg003_s cn78xxp1;
	struct cvmx_pcieepx_cfg003_s cnf71xx;
	struct cvmx_pcieepx_cfg003_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg003 cvmx_pcieepx_cfg003_t;

/**
 * cvmx_pcieep#_cfg004
 *
 * This register contains the fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg004 {
	u32 u32;
	struct cvmx_pcieepx_cfg004_s {
		u32 reserved_4_31 : 28;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} s;
	struct cvmx_pcieepx_cfg004_cn52xx {
		u32 lbab : 18;
		u32 reserved_4_13 : 10;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg004_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg004_cn52xx cn61xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg004_cn52xx cn66xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn68xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg004_cn52xx cn70xx;
	struct cvmx_pcieepx_cfg004_cn52xx cn70xxp1;
	struct cvmx_pcieepx_cfg004_cn73xx {
		u32 lbab : 9;
		u32 reserved_4_22 : 19;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} cn73xx;
	struct cvmx_pcieepx_cfg004_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg004_cn78xxp1 {
		u32 lbab : 17;
		u32 reserved_4_14 : 11;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} cn78xxp1;
	struct cvmx_pcieepx_cfg004_cn52xx cnf71xx;
	struct cvmx_pcieepx_cfg004_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg004 cvmx_pcieepx_cfg004_t;

/**
 * cvmx_pcieep#_cfg004_mask
 *
 * The BAR 0 mask register is invisible to host software and not readable from the application.
 * The BAR 0 mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg004_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg004_mask_s {
		u32 lmask : 31;
		u32 enb : 1;
	} s;
	struct cvmx_pcieepx_cfg004_mask_s cn52xx;
	struct cvmx_pcieepx_cfg004_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg004_mask_s cn56xx;
	struct cvmx_pcieepx_cfg004_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg004_mask_s cn61xx;
	struct cvmx_pcieepx_cfg004_mask_s cn63xx;
	struct cvmx_pcieepx_cfg004_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg004_mask_s cn66xx;
	struct cvmx_pcieepx_cfg004_mask_s cn68xx;
	struct cvmx_pcieepx_cfg004_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg004_mask_s cn70xx;
	struct cvmx_pcieepx_cfg004_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg004_mask_s cn73xx;
	struct cvmx_pcieepx_cfg004_mask_s cn78xx;
	struct cvmx_pcieepx_cfg004_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg004_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg004_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg004_mask cvmx_pcieepx_cfg004_mask_t;

/**
 * cvmx_pcieep#_cfg005
 *
 * This register contains the sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg005 {
	u32 u32;
	struct cvmx_pcieepx_cfg005_s {
		u32 ubab : 32;
	} s;
	struct cvmx_pcieepx_cfg005_s cn52xx;
	struct cvmx_pcieepx_cfg005_s cn52xxp1;
	struct cvmx_pcieepx_cfg005_s cn56xx;
	struct cvmx_pcieepx_cfg005_s cn56xxp1;
	struct cvmx_pcieepx_cfg005_s cn61xx;
	struct cvmx_pcieepx_cfg005_s cn63xx;
	struct cvmx_pcieepx_cfg005_s cn63xxp1;
	struct cvmx_pcieepx_cfg005_s cn66xx;
	struct cvmx_pcieepx_cfg005_s cn68xx;
	struct cvmx_pcieepx_cfg005_s cn68xxp1;
	struct cvmx_pcieepx_cfg005_s cn70xx;
	struct cvmx_pcieepx_cfg005_s cn70xxp1;
	struct cvmx_pcieepx_cfg005_s cn73xx;
	struct cvmx_pcieepx_cfg005_s cn78xx;
	struct cvmx_pcieepx_cfg005_s cn78xxp1;
	struct cvmx_pcieepx_cfg005_s cnf71xx;
	struct cvmx_pcieepx_cfg005_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg005 cvmx_pcieepx_cfg005_t;

/**
 * cvmx_pcieep#_cfg005_mask
 *
 * The BAR 0 mask register is invisible to host software and not readable from the application.
 * The BAR 0 mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg005_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg005_mask_s {
		u32 umask : 32;
	} s;
	struct cvmx_pcieepx_cfg005_mask_s cn52xx;
	struct cvmx_pcieepx_cfg005_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg005_mask_s cn56xx;
	struct cvmx_pcieepx_cfg005_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg005_mask_s cn61xx;
	struct cvmx_pcieepx_cfg005_mask_s cn63xx;
	struct cvmx_pcieepx_cfg005_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg005_mask_s cn66xx;
	struct cvmx_pcieepx_cfg005_mask_s cn68xx;
	struct cvmx_pcieepx_cfg005_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg005_mask_s cn70xx;
	struct cvmx_pcieepx_cfg005_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg005_mask_s cn73xx;
	struct cvmx_pcieepx_cfg005_mask_s cn78xx;
	struct cvmx_pcieepx_cfg005_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg005_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg005_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg005_mask cvmx_pcieepx_cfg005_mask_t;

/**
 * cvmx_pcieep#_cfg006
 *
 * This register contains the seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg006 {
	u32 u32;
	struct cvmx_pcieepx_cfg006_s {
		u32 lbab : 6;
		u32 reserved_4_25 : 22;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} s;
	struct cvmx_pcieepx_cfg006_s cn52xx;
	struct cvmx_pcieepx_cfg006_s cn52xxp1;
	struct cvmx_pcieepx_cfg006_s cn56xx;
	struct cvmx_pcieepx_cfg006_s cn56xxp1;
	struct cvmx_pcieepx_cfg006_s cn61xx;
	struct cvmx_pcieepx_cfg006_s cn63xx;
	struct cvmx_pcieepx_cfg006_s cn63xxp1;
	struct cvmx_pcieepx_cfg006_s cn66xx;
	struct cvmx_pcieepx_cfg006_s cn68xx;
	struct cvmx_pcieepx_cfg006_s cn68xxp1;
	struct cvmx_pcieepx_cfg006_s cn70xx;
	struct cvmx_pcieepx_cfg006_s cn70xxp1;
	struct cvmx_pcieepx_cfg006_s cn73xx;
	struct cvmx_pcieepx_cfg006_s cn78xx;
	struct cvmx_pcieepx_cfg006_s cn78xxp1;
	struct cvmx_pcieepx_cfg006_s cnf71xx;
	struct cvmx_pcieepx_cfg006_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg006 cvmx_pcieepx_cfg006_t;

/**
 * cvmx_pcieep#_cfg006_mask
 *
 * The BAR 1 mask register is invisible to host software and not readable from the application.
 * The BAR 1 mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg006_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg006_mask_s {
		u32 lmask : 31;
		u32 enb : 1;
	} s;
	struct cvmx_pcieepx_cfg006_mask_s cn52xx;
	struct cvmx_pcieepx_cfg006_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg006_mask_s cn56xx;
	struct cvmx_pcieepx_cfg006_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg006_mask_s cn61xx;
	struct cvmx_pcieepx_cfg006_mask_s cn63xx;
	struct cvmx_pcieepx_cfg006_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg006_mask_s cn66xx;
	struct cvmx_pcieepx_cfg006_mask_s cn68xx;
	struct cvmx_pcieepx_cfg006_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg006_mask_s cn70xx;
	struct cvmx_pcieepx_cfg006_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg006_mask_s cn73xx;
	struct cvmx_pcieepx_cfg006_mask_s cn78xx;
	struct cvmx_pcieepx_cfg006_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg006_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg006_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg006_mask cvmx_pcieepx_cfg006_mask_t;

/**
 * cvmx_pcieep#_cfg007
 *
 * This register contains the eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg007 {
	u32 u32;
	struct cvmx_pcieepx_cfg007_s {
		u32 ubab : 32;
	} s;
	struct cvmx_pcieepx_cfg007_s cn52xx;
	struct cvmx_pcieepx_cfg007_s cn52xxp1;
	struct cvmx_pcieepx_cfg007_s cn56xx;
	struct cvmx_pcieepx_cfg007_s cn56xxp1;
	struct cvmx_pcieepx_cfg007_s cn61xx;
	struct cvmx_pcieepx_cfg007_s cn63xx;
	struct cvmx_pcieepx_cfg007_s cn63xxp1;
	struct cvmx_pcieepx_cfg007_s cn66xx;
	struct cvmx_pcieepx_cfg007_s cn68xx;
	struct cvmx_pcieepx_cfg007_s cn68xxp1;
	struct cvmx_pcieepx_cfg007_s cn70xx;
	struct cvmx_pcieepx_cfg007_s cn70xxp1;
	struct cvmx_pcieepx_cfg007_s cn73xx;
	struct cvmx_pcieepx_cfg007_s cn78xx;
	struct cvmx_pcieepx_cfg007_s cn78xxp1;
	struct cvmx_pcieepx_cfg007_s cnf71xx;
	struct cvmx_pcieepx_cfg007_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg007 cvmx_pcieepx_cfg007_t;

/**
 * cvmx_pcieep#_cfg007_mask
 *
 * The BAR 1 mask register is invisible to host software and not readable from the application.
 * The BAR 1 mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg007_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg007_mask_s {
		u32 umask : 32;
	} s;
	struct cvmx_pcieepx_cfg007_mask_s cn52xx;
	struct cvmx_pcieepx_cfg007_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg007_mask_s cn56xx;
	struct cvmx_pcieepx_cfg007_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg007_mask_s cn61xx;
	struct cvmx_pcieepx_cfg007_mask_s cn63xx;
	struct cvmx_pcieepx_cfg007_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg007_mask_s cn66xx;
	struct cvmx_pcieepx_cfg007_mask_s cn68xx;
	struct cvmx_pcieepx_cfg007_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg007_mask_s cn70xx;
	struct cvmx_pcieepx_cfg007_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg007_mask_s cn73xx;
	struct cvmx_pcieepx_cfg007_mask_s cn78xx;
	struct cvmx_pcieepx_cfg007_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg007_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg007_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg007_mask cvmx_pcieepx_cfg007_mask_t;

/**
 * cvmx_pcieep#_cfg008
 *
 * This register contains the ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg008 {
	u32 u32;
	struct cvmx_pcieepx_cfg008_s {
		u32 lbab : 12;
		u32 reserved_4_19 : 16;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} s;
	struct cvmx_pcieepx_cfg008_cn52xx {
		u32 reserved_4_31 : 28;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg008_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg008_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg008_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg008_cn52xx cn61xx;
	struct cvmx_pcieepx_cfg008_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg008_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg008_cn52xx cn66xx;
	struct cvmx_pcieepx_cfg008_cn52xx cn68xx;
	struct cvmx_pcieepx_cfg008_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg008_s cn70xx;
	struct cvmx_pcieepx_cfg008_s cn70xxp1;
	struct cvmx_pcieepx_cfg008_s cn73xx;
	struct cvmx_pcieepx_cfg008_s cn78xx;
	struct cvmx_pcieepx_cfg008_s cn78xxp1;
	struct cvmx_pcieepx_cfg008_cn52xx cnf71xx;
	struct cvmx_pcieepx_cfg008_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg008 cvmx_pcieepx_cfg008_t;

/**
 * cvmx_pcieep#_cfg008_mask
 *
 * The BAR 2 mask register is invisible to host software and not readable from the application.
 * The BAR 2 mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg008_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg008_mask_s {
		u32 lmask : 31;
		u32 enb : 1;
	} s;
	struct cvmx_pcieepx_cfg008_mask_s cn52xx;
	struct cvmx_pcieepx_cfg008_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg008_mask_s cn56xx;
	struct cvmx_pcieepx_cfg008_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg008_mask_s cn61xx;
	struct cvmx_pcieepx_cfg008_mask_s cn63xx;
	struct cvmx_pcieepx_cfg008_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg008_mask_s cn66xx;
	struct cvmx_pcieepx_cfg008_mask_s cn68xx;
	struct cvmx_pcieepx_cfg008_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg008_mask_s cn70xx;
	struct cvmx_pcieepx_cfg008_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg008_mask_s cn73xx;
	struct cvmx_pcieepx_cfg008_mask_s cn78xx;
	struct cvmx_pcieepx_cfg008_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg008_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg008_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg008_mask cvmx_pcieepx_cfg008_mask_t;

/**
 * cvmx_pcieep#_cfg009
 *
 * This register contains the tenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg009 {
	u32 u32;
	struct cvmx_pcieepx_cfg009_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg009_cn52xx {
		u32 ubab : 25;
		u32 reserved_0_6 : 7;
	} cn52xx;
	struct cvmx_pcieepx_cfg009_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg009_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg009_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg009_cn61xx {
		u32 ubab : 23;
		u32 reserved_0_8 : 9;
	} cn61xx;
	struct cvmx_pcieepx_cfg009_cn61xx cn63xx;
	struct cvmx_pcieepx_cfg009_cn61xx cn63xxp1;
	struct cvmx_pcieepx_cfg009_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg009_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg009_cn61xx cn68xxp1;
	struct cvmx_pcieepx_cfg009_cn70xx {
		u32 ubab : 32;
	} cn70xx;
	struct cvmx_pcieepx_cfg009_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg009_cn70xx cn73xx;
	struct cvmx_pcieepx_cfg009_cn70xx cn78xx;
	struct cvmx_pcieepx_cfg009_cn70xx cn78xxp1;
	struct cvmx_pcieepx_cfg009_cn61xx cnf71xx;
	struct cvmx_pcieepx_cfg009_cn70xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg009 cvmx_pcieepx_cfg009_t;

/**
 * cvmx_pcieep#_cfg009_mask
 *
 * The BAR 2 mask register is invisible to host software and not readable from the application.
 * The BAR 2 mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg009_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg009_mask_s {
		u32 umask : 32;
	} s;
	struct cvmx_pcieepx_cfg009_mask_s cn52xx;
	struct cvmx_pcieepx_cfg009_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg009_mask_s cn56xx;
	struct cvmx_pcieepx_cfg009_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg009_mask_s cn61xx;
	struct cvmx_pcieepx_cfg009_mask_s cn63xx;
	struct cvmx_pcieepx_cfg009_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg009_mask_s cn66xx;
	struct cvmx_pcieepx_cfg009_mask_s cn68xx;
	struct cvmx_pcieepx_cfg009_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg009_mask_s cn70xx;
	struct cvmx_pcieepx_cfg009_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg009_mask_s cn73xx;
	struct cvmx_pcieepx_cfg009_mask_s cn78xx;
	struct cvmx_pcieepx_cfg009_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg009_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg009_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg009_mask cvmx_pcieepx_cfg009_mask_t;

/**
 * cvmx_pcieep#_cfg010
 *
 * This register contains the eleventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg010 {
	u32 u32;
	struct cvmx_pcieepx_cfg010_s {
		u32 cisp : 32;
	} s;
	struct cvmx_pcieepx_cfg010_s cn52xx;
	struct cvmx_pcieepx_cfg010_s cn52xxp1;
	struct cvmx_pcieepx_cfg010_s cn56xx;
	struct cvmx_pcieepx_cfg010_s cn56xxp1;
	struct cvmx_pcieepx_cfg010_s cn61xx;
	struct cvmx_pcieepx_cfg010_s cn63xx;
	struct cvmx_pcieepx_cfg010_s cn63xxp1;
	struct cvmx_pcieepx_cfg010_s cn66xx;
	struct cvmx_pcieepx_cfg010_s cn68xx;
	struct cvmx_pcieepx_cfg010_s cn68xxp1;
	struct cvmx_pcieepx_cfg010_s cn70xx;
	struct cvmx_pcieepx_cfg010_s cn70xxp1;
	struct cvmx_pcieepx_cfg010_s cn73xx;
	struct cvmx_pcieepx_cfg010_s cn78xx;
	struct cvmx_pcieepx_cfg010_s cn78xxp1;
	struct cvmx_pcieepx_cfg010_s cnf71xx;
	struct cvmx_pcieepx_cfg010_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg010 cvmx_pcieepx_cfg010_t;

/**
 * cvmx_pcieep#_cfg011
 *
 * This register contains the twelfth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg011 {
	u32 u32;
	struct cvmx_pcieepx_cfg011_s {
		u32 ssid : 16;
		u32 ssvid : 16;
	} s;
	struct cvmx_pcieepx_cfg011_s cn52xx;
	struct cvmx_pcieepx_cfg011_s cn52xxp1;
	struct cvmx_pcieepx_cfg011_s cn56xx;
	struct cvmx_pcieepx_cfg011_s cn56xxp1;
	struct cvmx_pcieepx_cfg011_s cn61xx;
	struct cvmx_pcieepx_cfg011_s cn63xx;
	struct cvmx_pcieepx_cfg011_s cn63xxp1;
	struct cvmx_pcieepx_cfg011_s cn66xx;
	struct cvmx_pcieepx_cfg011_s cn68xx;
	struct cvmx_pcieepx_cfg011_s cn68xxp1;
	struct cvmx_pcieepx_cfg011_s cn70xx;
	struct cvmx_pcieepx_cfg011_s cn70xxp1;
	struct cvmx_pcieepx_cfg011_s cn73xx;
	struct cvmx_pcieepx_cfg011_s cn78xx;
	struct cvmx_pcieepx_cfg011_s cn78xxp1;
	struct cvmx_pcieepx_cfg011_s cnf71xx;
	struct cvmx_pcieepx_cfg011_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg011 cvmx_pcieepx_cfg011_t;

/**
 * cvmx_pcieep#_cfg012
 *
 * This register contains the thirteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg012 {
	u32 u32;
	struct cvmx_pcieepx_cfg012_s {
		u32 eraddr : 16;
		u32 reserved_1_15 : 15;
		u32 er_en : 1;
	} s;
	struct cvmx_pcieepx_cfg012_s cn52xx;
	struct cvmx_pcieepx_cfg012_s cn52xxp1;
	struct cvmx_pcieepx_cfg012_s cn56xx;
	struct cvmx_pcieepx_cfg012_s cn56xxp1;
	struct cvmx_pcieepx_cfg012_s cn61xx;
	struct cvmx_pcieepx_cfg012_s cn63xx;
	struct cvmx_pcieepx_cfg012_s cn63xxp1;
	struct cvmx_pcieepx_cfg012_s cn66xx;
	struct cvmx_pcieepx_cfg012_s cn68xx;
	struct cvmx_pcieepx_cfg012_s cn68xxp1;
	struct cvmx_pcieepx_cfg012_s cn70xx;
	struct cvmx_pcieepx_cfg012_s cn70xxp1;
	struct cvmx_pcieepx_cfg012_s cn73xx;
	struct cvmx_pcieepx_cfg012_s cn78xx;
	struct cvmx_pcieepx_cfg012_s cn78xxp1;
	struct cvmx_pcieepx_cfg012_s cnf71xx;
	struct cvmx_pcieepx_cfg012_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg012 cvmx_pcieepx_cfg012_t;

/**
 * cvmx_pcieep#_cfg012_mask
 *
 * The ROM mask register is invisible to host software and not readable from the application. The
 * ROM mask register is only writable through PEM()_CFG_WR.
 */
union cvmx_pcieepx_cfg012_mask {
	u32 u32;
	struct cvmx_pcieepx_cfg012_mask_s {
		u32 mask : 31;
		u32 enb : 1;
	} s;
	struct cvmx_pcieepx_cfg012_mask_s cn52xx;
	struct cvmx_pcieepx_cfg012_mask_s cn52xxp1;
	struct cvmx_pcieepx_cfg012_mask_s cn56xx;
	struct cvmx_pcieepx_cfg012_mask_s cn56xxp1;
	struct cvmx_pcieepx_cfg012_mask_s cn61xx;
	struct cvmx_pcieepx_cfg012_mask_s cn63xx;
	struct cvmx_pcieepx_cfg012_mask_s cn63xxp1;
	struct cvmx_pcieepx_cfg012_mask_s cn66xx;
	struct cvmx_pcieepx_cfg012_mask_s cn68xx;
	struct cvmx_pcieepx_cfg012_mask_s cn68xxp1;
	struct cvmx_pcieepx_cfg012_mask_s cn70xx;
	struct cvmx_pcieepx_cfg012_mask_s cn70xxp1;
	struct cvmx_pcieepx_cfg012_mask_s cn73xx;
	struct cvmx_pcieepx_cfg012_mask_s cn78xx;
	struct cvmx_pcieepx_cfg012_mask_s cn78xxp1;
	struct cvmx_pcieepx_cfg012_mask_s cnf71xx;
	struct cvmx_pcieepx_cfg012_mask_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg012_mask cvmx_pcieepx_cfg012_mask_t;

/**
 * cvmx_pcieep#_cfg013
 *
 * This register contains the fourteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg013 {
	u32 u32;
	struct cvmx_pcieepx_cfg013_s {
		u32 reserved_8_31 : 24;
		u32 cp : 8;
	} s;
	struct cvmx_pcieepx_cfg013_s cn52xx;
	struct cvmx_pcieepx_cfg013_s cn52xxp1;
	struct cvmx_pcieepx_cfg013_s cn56xx;
	struct cvmx_pcieepx_cfg013_s cn56xxp1;
	struct cvmx_pcieepx_cfg013_s cn61xx;
	struct cvmx_pcieepx_cfg013_s cn63xx;
	struct cvmx_pcieepx_cfg013_s cn63xxp1;
	struct cvmx_pcieepx_cfg013_s cn66xx;
	struct cvmx_pcieepx_cfg013_s cn68xx;
	struct cvmx_pcieepx_cfg013_s cn68xxp1;
	struct cvmx_pcieepx_cfg013_s cn70xx;
	struct cvmx_pcieepx_cfg013_s cn70xxp1;
	struct cvmx_pcieepx_cfg013_s cn73xx;
	struct cvmx_pcieepx_cfg013_s cn78xx;
	struct cvmx_pcieepx_cfg013_s cn78xxp1;
	struct cvmx_pcieepx_cfg013_s cnf71xx;
	struct cvmx_pcieepx_cfg013_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg013 cvmx_pcieepx_cfg013_t;

/**
 * cvmx_pcieep#_cfg015
 *
 * This register contains the sixteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg015 {
	u32 u32;
	struct cvmx_pcieepx_cfg015_s {
		u32 ml : 8;
		u32 mg : 8;
		u32 inta : 8;
		u32 il : 8;
	} s;
	struct cvmx_pcieepx_cfg015_s cn52xx;
	struct cvmx_pcieepx_cfg015_s cn52xxp1;
	struct cvmx_pcieepx_cfg015_s cn56xx;
	struct cvmx_pcieepx_cfg015_s cn56xxp1;
	struct cvmx_pcieepx_cfg015_s cn61xx;
	struct cvmx_pcieepx_cfg015_s cn63xx;
	struct cvmx_pcieepx_cfg015_s cn63xxp1;
	struct cvmx_pcieepx_cfg015_s cn66xx;
	struct cvmx_pcieepx_cfg015_s cn68xx;
	struct cvmx_pcieepx_cfg015_s cn68xxp1;
	struct cvmx_pcieepx_cfg015_s cn70xx;
	struct cvmx_pcieepx_cfg015_s cn70xxp1;
	struct cvmx_pcieepx_cfg015_s cn73xx;
	struct cvmx_pcieepx_cfg015_s cn78xx;
	struct cvmx_pcieepx_cfg015_s cn78xxp1;
	struct cvmx_pcieepx_cfg015_s cnf71xx;
	struct cvmx_pcieepx_cfg015_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg015 cvmx_pcieepx_cfg015_t;

/**
 * cvmx_pcieep#_cfg016
 *
 * This register contains the seventeenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg016 {
	u32 u32;
	struct cvmx_pcieepx_cfg016_s {
		u32 pmes : 5;
		u32 d2s : 1;
		u32 d1s : 1;
		u32 auxc : 3;
		u32 dsi : 1;
		u32 reserved_20_20 : 1;
		u32 pme_clock : 1;
		u32 pmsv : 3;
		u32 ncp : 8;
		u32 pmcid : 8;
	} s;
	struct cvmx_pcieepx_cfg016_s cn52xx;
	struct cvmx_pcieepx_cfg016_s cn52xxp1;
	struct cvmx_pcieepx_cfg016_s cn56xx;
	struct cvmx_pcieepx_cfg016_s cn56xxp1;
	struct cvmx_pcieepx_cfg016_s cn61xx;
	struct cvmx_pcieepx_cfg016_s cn63xx;
	struct cvmx_pcieepx_cfg016_s cn63xxp1;
	struct cvmx_pcieepx_cfg016_s cn66xx;
	struct cvmx_pcieepx_cfg016_s cn68xx;
	struct cvmx_pcieepx_cfg016_s cn68xxp1;
	struct cvmx_pcieepx_cfg016_s cn70xx;
	struct cvmx_pcieepx_cfg016_s cn70xxp1;
	struct cvmx_pcieepx_cfg016_s cn73xx;
	struct cvmx_pcieepx_cfg016_s cn78xx;
	struct cvmx_pcieepx_cfg016_s cn78xxp1;
	struct cvmx_pcieepx_cfg016_s cnf71xx;
	struct cvmx_pcieepx_cfg016_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg016 cvmx_pcieepx_cfg016_t;

/**
 * cvmx_pcieep#_cfg017
 *
 * This register contains the eighteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg017 {
	u32 u32;
	struct cvmx_pcieepx_cfg017_s {
		u32 pmdia : 8;
		u32 bpccee : 1;
		u32 bd3h : 1;
		u32 reserved_16_21 : 6;
		u32 pmess : 1;
		u32 pmedsia : 2;
		u32 pmds : 4;
		u32 pmeens : 1;
		u32 reserved_4_7 : 4;
		u32 nsr : 1;
		u32 reserved_2_2 : 1;
		u32 ps : 2;
	} s;
	struct cvmx_pcieepx_cfg017_s cn52xx;
	struct cvmx_pcieepx_cfg017_s cn52xxp1;
	struct cvmx_pcieepx_cfg017_s cn56xx;
	struct cvmx_pcieepx_cfg017_s cn56xxp1;
	struct cvmx_pcieepx_cfg017_s cn61xx;
	struct cvmx_pcieepx_cfg017_s cn63xx;
	struct cvmx_pcieepx_cfg017_s cn63xxp1;
	struct cvmx_pcieepx_cfg017_s cn66xx;
	struct cvmx_pcieepx_cfg017_s cn68xx;
	struct cvmx_pcieepx_cfg017_s cn68xxp1;
	struct cvmx_pcieepx_cfg017_s cn70xx;
	struct cvmx_pcieepx_cfg017_s cn70xxp1;
	struct cvmx_pcieepx_cfg017_s cn73xx;
	struct cvmx_pcieepx_cfg017_s cn78xx;
	struct cvmx_pcieepx_cfg017_s cn78xxp1;
	struct cvmx_pcieepx_cfg017_s cnf71xx;
	struct cvmx_pcieepx_cfg017_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg017 cvmx_pcieepx_cfg017_t;

/**
 * cvmx_pcieep#_cfg020
 *
 * This register contains the twenty-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg020 {
	u32 u32;
	struct cvmx_pcieepx_cfg020_s {
		u32 reserved_25_31 : 7;
		u32 pvm : 1;
		u32 m64 : 1;
		u32 mme : 3;
		u32 mmc : 3;
		u32 msien : 1;
		u32 ncp : 8;
		u32 msicid : 8;
	} s;
	struct cvmx_pcieepx_cfg020_cn52xx {
		u32 reserved_24_31 : 8;
		u32 m64 : 1;
		u32 mme : 3;
		u32 mmc : 3;
		u32 msien : 1;
		u32 ncp : 8;
		u32 msicid : 8;
	} cn52xx;
	struct cvmx_pcieepx_cfg020_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg020_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg020_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg020_s cn61xx;
	struct cvmx_pcieepx_cfg020_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg020_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg020_s cn66xx;
	struct cvmx_pcieepx_cfg020_s cn68xx;
	struct cvmx_pcieepx_cfg020_s cn68xxp1;
	struct cvmx_pcieepx_cfg020_s cn70xx;
	struct cvmx_pcieepx_cfg020_s cn70xxp1;
	struct cvmx_pcieepx_cfg020_s cn73xx;
	struct cvmx_pcieepx_cfg020_s cn78xx;
	struct cvmx_pcieepx_cfg020_s cn78xxp1;
	struct cvmx_pcieepx_cfg020_s cnf71xx;
	struct cvmx_pcieepx_cfg020_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg020 cvmx_pcieepx_cfg020_t;

/**
 * cvmx_pcieep#_cfg021
 *
 * This register contains the twenty-second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg021 {
	u32 u32;
	struct cvmx_pcieepx_cfg021_s {
		u32 lmsi : 30;
		u32 reserved_0_1 : 2;
	} s;
	struct cvmx_pcieepx_cfg021_s cn52xx;
	struct cvmx_pcieepx_cfg021_s cn52xxp1;
	struct cvmx_pcieepx_cfg021_s cn56xx;
	struct cvmx_pcieepx_cfg021_s cn56xxp1;
	struct cvmx_pcieepx_cfg021_s cn61xx;
	struct cvmx_pcieepx_cfg021_s cn63xx;
	struct cvmx_pcieepx_cfg021_s cn63xxp1;
	struct cvmx_pcieepx_cfg021_s cn66xx;
	struct cvmx_pcieepx_cfg021_s cn68xx;
	struct cvmx_pcieepx_cfg021_s cn68xxp1;
	struct cvmx_pcieepx_cfg021_s cn70xx;
	struct cvmx_pcieepx_cfg021_s cn70xxp1;
	struct cvmx_pcieepx_cfg021_s cn73xx;
	struct cvmx_pcieepx_cfg021_s cn78xx;
	struct cvmx_pcieepx_cfg021_s cn78xxp1;
	struct cvmx_pcieepx_cfg021_s cnf71xx;
	struct cvmx_pcieepx_cfg021_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg021 cvmx_pcieepx_cfg021_t;

/**
 * cvmx_pcieep#_cfg022
 *
 * This register contains the twenty-third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg022 {
	u32 u32;
	struct cvmx_pcieepx_cfg022_s {
		u32 umsi : 32;
	} s;
	struct cvmx_pcieepx_cfg022_s cn52xx;
	struct cvmx_pcieepx_cfg022_s cn52xxp1;
	struct cvmx_pcieepx_cfg022_s cn56xx;
	struct cvmx_pcieepx_cfg022_s cn56xxp1;
	struct cvmx_pcieepx_cfg022_s cn61xx;
	struct cvmx_pcieepx_cfg022_s cn63xx;
	struct cvmx_pcieepx_cfg022_s cn63xxp1;
	struct cvmx_pcieepx_cfg022_s cn66xx;
	struct cvmx_pcieepx_cfg022_s cn68xx;
	struct cvmx_pcieepx_cfg022_s cn68xxp1;
	struct cvmx_pcieepx_cfg022_s cn70xx;
	struct cvmx_pcieepx_cfg022_s cn70xxp1;
	struct cvmx_pcieepx_cfg022_s cn73xx;
	struct cvmx_pcieepx_cfg022_s cn78xx;
	struct cvmx_pcieepx_cfg022_s cn78xxp1;
	struct cvmx_pcieepx_cfg022_s cnf71xx;
	struct cvmx_pcieepx_cfg022_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg022 cvmx_pcieepx_cfg022_t;

/**
 * cvmx_pcieep#_cfg023
 *
 * This register contains the twenty-fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg023 {
	u32 u32;
	struct cvmx_pcieepx_cfg023_s {
		u32 reserved_16_31 : 16;
		u32 msimd : 16;
	} s;
	struct cvmx_pcieepx_cfg023_s cn52xx;
	struct cvmx_pcieepx_cfg023_s cn52xxp1;
	struct cvmx_pcieepx_cfg023_s cn56xx;
	struct cvmx_pcieepx_cfg023_s cn56xxp1;
	struct cvmx_pcieepx_cfg023_s cn61xx;
	struct cvmx_pcieepx_cfg023_s cn63xx;
	struct cvmx_pcieepx_cfg023_s cn63xxp1;
	struct cvmx_pcieepx_cfg023_s cn66xx;
	struct cvmx_pcieepx_cfg023_s cn68xx;
	struct cvmx_pcieepx_cfg023_s cn68xxp1;
	struct cvmx_pcieepx_cfg023_s cn70xx;
	struct cvmx_pcieepx_cfg023_s cn70xxp1;
	struct cvmx_pcieepx_cfg023_s cn73xx;
	struct cvmx_pcieepx_cfg023_s cn78xx;
	struct cvmx_pcieepx_cfg023_s cn78xxp1;
	struct cvmx_pcieepx_cfg023_s cnf71xx;
	struct cvmx_pcieepx_cfg023_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg023 cvmx_pcieepx_cfg023_t;

/**
 * cvmx_pcieep#_cfg024
 *
 * This register contains the twenty-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg024 {
	u32 u32;
	struct cvmx_pcieepx_cfg024_s {
		u32 msimm : 32;
	} s;
	struct cvmx_pcieepx_cfg024_s cn70xx;
	struct cvmx_pcieepx_cfg024_s cn70xxp1;
	struct cvmx_pcieepx_cfg024_s cn73xx;
	struct cvmx_pcieepx_cfg024_s cn78xx;
	struct cvmx_pcieepx_cfg024_s cn78xxp1;
	struct cvmx_pcieepx_cfg024_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg024 cvmx_pcieepx_cfg024_t;

/**
 * cvmx_pcieep#_cfg025
 *
 * This register contains the twenty-sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg025 {
	u32 u32;
	struct cvmx_pcieepx_cfg025_s {
		u32 msimp : 32;
	} s;
	struct cvmx_pcieepx_cfg025_s cn70xx;
	struct cvmx_pcieepx_cfg025_s cn70xxp1;
	struct cvmx_pcieepx_cfg025_s cn73xx;
	struct cvmx_pcieepx_cfg025_s cn78xx;
	struct cvmx_pcieepx_cfg025_s cn78xxp1;
	struct cvmx_pcieepx_cfg025_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg025 cvmx_pcieepx_cfg025_t;

/**
 * cvmx_pcieep#_cfg028
 *
 * This register contains the twenty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg028 {
	u32 u32;
	struct cvmx_pcieepx_cfg028_s {
		u32 reserved_30_31 : 2;
		u32 imn : 5;
		u32 si : 1;
		u32 dpt : 4;
		u32 pciecv : 4;
		u32 ncp : 8;
		u32 pcieid : 8;
	} s;
	struct cvmx_pcieepx_cfg028_s cn52xx;
	struct cvmx_pcieepx_cfg028_s cn52xxp1;
	struct cvmx_pcieepx_cfg028_s cn56xx;
	struct cvmx_pcieepx_cfg028_s cn56xxp1;
	struct cvmx_pcieepx_cfg028_s cn61xx;
	struct cvmx_pcieepx_cfg028_s cn63xx;
	struct cvmx_pcieepx_cfg028_s cn63xxp1;
	struct cvmx_pcieepx_cfg028_s cn66xx;
	struct cvmx_pcieepx_cfg028_s cn68xx;
	struct cvmx_pcieepx_cfg028_s cn68xxp1;
	struct cvmx_pcieepx_cfg028_s cn70xx;
	struct cvmx_pcieepx_cfg028_s cn70xxp1;
	struct cvmx_pcieepx_cfg028_s cn73xx;
	struct cvmx_pcieepx_cfg028_s cn78xx;
	struct cvmx_pcieepx_cfg028_s cn78xxp1;
	struct cvmx_pcieepx_cfg028_s cnf71xx;
	struct cvmx_pcieepx_cfg028_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg028 cvmx_pcieepx_cfg028_t;

/**
 * cvmx_pcieep#_cfg029
 *
 * This register contains the thirtieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg029 {
	u32 u32;
	struct cvmx_pcieepx_cfg029_s {
		u32 reserved_28_31 : 4;
		u32 cspls : 2;
		u32 csplv : 8;
		u32 reserved_16_17 : 2;
		u32 rber : 1;
		u32 reserved_12_14 : 3;
		u32 el1al : 3;
		u32 el0al : 3;
		u32 etfs : 1;
		u32 pfs : 2;
		u32 mpss : 3;
	} s;
	struct cvmx_pcieepx_cfg029_s cn52xx;
	struct cvmx_pcieepx_cfg029_s cn52xxp1;
	struct cvmx_pcieepx_cfg029_s cn56xx;
	struct cvmx_pcieepx_cfg029_s cn56xxp1;
	struct cvmx_pcieepx_cfg029_cn61xx {
		u32 reserved_29_31 : 3;
		u32 flr_cap : 1;
		u32 cspls : 2;
		u32 csplv : 8;
		u32 reserved_16_17 : 2;
		u32 rber : 1;
		u32 reserved_12_14 : 3;
		u32 el1al : 3;
		u32 el0al : 3;
		u32 etfs : 1;
		u32 pfs : 2;
		u32 mpss : 3;
	} cn61xx;
	struct cvmx_pcieepx_cfg029_s cn63xx;
	struct cvmx_pcieepx_cfg029_s cn63xxp1;
	struct cvmx_pcieepx_cfg029_cn66xx {
		u32 reserved_29_31 : 3;
		u32 flr : 1;
		u32 cspls : 2;
		u32 csplv : 8;
		u32 reserved_16_17 : 2;
		u32 rber : 1;
		u32 reserved_12_14 : 3;
		u32 el1al : 3;
		u32 el0al : 3;
		u32 etfs : 1;
		u32 pfs : 2;
		u32 mpss : 3;
	} cn66xx;
	struct cvmx_pcieepx_cfg029_cn66xx cn68xx;
	struct cvmx_pcieepx_cfg029_cn66xx cn68xxp1;
	struct cvmx_pcieepx_cfg029_cn61xx cn70xx;
	struct cvmx_pcieepx_cfg029_cn61xx cn70xxp1;
	struct cvmx_pcieepx_cfg029_cn61xx cn73xx;
	struct cvmx_pcieepx_cfg029_cn61xx cn78xx;
	struct cvmx_pcieepx_cfg029_cn61xx cn78xxp1;
	struct cvmx_pcieepx_cfg029_cn61xx cnf71xx;
	struct cvmx_pcieepx_cfg029_cn61xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg029 cvmx_pcieepx_cfg029_t;

/**
 * cvmx_pcieep#_cfg030
 *
 * This register contains the thirty-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg030 {
	u32 u32;
	struct cvmx_pcieepx_cfg030_s {
		u32 reserved_22_31 : 10;
		u32 tp : 1;
		u32 ap_d : 1;
		u32 ur_d : 1;
		u32 fe_d : 1;
		u32 nfe_d : 1;
		u32 ce_d : 1;
		u32 i_flr : 1;
		u32 mrrs : 3;
		u32 ns_en : 1;
		u32 ap_en : 1;
		u32 pf_en : 1;
		u32 etf_en : 1;
		u32 mps : 3;
		u32 ro_en : 1;
		u32 ur_en : 1;
		u32 fe_en : 1;
		u32 nfe_en : 1;
		u32 ce_en : 1;
	} s;
	struct cvmx_pcieepx_cfg030_cn52xx {
		u32 reserved_22_31 : 10;
		u32 tp : 1;
		u32 ap_d : 1;
		u32 ur_d : 1;
		u32 fe_d : 1;
		u32 nfe_d : 1;
		u32 ce_d : 1;
		u32 reserved_15_15 : 1;
		u32 mrrs : 3;
		u32 ns_en : 1;
		u32 ap_en : 1;
		u32 pf_en : 1;
		u32 etf_en : 1;
		u32 mps : 3;
		u32 ro_en : 1;
		u32 ur_en : 1;
		u32 fe_en : 1;
		u32 nfe_en : 1;
		u32 ce_en : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg030_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg030_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg030_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg030_s cn61xx;
	struct cvmx_pcieepx_cfg030_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg030_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg030_s cn66xx;
	struct cvmx_pcieepx_cfg030_s cn68xx;
	struct cvmx_pcieepx_cfg030_s cn68xxp1;
	struct cvmx_pcieepx_cfg030_s cn70xx;
	struct cvmx_pcieepx_cfg030_s cn70xxp1;
	struct cvmx_pcieepx_cfg030_s cn73xx;
	struct cvmx_pcieepx_cfg030_s cn78xx;
	struct cvmx_pcieepx_cfg030_s cn78xxp1;
	struct cvmx_pcieepx_cfg030_s cnf71xx;
	struct cvmx_pcieepx_cfg030_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg030 cvmx_pcieepx_cfg030_t;

/**
 * cvmx_pcieep#_cfg031
 *
 * This register contains the thirty-second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg031 {
	u32 u32;
	struct cvmx_pcieepx_cfg031_s {
		u32 pnum : 8;
		u32 reserved_23_23 : 1;
		u32 aspm : 1;
		u32 lbnc : 1;
		u32 dllarc : 1;
		u32 sderc : 1;
		u32 cpm : 1;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 aslpms : 2;
		u32 mlw : 6;
		u32 mls : 4;
	} s;
	struct cvmx_pcieepx_cfg031_cn52xx {
		u32 pnum : 8;
		u32 reserved_22_23 : 2;
		u32 lbnc : 1;
		u32 dllarc : 1;
		u32 sderc : 1;
		u32 cpm : 1;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 aslpms : 2;
		u32 mlw : 6;
		u32 mls : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg031_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg031_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg031_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg031_s cn61xx;
	struct cvmx_pcieepx_cfg031_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg031_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg031_s cn66xx;
	struct cvmx_pcieepx_cfg031_s cn68xx;
	struct cvmx_pcieepx_cfg031_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg031_s cn70xx;
	struct cvmx_pcieepx_cfg031_s cn70xxp1;
	struct cvmx_pcieepx_cfg031_s cn73xx;
	struct cvmx_pcieepx_cfg031_s cn78xx;
	struct cvmx_pcieepx_cfg031_s cn78xxp1;
	struct cvmx_pcieepx_cfg031_s cnf71xx;
	struct cvmx_pcieepx_cfg031_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg031 cvmx_pcieepx_cfg031_t;

/**
 * cvmx_pcieep#_cfg032
 *
 * This register contains the thirty-third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg032 {
	u32 u32;
	struct cvmx_pcieepx_cfg032_s {
		u32 lab : 1;
		u32 lbm : 1;
		u32 dlla : 1;
		u32 scc : 1;
		u32 lt : 1;
		u32 reserved_26_26 : 1;
		u32 nlw : 6;
		u32 ls : 4;
		u32 reserved_12_15 : 4;
		u32 lab_int_enb : 1;
		u32 lbm_int_enb : 1;
		u32 hawd : 1;
		u32 ecpm : 1;
		u32 es : 1;
		u32 ccc : 1;
		u32 rl : 1;
		u32 ld : 1;
		u32 rcb : 1;
		u32 reserved_2_2 : 1;
		u32 aslpc : 2;
	} s;
	struct cvmx_pcieepx_cfg032_cn52xx {
		u32 reserved_30_31 : 2;
		u32 dlla : 1;
		u32 scc : 1;
		u32 lt : 1;
		u32 reserved_26_26 : 1;
		u32 nlw : 6;
		u32 ls : 4;
		u32 reserved_10_15 : 6;
		u32 hawd : 1;
		u32 ecpm : 1;
		u32 es : 1;
		u32 ccc : 1;
		u32 rl : 1;
		u32 ld : 1;
		u32 rcb : 1;
		u32 reserved_2_2 : 1;
		u32 aslpc : 2;
	} cn52xx;
	struct cvmx_pcieepx_cfg032_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg032_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg032_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg032_s cn61xx;
	struct cvmx_pcieepx_cfg032_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg032_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg032_s cn66xx;
	struct cvmx_pcieepx_cfg032_s cn68xx;
	struct cvmx_pcieepx_cfg032_cn68xxp1 {
		u32 reserved_30_31 : 2;
		u32 dlla : 1;
		u32 scc : 1;
		u32 lt : 1;
		u32 reserved_26_26 : 1;
		u32 nlw : 6;
		u32 ls : 4;
		u32 reserved_12_15 : 4;
		u32 lab_int_enb : 1;
		u32 lbm_int_enb : 1;
		u32 hawd : 1;
		u32 ecpm : 1;
		u32 es : 1;
		u32 ccc : 1;
		u32 rl : 1;
		u32 ld : 1;
		u32 rcb : 1;
		u32 reserved_2_2 : 1;
		u32 aslpc : 2;
	} cn68xxp1;
	struct cvmx_pcieepx_cfg032_s cn70xx;
	struct cvmx_pcieepx_cfg032_s cn70xxp1;
	struct cvmx_pcieepx_cfg032_s cn73xx;
	struct cvmx_pcieepx_cfg032_s cn78xx;
	struct cvmx_pcieepx_cfg032_s cn78xxp1;
	struct cvmx_pcieepx_cfg032_s cnf71xx;
	struct cvmx_pcieepx_cfg032_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg032 cvmx_pcieepx_cfg032_t;

/**
 * cvmx_pcieep#_cfg033
 *
 * PCIE_CFG033 = Thirty-fourth 32-bits of PCIE type 0 config space
 * (Slot Capabilities Register)
 */
union cvmx_pcieepx_cfg033 {
	u32 u32;
	struct cvmx_pcieepx_cfg033_s {
		u32 ps_num : 13;
		u32 nccs : 1;
		u32 emip : 1;
		u32 sp_ls : 2;
		u32 sp_lv : 8;
		u32 hp_c : 1;
		u32 hp_s : 1;
		u32 pip : 1;
		u32 aip : 1;
		u32 mrlsp : 1;
		u32 pcp : 1;
		u32 abp : 1;
	} s;
	struct cvmx_pcieepx_cfg033_s cn52xx;
	struct cvmx_pcieepx_cfg033_s cn52xxp1;
	struct cvmx_pcieepx_cfg033_s cn56xx;
	struct cvmx_pcieepx_cfg033_s cn56xxp1;
	struct cvmx_pcieepx_cfg033_s cn63xx;
	struct cvmx_pcieepx_cfg033_s cn63xxp1;
};

typedef union cvmx_pcieepx_cfg033 cvmx_pcieepx_cfg033_t;

/**
 * cvmx_pcieep#_cfg034
 *
 * PCIE_CFG034 = Thirty-fifth 32-bits of PCIE type 0 config space
 * (Slot Control Register/Slot Status Register)
 */
union cvmx_pcieepx_cfg034 {
	u32 u32;
	struct cvmx_pcieepx_cfg034_s {
		u32 reserved_25_31 : 7;
		u32 dlls_c : 1;
		u32 emis : 1;
		u32 pds : 1;
		u32 mrlss : 1;
		u32 ccint_d : 1;
		u32 pd_c : 1;
		u32 mrls_c : 1;
		u32 pf_d : 1;
		u32 abp_d : 1;
		u32 reserved_13_15 : 3;
		u32 dlls_en : 1;
		u32 emic : 1;
		u32 pcc : 1;
		u32 pic : 2;
		u32 aic : 2;
		u32 hpint_en : 1;
		u32 ccint_en : 1;
		u32 pd_en : 1;
		u32 mrls_en : 1;
		u32 pf_en : 1;
		u32 abp_en : 1;
	} s;
	struct cvmx_pcieepx_cfg034_s cn52xx;
	struct cvmx_pcieepx_cfg034_s cn52xxp1;
	struct cvmx_pcieepx_cfg034_s cn56xx;
	struct cvmx_pcieepx_cfg034_s cn56xxp1;
	struct cvmx_pcieepx_cfg034_s cn63xx;
	struct cvmx_pcieepx_cfg034_s cn63xxp1;
};

typedef union cvmx_pcieepx_cfg034 cvmx_pcieepx_cfg034_t;

/**
 * cvmx_pcieep#_cfg037
 *
 * This register contains the thirty-eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg037 {
	u32 u32;
	struct cvmx_pcieepx_cfg037_s {
		u32 reserved_24_31 : 8;
		u32 meetp : 2;
		u32 eetps : 1;
		u32 effs : 1;
		u32 obffs : 2;
		u32 reserved_12_17 : 6;
		u32 ltrs : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} s;
	struct cvmx_pcieepx_cfg037_cn52xx {
		u32 reserved_5_31 : 27;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg037_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg037_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg037_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg037_cn61xx {
		u32 reserved_14_31 : 18;
		u32 tph : 2;
		u32 reserved_11_11 : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn61xx;
	struct cvmx_pcieepx_cfg037_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg037_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg037_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg037_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg037_cn61xx cn68xxp1;
	struct cvmx_pcieepx_cfg037_cn61xx cn70xx;
	struct cvmx_pcieepx_cfg037_cn61xx cn70xxp1;
	struct cvmx_pcieepx_cfg037_cn73xx {
		u32 reserved_24_31 : 8;
		u32 meetp : 2;
		u32 eetps : 1;
		u32 effs : 1;
		u32 obffs : 2;
		u32 reserved_14_17 : 4;
		u32 tphs : 2;
		u32 ltrs : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn73xx;
	struct cvmx_pcieepx_cfg037_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg037_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg037_cnf71xx {
		u32 reserved_20_31 : 12;
		u32 obffs : 2;
		u32 reserved_14_17 : 4;
		u32 tphs : 2;
		u32 ltrs : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cnf71xx;
	struct cvmx_pcieepx_cfg037_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg037 cvmx_pcieepx_cfg037_t;

/**
 * cvmx_pcieep#_cfg038
 *
 * This register contains the thirty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg038 {
	u32 u32;
	struct cvmx_pcieepx_cfg038_s {
		u32 reserved_16_31 : 16;
		u32 eetpb : 1;
		u32 obffe : 2;
		u32 reserved_11_12 : 2;
		u32 ltre : 1;
		u32 id0_cp : 1;
		u32 id0_rq : 1;
		u32 atom_op_eb : 1;
		u32 atom_op : 1;
		u32 ari : 1;
		u32 ctd : 1;
		u32 ctv : 4;
	} s;
	struct cvmx_pcieepx_cfg038_cn52xx {
		u32 reserved_5_31 : 27;
		u32 ctd : 1;
		u32 ctv : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg038_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg038_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg038_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg038_cn61xx {
		u32 reserved_10_31 : 22;
		u32 id0_cp : 1;
		u32 id0_rq : 1;
		u32 atom_op_eb : 1;
		u32 atom_op : 1;
		u32 ari : 1;
		u32 ctd : 1;
		u32 ctv : 4;
	} cn61xx;
	struct cvmx_pcieepx_cfg038_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg038_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg038_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg038_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg038_cn61xx cn68xxp1;
	struct cvmx_pcieepx_cfg038_cn61xx cn70xx;
	struct cvmx_pcieepx_cfg038_cn61xx cn70xxp1;
	struct cvmx_pcieepx_cfg038_s cn73xx;
	struct cvmx_pcieepx_cfg038_s cn78xx;
	struct cvmx_pcieepx_cfg038_s cn78xxp1;
	struct cvmx_pcieepx_cfg038_cnf71xx {
		u32 reserved_15_31 : 17;
		u32 obffe : 2;
		u32 reserved_11_12 : 2;
		u32 ltre : 1;
		u32 id0_cp : 1;
		u32 id0_rq : 1;
		u32 atom_op_eb : 1;
		u32 atom_op : 1;
		u32 ari : 1;
		u32 ctd : 1;
		u32 ctv : 4;
	} cnf71xx;
	struct cvmx_pcieepx_cfg038_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg038 cvmx_pcieepx_cfg038_t;

/**
 * cvmx_pcieep#_cfg039
 *
 * This register contains the fortieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg039 {
	u32 u32;
	struct cvmx_pcieepx_cfg039_s {
		u32 reserved_9_31 : 23;
		u32 cls : 1;
		u32 slsv : 7;
		u32 reserved_0_0 : 1;
	} s;
	struct cvmx_pcieepx_cfg039_cn52xx {
		u32 reserved_0_31 : 32;
	} cn52xx;
	struct cvmx_pcieepx_cfg039_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg039_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg039_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg039_s cn61xx;
	struct cvmx_pcieepx_cfg039_s cn63xx;
	struct cvmx_pcieepx_cfg039_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg039_s cn66xx;
	struct cvmx_pcieepx_cfg039_s cn68xx;
	struct cvmx_pcieepx_cfg039_s cn68xxp1;
	struct cvmx_pcieepx_cfg039_s cn70xx;
	struct cvmx_pcieepx_cfg039_s cn70xxp1;
	struct cvmx_pcieepx_cfg039_s cn73xx;
	struct cvmx_pcieepx_cfg039_s cn78xx;
	struct cvmx_pcieepx_cfg039_s cn78xxp1;
	struct cvmx_pcieepx_cfg039_s cnf71xx;
	struct cvmx_pcieepx_cfg039_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg039 cvmx_pcieepx_cfg039_t;

/**
 * cvmx_pcieep#_cfg040
 *
 * This register contains the forty-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg040 {
	u32 u32;
	struct cvmx_pcieepx_cfg040_s {
		u32 reserved_22_31 : 10;
		u32 ler : 1;
		u32 ep3s : 1;
		u32 ep2s : 1;
		u32 ep1s : 1;
		u32 eqc : 1;
		u32 cdl : 1;
		u32 cde : 4;
		u32 csos : 1;
		u32 emc : 1;
		u32 tm : 3;
		u32 sde : 1;
		u32 hasd : 1;
		u32 ec : 1;
		u32 tls : 4;
	} s;
	struct cvmx_pcieepx_cfg040_cn52xx {
		u32 reserved_0_31 : 32;
	} cn52xx;
	struct cvmx_pcieepx_cfg040_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg040_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg040_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg040_cn61xx {
		u32 reserved_17_31 : 15;
		u32 cdl : 1;
		u32 reserved_13_15 : 3;
		u32 cde : 1;
		u32 csos : 1;
		u32 emc : 1;
		u32 tm : 3;
		u32 sde : 1;
		u32 hasd : 1;
		u32 ec : 1;
		u32 tls : 4;
	} cn61xx;
	struct cvmx_pcieepx_cfg040_cn61xx cn63xx;
	struct cvmx_pcieepx_cfg040_cn61xx cn63xxp1;
	struct cvmx_pcieepx_cfg040_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg040_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg040_cn61xx cn68xxp1;
	struct cvmx_pcieepx_cfg040_cn61xx cn70xx;
	struct cvmx_pcieepx_cfg040_cn61xx cn70xxp1;
	struct cvmx_pcieepx_cfg040_s cn73xx;
	struct cvmx_pcieepx_cfg040_s cn78xx;
	struct cvmx_pcieepx_cfg040_s cn78xxp1;
	struct cvmx_pcieepx_cfg040_cn61xx cnf71xx;
	struct cvmx_pcieepx_cfg040_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg040 cvmx_pcieepx_cfg040_t;

/**
 * cvmx_pcieep#_cfg041
 *
 * PCIE_CFG041 = Fourty-second 32-bits of PCIE type 0 config space
 * (Slot Capabilities 2 Register)
 */
union cvmx_pcieepx_cfg041 {
	u32 u32;
	struct cvmx_pcieepx_cfg041_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg041_s cn52xx;
	struct cvmx_pcieepx_cfg041_s cn52xxp1;
	struct cvmx_pcieepx_cfg041_s cn56xx;
	struct cvmx_pcieepx_cfg041_s cn56xxp1;
	struct cvmx_pcieepx_cfg041_s cn63xx;
	struct cvmx_pcieepx_cfg041_s cn63xxp1;
};

typedef union cvmx_pcieepx_cfg041 cvmx_pcieepx_cfg041_t;

/**
 * cvmx_pcieep#_cfg042
 *
 * PCIE_CFG042 = Fourty-third 32-bits of PCIE type 0 config space
 * (Slot Control 2 Register/Slot Status 2 Register)
 */
union cvmx_pcieepx_cfg042 {
	u32 u32;
	struct cvmx_pcieepx_cfg042_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg042_s cn52xx;
	struct cvmx_pcieepx_cfg042_s cn52xxp1;
	struct cvmx_pcieepx_cfg042_s cn56xx;
	struct cvmx_pcieepx_cfg042_s cn56xxp1;
	struct cvmx_pcieepx_cfg042_s cn63xx;
	struct cvmx_pcieepx_cfg042_s cn63xxp1;
};

typedef union cvmx_pcieepx_cfg042 cvmx_pcieepx_cfg042_t;

/**
 * cvmx_pcieep#_cfg044
 *
 * This register contains the forty-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg044 {
	u32 u32;
	struct cvmx_pcieepx_cfg044_s {
		u32 msixen : 1;
		u32 funm : 1;
		u32 reserved_27_29 : 3;
		u32 msixts : 11;
		u32 ncp : 8;
		u32 msixcid : 8;
	} s;
	struct cvmx_pcieepx_cfg044_s cn73xx;
	struct cvmx_pcieepx_cfg044_s cn78xx;
	struct cvmx_pcieepx_cfg044_s cn78xxp1;
	struct cvmx_pcieepx_cfg044_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg044 cvmx_pcieepx_cfg044_t;

/**
 * cvmx_pcieep#_cfg045
 *
 * This register contains the forty-sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg045 {
	u32 u32;
	struct cvmx_pcieepx_cfg045_s {
		u32 msixtoffs : 29;
		u32 msixtbir : 3;
	} s;
	struct cvmx_pcieepx_cfg045_s cn73xx;
	struct cvmx_pcieepx_cfg045_s cn78xx;
	struct cvmx_pcieepx_cfg045_s cn78xxp1;
	struct cvmx_pcieepx_cfg045_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg045 cvmx_pcieepx_cfg045_t;

/**
 * cvmx_pcieep#_cfg046
 *
 * This register contains the forty-seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg046 {
	u32 u32;
	struct cvmx_pcieepx_cfg046_s {
		u32 msixpoffs : 29;
		u32 msixpbir : 3;
	} s;
	struct cvmx_pcieepx_cfg046_s cn73xx;
	struct cvmx_pcieepx_cfg046_s cn78xx;
	struct cvmx_pcieepx_cfg046_s cn78xxp1;
	struct cvmx_pcieepx_cfg046_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg046 cvmx_pcieepx_cfg046_t;

/**
 * cvmx_pcieep#_cfg064
 *
 * This register contains the sixty-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg064 {
	u32 u32;
	struct cvmx_pcieepx_cfg064_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} s;
	struct cvmx_pcieepx_cfg064_s cn52xx;
	struct cvmx_pcieepx_cfg064_s cn52xxp1;
	struct cvmx_pcieepx_cfg064_s cn56xx;
	struct cvmx_pcieepx_cfg064_s cn56xxp1;
	struct cvmx_pcieepx_cfg064_s cn61xx;
	struct cvmx_pcieepx_cfg064_s cn63xx;
	struct cvmx_pcieepx_cfg064_s cn63xxp1;
	struct cvmx_pcieepx_cfg064_s cn66xx;
	struct cvmx_pcieepx_cfg064_s cn68xx;
	struct cvmx_pcieepx_cfg064_s cn68xxp1;
	struct cvmx_pcieepx_cfg064_s cn70xx;
	struct cvmx_pcieepx_cfg064_s cn70xxp1;
	struct cvmx_pcieepx_cfg064_s cn73xx;
	struct cvmx_pcieepx_cfg064_s cn78xx;
	struct cvmx_pcieepx_cfg064_s cn78xxp1;
	struct cvmx_pcieepx_cfg064_s cnf71xx;
	struct cvmx_pcieepx_cfg064_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg064 cvmx_pcieepx_cfg064_t;

/**
 * cvmx_pcieep#_cfg065
 *
 * This register contains the sixty-sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg065 {
	u32 u32;
	struct cvmx_pcieepx_cfg065_s {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pcieepx_cfg065_cn52xx {
		u32 reserved_21_31 : 11;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg065_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg065_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg065_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg065_cn61xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_21_23 : 3;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn61xx;
	struct cvmx_pcieepx_cfg065_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg065_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg065_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg065_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg065_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg065_cn70xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pcieepx_cfg065_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg065_cn73xx {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_5_11 : 7;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn73xx;
	struct cvmx_pcieepx_cfg065_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg065_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg065_cnf71xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_5_11 : 7;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cnf71xx;
	struct cvmx_pcieepx_cfg065_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg065 cvmx_pcieepx_cfg065_t;

/**
 * cvmx_pcieep#_cfg066
 *
 * This register contains the sixty-seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg066 {
	u32 u32;
	struct cvmx_pcieepx_cfg066_s {
		u32 reserved_26_31 : 6;
		u32 tpbem : 1;
		u32 uatombm : 1;
		u32 reserved_23_23 : 1;
		u32 uciem : 1;
		u32 reserved_21_21 : 1;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pcieepx_cfg066_cn52xx {
		u32 reserved_21_31 : 11;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg066_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg066_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg066_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg066_cn61xx {
		u32 reserved_25_31 : 7;
		u32 uatombm : 1;
		u32 reserved_21_23 : 3;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn61xx;
	struct cvmx_pcieepx_cfg066_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg066_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg066_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg066_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg066_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg066_cn70xx {
		u32 reserved_25_31 : 7;
		u32 uatombm : 1;
		u32 reserved_23_23 : 1;
		u32 uciem : 1;
		u32 reserved_21_21 : 1;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pcieepx_cfg066_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg066_cn73xx {
		u32 reserved_26_31 : 6;
		u32 tpbem : 1;
		u32 uatombm : 1;
		u32 reserved_23_23 : 1;
		u32 uciem : 1;
		u32 reserved_21_21 : 1;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_5_11 : 7;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn73xx;
	struct cvmx_pcieepx_cfg066_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg066_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg066_cnf71xx {
		u32 reserved_25_31 : 7;
		u32 uatombm : 1;
		u32 reserved_23_23 : 1;
		u32 uciem : 1;
		u32 reserved_21_21 : 1;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_5_11 : 7;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cnf71xx;
	struct cvmx_pcieepx_cfg066_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg066 cvmx_pcieepx_cfg066_t;

/**
 * cvmx_pcieep#_cfg067
 *
 * This register contains the sixty-eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg067 {
	u32 u32;
	struct cvmx_pcieepx_cfg067_s {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pcieepx_cfg067_cn52xx {
		u32 reserved_21_31 : 11;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg067_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg067_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg067_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg067_cn61xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_21_23 : 3;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn61xx;
	struct cvmx_pcieepx_cfg067_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg067_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg067_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg067_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg067_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg067_cn70xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pcieepx_cfg067_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg067_cn73xx {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_11_5 : 7;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn73xx;
	struct cvmx_pcieepx_cfg067_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg067_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg067_cnf71xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_5_11 : 7;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cnf71xx;
	struct cvmx_pcieepx_cfg067_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg067 cvmx_pcieepx_cfg067_t;

/**
 * cvmx_pcieep#_cfg068
 *
 * This register contains the sixty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg068 {
	u32 u32;
	struct cvmx_pcieepx_cfg068_s {
		u32 reserved_15_31 : 17;
		u32 cies : 1;
		u32 anfes : 1;
		u32 rtts : 1;
		u32 reserved_9_11 : 3;
		u32 rnrs : 1;
		u32 bdllps : 1;
		u32 btlps : 1;
		u32 reserved_1_5 : 5;
		u32 res : 1;
	} s;
	struct cvmx_pcieepx_cfg068_cn52xx {
		u32 reserved_14_31 : 18;
		u32 anfes : 1;
		u32 rtts : 1;
		u32 reserved_9_11 : 3;
		u32 rnrs : 1;
		u32 bdllps : 1;
		u32 btlps : 1;
		u32 reserved_1_5 : 5;
		u32 res : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg068_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg068_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg068_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg068_cn52xx cn61xx;
	struct cvmx_pcieepx_cfg068_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg068_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg068_cn52xx cn66xx;
	struct cvmx_pcieepx_cfg068_cn52xx cn68xx;
	struct cvmx_pcieepx_cfg068_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg068_s cn70xx;
	struct cvmx_pcieepx_cfg068_s cn70xxp1;
	struct cvmx_pcieepx_cfg068_s cn73xx;
	struct cvmx_pcieepx_cfg068_s cn78xx;
	struct cvmx_pcieepx_cfg068_s cn78xxp1;
	struct cvmx_pcieepx_cfg068_s cnf71xx;
	struct cvmx_pcieepx_cfg068_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg068 cvmx_pcieepx_cfg068_t;

/**
 * cvmx_pcieep#_cfg069
 *
 * This register contains the seventieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg069 {
	u32 u32;
	struct cvmx_pcieepx_cfg069_s {
		u32 reserved_15_31 : 17;
		u32 ciem : 1;
		u32 anfem : 1;
		u32 rttm : 1;
		u32 reserved_9_11 : 3;
		u32 rnrm : 1;
		u32 bdllpm : 1;
		u32 btlpm : 1;
		u32 reserved_1_5 : 5;
		u32 rem : 1;
	} s;
	struct cvmx_pcieepx_cfg069_cn52xx {
		u32 reserved_14_31 : 18;
		u32 anfem : 1;
		u32 rttm : 1;
		u32 reserved_9_11 : 3;
		u32 rnrm : 1;
		u32 bdllpm : 1;
		u32 btlpm : 1;
		u32 reserved_1_5 : 5;
		u32 rem : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg069_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg069_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg069_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg069_cn52xx cn61xx;
	struct cvmx_pcieepx_cfg069_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg069_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg069_cn52xx cn66xx;
	struct cvmx_pcieepx_cfg069_cn52xx cn68xx;
	struct cvmx_pcieepx_cfg069_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg069_s cn70xx;
	struct cvmx_pcieepx_cfg069_s cn70xxp1;
	struct cvmx_pcieepx_cfg069_s cn73xx;
	struct cvmx_pcieepx_cfg069_s cn78xx;
	struct cvmx_pcieepx_cfg069_s cn78xxp1;
	struct cvmx_pcieepx_cfg069_s cnf71xx;
	struct cvmx_pcieepx_cfg069_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg069 cvmx_pcieepx_cfg069_t;

/**
 * cvmx_pcieep#_cfg070
 *
 * This register contains the seventy-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg070 {
	u32 u32;
	struct cvmx_pcieepx_cfg070_s {
		u32 reserved_12_31 : 20;
		u32 tlp_plp : 1;
		u32 reserved_9_10 : 2;
		u32 ce : 1;
		u32 cc : 1;
		u32 ge : 1;
		u32 gc : 1;
		u32 fep : 5;
	} s;
	struct cvmx_pcieepx_cfg070_cn52xx {
		u32 reserved_9_31 : 23;
		u32 ce : 1;
		u32 cc : 1;
		u32 ge : 1;
		u32 gc : 1;
		u32 fep : 5;
	} cn52xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg070_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg070_cn52xx cn61xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg070_cn52xx cn66xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn68xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg070_cn52xx cn70xx;
	struct cvmx_pcieepx_cfg070_cn52xx cn70xxp1;
	struct cvmx_pcieepx_cfg070_s cn73xx;
	struct cvmx_pcieepx_cfg070_s cn78xx;
	struct cvmx_pcieepx_cfg070_s cn78xxp1;
	struct cvmx_pcieepx_cfg070_cn52xx cnf71xx;
	struct cvmx_pcieepx_cfg070_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg070 cvmx_pcieepx_cfg070_t;

/**
 * cvmx_pcieep#_cfg071
 *
 * This register contains the seventy-second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg071 {
	u32 u32;
	struct cvmx_pcieepx_cfg071_s {
		u32 dword1 : 32;
	} s;
	struct cvmx_pcieepx_cfg071_s cn52xx;
	struct cvmx_pcieepx_cfg071_s cn52xxp1;
	struct cvmx_pcieepx_cfg071_s cn56xx;
	struct cvmx_pcieepx_cfg071_s cn56xxp1;
	struct cvmx_pcieepx_cfg071_s cn61xx;
	struct cvmx_pcieepx_cfg071_s cn63xx;
	struct cvmx_pcieepx_cfg071_s cn63xxp1;
	struct cvmx_pcieepx_cfg071_s cn66xx;
	struct cvmx_pcieepx_cfg071_s cn68xx;
	struct cvmx_pcieepx_cfg071_s cn68xxp1;
	struct cvmx_pcieepx_cfg071_s cn70xx;
	struct cvmx_pcieepx_cfg071_s cn70xxp1;
	struct cvmx_pcieepx_cfg071_s cn73xx;
	struct cvmx_pcieepx_cfg071_s cn78xx;
	struct cvmx_pcieepx_cfg071_s cn78xxp1;
	struct cvmx_pcieepx_cfg071_s cnf71xx;
	struct cvmx_pcieepx_cfg071_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg071 cvmx_pcieepx_cfg071_t;

/**
 * cvmx_pcieep#_cfg072
 *
 * This register contains the seventy-third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg072 {
	u32 u32;
	struct cvmx_pcieepx_cfg072_s {
		u32 dword2 : 32;
	} s;
	struct cvmx_pcieepx_cfg072_s cn52xx;
	struct cvmx_pcieepx_cfg072_s cn52xxp1;
	struct cvmx_pcieepx_cfg072_s cn56xx;
	struct cvmx_pcieepx_cfg072_s cn56xxp1;
	struct cvmx_pcieepx_cfg072_s cn61xx;
	struct cvmx_pcieepx_cfg072_s cn63xx;
	struct cvmx_pcieepx_cfg072_s cn63xxp1;
	struct cvmx_pcieepx_cfg072_s cn66xx;
	struct cvmx_pcieepx_cfg072_s cn68xx;
	struct cvmx_pcieepx_cfg072_s cn68xxp1;
	struct cvmx_pcieepx_cfg072_s cn70xx;
	struct cvmx_pcieepx_cfg072_s cn70xxp1;
	struct cvmx_pcieepx_cfg072_s cn73xx;
	struct cvmx_pcieepx_cfg072_s cn78xx;
	struct cvmx_pcieepx_cfg072_s cn78xxp1;
	struct cvmx_pcieepx_cfg072_s cnf71xx;
	struct cvmx_pcieepx_cfg072_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg072 cvmx_pcieepx_cfg072_t;

/**
 * cvmx_pcieep#_cfg073
 *
 * This register contains the seventy-fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg073 {
	u32 u32;
	struct cvmx_pcieepx_cfg073_s {
		u32 dword3 : 32;
	} s;
	struct cvmx_pcieepx_cfg073_s cn52xx;
	struct cvmx_pcieepx_cfg073_s cn52xxp1;
	struct cvmx_pcieepx_cfg073_s cn56xx;
	struct cvmx_pcieepx_cfg073_s cn56xxp1;
	struct cvmx_pcieepx_cfg073_s cn61xx;
	struct cvmx_pcieepx_cfg073_s cn63xx;
	struct cvmx_pcieepx_cfg073_s cn63xxp1;
	struct cvmx_pcieepx_cfg073_s cn66xx;
	struct cvmx_pcieepx_cfg073_s cn68xx;
	struct cvmx_pcieepx_cfg073_s cn68xxp1;
	struct cvmx_pcieepx_cfg073_s cn70xx;
	struct cvmx_pcieepx_cfg073_s cn70xxp1;
	struct cvmx_pcieepx_cfg073_s cn73xx;
	struct cvmx_pcieepx_cfg073_s cn78xx;
	struct cvmx_pcieepx_cfg073_s cn78xxp1;
	struct cvmx_pcieepx_cfg073_s cnf71xx;
	struct cvmx_pcieepx_cfg073_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg073 cvmx_pcieepx_cfg073_t;

/**
 * cvmx_pcieep#_cfg074
 *
 * This register contains the seventy-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg074 {
	u32 u32;
	struct cvmx_pcieepx_cfg074_s {
		u32 dword4 : 32;
	} s;
	struct cvmx_pcieepx_cfg074_s cn52xx;
	struct cvmx_pcieepx_cfg074_s cn52xxp1;
	struct cvmx_pcieepx_cfg074_s cn56xx;
	struct cvmx_pcieepx_cfg074_s cn56xxp1;
	struct cvmx_pcieepx_cfg074_s cn61xx;
	struct cvmx_pcieepx_cfg074_s cn63xx;
	struct cvmx_pcieepx_cfg074_s cn63xxp1;
	struct cvmx_pcieepx_cfg074_s cn66xx;
	struct cvmx_pcieepx_cfg074_s cn68xx;
	struct cvmx_pcieepx_cfg074_s cn68xxp1;
	struct cvmx_pcieepx_cfg074_s cn70xx;
	struct cvmx_pcieepx_cfg074_s cn70xxp1;
	struct cvmx_pcieepx_cfg074_s cn73xx;
	struct cvmx_pcieepx_cfg074_s cn78xx;
	struct cvmx_pcieepx_cfg074_s cn78xxp1;
	struct cvmx_pcieepx_cfg074_s cnf71xx;
	struct cvmx_pcieepx_cfg074_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg074 cvmx_pcieepx_cfg074_t;

/**
 * cvmx_pcieep#_cfg078
 *
 * This register contains the seventy-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg078 {
	u32 u32;
	struct cvmx_pcieepx_cfg078_s {
		u32 tlp_pfx_log : 32;
	} s;
	struct cvmx_pcieepx_cfg078_s cn73xx;
	struct cvmx_pcieepx_cfg078_s cn78xx;
	struct cvmx_pcieepx_cfg078_s cn78xxp1;
	struct cvmx_pcieepx_cfg078_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg078 cvmx_pcieepx_cfg078_t;

/**
 * cvmx_pcieep#_cfg082
 *
 * This register contains the eighty-third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg082 {
	u32 u32;
	struct cvmx_pcieepx_cfg082_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 reserved_0_15 : 16;
	} s;
	struct cvmx_pcieepx_cfg082_cn70xx {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} cn70xx;
	struct cvmx_pcieepx_cfg082_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg082_cn73xx {
		u32 nco : 12;
		u32 cv : 4;
		u32 ariid : 16;
	} cn73xx;
	struct cvmx_pcieepx_cfg082_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg082_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg082_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg082 cvmx_pcieepx_cfg082_t;

/**
 * cvmx_pcieep#_cfg083
 *
 * This register contains the eighty-fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg083 {
	u32 u32;
	struct cvmx_pcieepx_cfg083_s {
		u32 reserved_2_31 : 30;
		u32 acsfgc : 1;
		u32 mfvcfgc : 1;
	} s;
	struct cvmx_pcieepx_cfg083_cn70xx {
		u32 reserved_26_31 : 6;
		u32 srs : 22;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pcieepx_cfg083_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg083_cn73xx {
		u32 reserved_23_31 : 9;
		u32 fg : 3;
		u32 reserved_18_19 : 2;
		u32 acsfge : 1;
		u32 mfvcfge : 1;
		u32 nfn : 8;
		u32 reserved_2_7 : 6;
		u32 acsfgc : 1;
		u32 mfvcfgc : 1;
	} cn73xx;
	struct cvmx_pcieepx_cfg083_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg083_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg083_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg083 cvmx_pcieepx_cfg083_t;

/**
 * cvmx_pcieep#_cfg084
 *
 * PCIE_CFG084 = Eighty-fifth 32-bits of PCIE type 0 config space
 * (PCI Express Resizable BAR (RBAR) Control Register)
 */
union cvmx_pcieepx_cfg084 {
	u32 u32;
	struct cvmx_pcieepx_cfg084_s {
		u32 reserved_13_31 : 19;
		u32 rbars : 5;
		u32 nrbar : 3;
		u32 reserved_3_4 : 2;
		u32 rbari : 3;
	} s;
	struct cvmx_pcieepx_cfg084_s cn70xx;
	struct cvmx_pcieepx_cfg084_s cn70xxp1;
};

typedef union cvmx_pcieepx_cfg084 cvmx_pcieepx_cfg084_t;

/**
 * cvmx_pcieep#_cfg086
 *
 * This register contains the eighty-seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg086 {
	u32 u32;
	struct cvmx_pcieepx_cfg086_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} s;
	struct cvmx_pcieepx_cfg086_s cn73xx;
	struct cvmx_pcieepx_cfg086_s cn78xx;
	struct cvmx_pcieepx_cfg086_s cn78xxp1;
	struct cvmx_pcieepx_cfg086_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg086 cvmx_pcieepx_cfg086_t;

/**
 * cvmx_pcieep#_cfg087
 *
 * This register contains the eighty-eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg087 {
	u32 u32;
	struct cvmx_pcieepx_cfg087_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg087_s cn73xx;
	struct cvmx_pcieepx_cfg087_s cn78xx;
	struct cvmx_pcieepx_cfg087_s cn78xxp1;
	struct cvmx_pcieepx_cfg087_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg087 cvmx_pcieepx_cfg087_t;

/**
 * cvmx_pcieep#_cfg088
 *
 * This register contains the eighty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg088 {
	u32 u32;
	struct cvmx_pcieepx_cfg088_s {
		u32 reserved_8_31 : 24;
		u32 les : 8;
	} s;
	struct cvmx_pcieepx_cfg088_s cn73xx;
	struct cvmx_pcieepx_cfg088_s cn78xx;
	struct cvmx_pcieepx_cfg088_s cn78xxp1;
	struct cvmx_pcieepx_cfg088_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg088 cvmx_pcieepx_cfg088_t;

/**
 * cvmx_pcieep#_cfg089
 *
 * This register contains the ninetieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg089 {
	u32 u32;
	struct cvmx_pcieepx_cfg089_s {
		u32 reserved_31_31 : 1;
		u32 l1dph : 3;
		u32 l1dtp : 4;
		u32 reserved_15_23 : 9;
		u32 l0dph : 3;
		u32 l0dtp : 4;
		u32 reserved_0_7 : 8;
	} s;
	struct cvmx_pcieepx_cfg089_s cn73xx;
	struct cvmx_pcieepx_cfg089_s cn78xx;
	struct cvmx_pcieepx_cfg089_s cn78xxp1;
	struct cvmx_pcieepx_cfg089_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg089 cvmx_pcieepx_cfg089_t;

/**
 * cvmx_pcieep#_cfg090
 *
 * This register contains the ninety-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg090 {
	u32 u32;
	struct cvmx_pcieepx_cfg090_s {
		u32 reserved_31_31 : 1;
		u32 l3dph : 3;
		u32 l3dtp : 4;
		u32 reserved_15_23 : 9;
		u32 l2dph : 3;
		u32 l2dtp : 4;
		u32 reserved_0_7 : 8;
	} s;
	struct cvmx_pcieepx_cfg090_s cn73xx;
	struct cvmx_pcieepx_cfg090_s cn78xx;
	struct cvmx_pcieepx_cfg090_s cn78xxp1;
	struct cvmx_pcieepx_cfg090_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg090 cvmx_pcieepx_cfg090_t;

/**
 * cvmx_pcieep#_cfg091
 *
 * This register contains the ninety-second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg091 {
	u32 u32;
	struct cvmx_pcieepx_cfg091_s {
		u32 reserved_31_31 : 1;
		u32 l5dph : 3;
		u32 l5dtp : 4;
		u32 reserved_15_23 : 9;
		u32 l4dph : 3;
		u32 l4dtp : 4;
		u32 reserved_0_7 : 8;
	} s;
	struct cvmx_pcieepx_cfg091_s cn73xx;
	struct cvmx_pcieepx_cfg091_s cn78xx;
	struct cvmx_pcieepx_cfg091_s cn78xxp1;
	struct cvmx_pcieepx_cfg091_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg091 cvmx_pcieepx_cfg091_t;

/**
 * cvmx_pcieep#_cfg092
 *
 * This register contains the ninety-fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg092 {
	u32 u32;
	struct cvmx_pcieepx_cfg092_s {
		u32 reserved_31_31 : 1;
		u32 l7dph : 3;
		u32 l7dtp : 4;
		u32 reserved_15_23 : 9;
		u32 l6dph : 3;
		u32 l6dtp : 4;
		u32 reserved_0_7 : 8;
	} s;
	struct cvmx_pcieepx_cfg092_s cn73xx;
	struct cvmx_pcieepx_cfg092_s cn78xx;
	struct cvmx_pcieepx_cfg092_s cn78xxp1;
	struct cvmx_pcieepx_cfg092_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg092 cvmx_pcieepx_cfg092_t;

/**
 * cvmx_pcieep#_cfg094
 *
 * This register contains the ninety-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg094 {
	u32 u32;
	struct cvmx_pcieepx_cfg094_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} s;
	struct cvmx_pcieepx_cfg094_s cn73xx;
	struct cvmx_pcieepx_cfg094_s cn78xx;
	struct cvmx_pcieepx_cfg094_s cn78xxp1;
	struct cvmx_pcieepx_cfg094_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg094 cvmx_pcieepx_cfg094_t;

/**
 * cvmx_pcieep#_cfg095
 *
 * This register contains the ninety-sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg095 {
	u32 u32;
	struct cvmx_pcieepx_cfg095_s {
		u32 vfmimn : 11;
		u32 reserved_2_20 : 19;
		u32 arichp : 1;
		u32 vfmc : 1;
	} s;
	struct cvmx_pcieepx_cfg095_s cn73xx;
	struct cvmx_pcieepx_cfg095_s cn78xx;
	struct cvmx_pcieepx_cfg095_s cn78xxp1;
	struct cvmx_pcieepx_cfg095_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg095 cvmx_pcieepx_cfg095_t;

/**
 * cvmx_pcieep#_cfg096
 *
 * This register contains the ninety-seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg096 {
	u32 u32;
	struct cvmx_pcieepx_cfg096_s {
		u32 reserved_17_31 : 15;
		u32 ms : 1;
		u32 reserved_5_15 : 11;
		u32 ach : 1;
		u32 mse : 1;
		u32 mie : 1;
		u32 me : 1;
		u32 vfe : 1;
	} s;
	struct cvmx_pcieepx_cfg096_s cn73xx;
	struct cvmx_pcieepx_cfg096_s cn78xx;
	struct cvmx_pcieepx_cfg096_s cn78xxp1;
	struct cvmx_pcieepx_cfg096_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg096 cvmx_pcieepx_cfg096_t;

/**
 * cvmx_pcieep#_cfg097
 *
 * This register contains the ninety-eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg097 {
	u32 u32;
	struct cvmx_pcieepx_cfg097_s {
		u32 tvf : 16;
		u32 ivf : 16;
	} s;
	struct cvmx_pcieepx_cfg097_s cn73xx;
	struct cvmx_pcieepx_cfg097_s cn78xx;
	struct cvmx_pcieepx_cfg097_s cn78xxp1;
	struct cvmx_pcieepx_cfg097_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg097 cvmx_pcieepx_cfg097_t;

/**
 * cvmx_pcieep#_cfg098
 *
 * This register contains the ninety-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg098 {
	u32 u32;
	struct cvmx_pcieepx_cfg098_s {
		u32 reserved_24_31 : 8;
		u32 fdl : 8;
		u32 nvf : 16;
	} s;
	struct cvmx_pcieepx_cfg098_s cn73xx;
	struct cvmx_pcieepx_cfg098_s cn78xx;
	struct cvmx_pcieepx_cfg098_s cn78xxp1;
	struct cvmx_pcieepx_cfg098_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg098 cvmx_pcieepx_cfg098_t;

/**
 * cvmx_pcieep#_cfg099
 *
 * This register contains the one hundredth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg099 {
	u32 u32;
	struct cvmx_pcieepx_cfg099_s {
		u32 vfs : 16;
		u32 fo : 16;
	} s;
	struct cvmx_pcieepx_cfg099_s cn73xx;
	struct cvmx_pcieepx_cfg099_s cn78xx;
	struct cvmx_pcieepx_cfg099_s cn78xxp1;
	struct cvmx_pcieepx_cfg099_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg099 cvmx_pcieepx_cfg099_t;

/**
 * cvmx_pcieep#_cfg100
 *
 * This register contains the one hundred first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg100 {
	u32 u32;
	struct cvmx_pcieepx_cfg100_s {
		u32 vfdev : 16;
		u32 reserved_0_15 : 16;
	} s;
	struct cvmx_pcieepx_cfg100_s cn73xx;
	struct cvmx_pcieepx_cfg100_s cn78xx;
	struct cvmx_pcieepx_cfg100_s cn78xxp1;
	struct cvmx_pcieepx_cfg100_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg100 cvmx_pcieepx_cfg100_t;

/**
 * cvmx_pcieep#_cfg101
 *
 * This register contains the one hundred second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg101 {
	u32 u32;
	struct cvmx_pcieepx_cfg101_s {
		u32 supps : 32;
	} s;
	struct cvmx_pcieepx_cfg101_s cn73xx;
	struct cvmx_pcieepx_cfg101_s cn78xx;
	struct cvmx_pcieepx_cfg101_s cn78xxp1;
	struct cvmx_pcieepx_cfg101_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg101 cvmx_pcieepx_cfg101_t;

/**
 * cvmx_pcieep#_cfg102
 *
 * This register contains the one hundred third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg102 {
	u32 u32;
	struct cvmx_pcieepx_cfg102_s {
		u32 ps : 32;
	} s;
	struct cvmx_pcieepx_cfg102_s cn73xx;
	struct cvmx_pcieepx_cfg102_s cn78xx;
	struct cvmx_pcieepx_cfg102_s cn78xxp1;
	struct cvmx_pcieepx_cfg102_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg102 cvmx_pcieepx_cfg102_t;

/**
 * cvmx_pcieep#_cfg103
 *
 * This register contains the one hundred fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg103 {
	u32 u32;
	struct cvmx_pcieepx_cfg103_s {
		u32 reserved_4_31 : 28;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} s;
	struct cvmx_pcieepx_cfg103_cn73xx {
		u32 lbab : 12;
		u32 reserved_4_19 : 16;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} cn73xx;
	struct cvmx_pcieepx_cfg103_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg103_cn78xxp1 {
		u32 lbab : 17;
		u32 reserved_4_14 : 11;
		u32 pf : 1;
		u32 typ : 2;
		u32 mspc : 1;
	} cn78xxp1;
	struct cvmx_pcieepx_cfg103_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg103 cvmx_pcieepx_cfg103_t;

/**
 * cvmx_pcieep#_cfg104
 *
 * This register contains the one hundred seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg104 {
	u32 u32;
	struct cvmx_pcieepx_cfg104_s {
		u32 ubab : 32;
	} s;
	struct cvmx_pcieepx_cfg104_s cn73xx;
	struct cvmx_pcieepx_cfg104_s cn78xx;
	struct cvmx_pcieepx_cfg104_s cn78xxp1;
	struct cvmx_pcieepx_cfg104_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg104 cvmx_pcieepx_cfg104_t;

/**
 * cvmx_pcieep#_cfg105
 *
 * This register contains the one hundred sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg105 {
	u32 u32;
	struct cvmx_pcieepx_cfg105_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg105_s cn73xx;
	struct cvmx_pcieepx_cfg105_s cn78xx;
	struct cvmx_pcieepx_cfg105_s cn78xxp1;
	struct cvmx_pcieepx_cfg105_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg105 cvmx_pcieepx_cfg105_t;

/**
 * cvmx_pcieep#_cfg106
 *
 * This register contains the one hundred seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg106 {
	u32 u32;
	struct cvmx_pcieepx_cfg106_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg106_s cn73xx;
	struct cvmx_pcieepx_cfg106_s cn78xx;
	struct cvmx_pcieepx_cfg106_s cn78xxp1;
	struct cvmx_pcieepx_cfg106_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg106 cvmx_pcieepx_cfg106_t;

/**
 * cvmx_pcieep#_cfg107
 *
 * This register contains the one hundred eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg107 {
	u32 u32;
	struct cvmx_pcieepx_cfg107_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg107_s cn73xx;
	struct cvmx_pcieepx_cfg107_s cn78xx;
	struct cvmx_pcieepx_cfg107_s cn78xxp1;
	struct cvmx_pcieepx_cfg107_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg107 cvmx_pcieepx_cfg107_t;

/**
 * cvmx_pcieep#_cfg108
 *
 * This register contains the one hundred ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg108 {
	u32 u32;
	struct cvmx_pcieepx_cfg108_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pcieepx_cfg108_s cn73xx;
	struct cvmx_pcieepx_cfg108_s cn78xx;
	struct cvmx_pcieepx_cfg108_s cn78xxp1;
	struct cvmx_pcieepx_cfg108_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg108 cvmx_pcieepx_cfg108_t;

/**
 * cvmx_pcieep#_cfg109
 *
 * This register contains the one hundred tenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg109 {
	u32 u32;
	struct cvmx_pcieepx_cfg109_s {
		u32 mso : 29;
		u32 msbir : 3;
	} s;
	struct cvmx_pcieepx_cfg109_s cn73xx;
	struct cvmx_pcieepx_cfg109_s cn78xx;
	struct cvmx_pcieepx_cfg109_s cn78xxp1;
	struct cvmx_pcieepx_cfg109_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg109 cvmx_pcieepx_cfg109_t;

/**
 * cvmx_pcieep#_cfg110
 *
 * This register contains the one hundred eleventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg110 {
	u32 u32;
	struct cvmx_pcieepx_cfg110_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} s;
	struct cvmx_pcieepx_cfg110_s cn73xx;
	struct cvmx_pcieepx_cfg110_s cn78xx;
	struct cvmx_pcieepx_cfg110_s cn78xxp1;
	struct cvmx_pcieepx_cfg110_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg110 cvmx_pcieepx_cfg110_t;

/**
 * cvmx_pcieep#_cfg111
 *
 * This register contains the one hundred twelfth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg111 {
	u32 u32;
	struct cvmx_pcieepx_cfg111_s {
		u32 reserved_30_31 : 2;
		u32 srs : 26;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pcieepx_cfg111_s cn73xx;
	struct cvmx_pcieepx_cfg111_s cn78xx;
	struct cvmx_pcieepx_cfg111_s cn78xxp1;
	struct cvmx_pcieepx_cfg111_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg111 cvmx_pcieepx_cfg111_t;

/**
 * cvmx_pcieep#_cfg112
 *
 * This register contains the one hundred thirteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg112 {
	u32 u32;
	struct cvmx_pcieepx_cfg112_s {
		u32 reserved_13_31 : 19;
		u32 rbars : 5;
		u32 nrbar : 3;
		u32 reserved_3_4 : 2;
		u32 rbari : 3;
	} s;
	struct cvmx_pcieepx_cfg112_s cn73xx;
	struct cvmx_pcieepx_cfg112_s cn78xx;
	struct cvmx_pcieepx_cfg112_s cn78xxp1;
	struct cvmx_pcieepx_cfg112_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg112 cvmx_pcieepx_cfg112_t;

/**
 * cvmx_pcieep#_cfg448
 *
 * This register contains the four hundred forty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg448 {
	u32 u32;
	struct cvmx_pcieepx_cfg448_s {
		u32 rtl : 16;
		u32 rtltl : 16;
	} s;
	struct cvmx_pcieepx_cfg448_s cn52xx;
	struct cvmx_pcieepx_cfg448_s cn52xxp1;
	struct cvmx_pcieepx_cfg448_s cn56xx;
	struct cvmx_pcieepx_cfg448_s cn56xxp1;
	struct cvmx_pcieepx_cfg448_s cn61xx;
	struct cvmx_pcieepx_cfg448_s cn63xx;
	struct cvmx_pcieepx_cfg448_s cn63xxp1;
	struct cvmx_pcieepx_cfg448_s cn66xx;
	struct cvmx_pcieepx_cfg448_s cn68xx;
	struct cvmx_pcieepx_cfg448_s cn68xxp1;
	struct cvmx_pcieepx_cfg448_s cn70xx;
	struct cvmx_pcieepx_cfg448_s cn70xxp1;
	struct cvmx_pcieepx_cfg448_s cn73xx;
	struct cvmx_pcieepx_cfg448_s cn78xx;
	struct cvmx_pcieepx_cfg448_s cn78xxp1;
	struct cvmx_pcieepx_cfg448_s cnf71xx;
	struct cvmx_pcieepx_cfg448_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg448 cvmx_pcieepx_cfg448_t;

/**
 * cvmx_pcieep#_cfg449
 *
 * This register contains the four hundred fiftieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg449 {
	u32 u32;
	struct cvmx_pcieepx_cfg449_s {
		u32 omr : 32;
	} s;
	struct cvmx_pcieepx_cfg449_s cn52xx;
	struct cvmx_pcieepx_cfg449_s cn52xxp1;
	struct cvmx_pcieepx_cfg449_s cn56xx;
	struct cvmx_pcieepx_cfg449_s cn56xxp1;
	struct cvmx_pcieepx_cfg449_s cn61xx;
	struct cvmx_pcieepx_cfg449_s cn63xx;
	struct cvmx_pcieepx_cfg449_s cn63xxp1;
	struct cvmx_pcieepx_cfg449_s cn66xx;
	struct cvmx_pcieepx_cfg449_s cn68xx;
	struct cvmx_pcieepx_cfg449_s cn68xxp1;
	struct cvmx_pcieepx_cfg449_s cn70xx;
	struct cvmx_pcieepx_cfg449_s cn70xxp1;
	struct cvmx_pcieepx_cfg449_s cn73xx;
	struct cvmx_pcieepx_cfg449_s cn78xx;
	struct cvmx_pcieepx_cfg449_s cn78xxp1;
	struct cvmx_pcieepx_cfg449_s cnf71xx;
	struct cvmx_pcieepx_cfg449_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg449 cvmx_pcieepx_cfg449_t;

/**
 * cvmx_pcieep#_cfg450
 *
 * This register contains the four hundred fifty-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg450 {
	u32 u32;
	struct cvmx_pcieepx_cfg450_s {
		u32 lpec : 8;
		u32 reserved_22_23 : 2;
		u32 link_state : 6;
		u32 force_link : 1;
		u32 reserved_8_14 : 7;
		u32 link_num : 8;
	} s;
	struct cvmx_pcieepx_cfg450_s cn52xx;
	struct cvmx_pcieepx_cfg450_s cn52xxp1;
	struct cvmx_pcieepx_cfg450_s cn56xx;
	struct cvmx_pcieepx_cfg450_s cn56xxp1;
	struct cvmx_pcieepx_cfg450_s cn61xx;
	struct cvmx_pcieepx_cfg450_s cn63xx;
	struct cvmx_pcieepx_cfg450_s cn63xxp1;
	struct cvmx_pcieepx_cfg450_s cn66xx;
	struct cvmx_pcieepx_cfg450_s cn68xx;
	struct cvmx_pcieepx_cfg450_s cn68xxp1;
	struct cvmx_pcieepx_cfg450_cn70xx {
		u32 lpec : 8;
		u32 reserved_22_23 : 2;
		u32 link_state : 6;
		u32 force_link : 1;
		u32 reserved_12_14 : 3;
		u32 link_cmd : 4;
		u32 link_num : 8;
	} cn70xx;
	struct cvmx_pcieepx_cfg450_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg450_cn73xx {
		u32 lpec : 8;
		u32 reserved_22_23 : 2;
		u32 link_state : 6;
		u32 force_link : 1;
		u32 reserved_12_14 : 3;
		u32 forced_ltssm : 4;
		u32 link_num : 8;
	} cn73xx;
	struct cvmx_pcieepx_cfg450_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg450_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg450_s cnf71xx;
	struct cvmx_pcieepx_cfg450_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg450 cvmx_pcieepx_cfg450_t;

/**
 * cvmx_pcieep#_cfg451
 *
 * This register contains the four hundred fifty-second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg451 {
	u32 u32;
	struct cvmx_pcieepx_cfg451_s {
		u32 reserved_31_31 : 1;
		u32 easpml1 : 1;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 n_fts_cc : 8;
		u32 n_fts : 8;
		u32 ack_freq : 8;
	} s;
	struct cvmx_pcieepx_cfg451_cn52xx {
		u32 reserved_30_31 : 2;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 n_fts_cc : 8;
		u32 n_fts : 8;
		u32 ack_freq : 8;
	} cn52xx;
	struct cvmx_pcieepx_cfg451_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg451_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg451_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg451_s cn61xx;
	struct cvmx_pcieepx_cfg451_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg451_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg451_s cn66xx;
	struct cvmx_pcieepx_cfg451_s cn68xx;
	struct cvmx_pcieepx_cfg451_s cn68xxp1;
	struct cvmx_pcieepx_cfg451_s cn70xx;
	struct cvmx_pcieepx_cfg451_s cn70xxp1;
	struct cvmx_pcieepx_cfg451_s cn73xx;
	struct cvmx_pcieepx_cfg451_s cn78xx;
	struct cvmx_pcieepx_cfg451_s cn78xxp1;
	struct cvmx_pcieepx_cfg451_s cnf71xx;
	struct cvmx_pcieepx_cfg451_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg451 cvmx_pcieepx_cfg451_t;

/**
 * cvmx_pcieep#_cfg452
 *
 * This register contains the four hundred fifty-third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg452 {
	u32 u32;
	struct cvmx_pcieepx_cfg452_s {
		u32 reserved_26_31 : 6;
		u32 eccrc : 1;
		u32 reserved_22_24 : 3;
		u32 lme : 6;
		u32 reserved_12_15 : 4;
		u32 link_rate : 4;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} s;
	struct cvmx_pcieepx_cfg452_cn52xx {
		u32 reserved_26_31 : 6;
		u32 eccrc : 1;
		u32 reserved_22_24 : 3;
		u32 lme : 6;
		u32 reserved_8_15 : 8;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg452_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg452_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg452_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg452_cn61xx {
		u32 reserved_22_31 : 10;
		u32 lme : 6;
		u32 reserved_8_15 : 8;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} cn61xx;
	struct cvmx_pcieepx_cfg452_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg452_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg452_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg452_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg452_cn61xx cn68xxp1;
	struct cvmx_pcieepx_cfg452_cn70xx {
		u32 reserved_22_31 : 10;
		u32 lme : 6;
		u32 reserved_12_15 : 4;
		u32 link_rate : 4;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} cn70xx;
	struct cvmx_pcieepx_cfg452_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg452_cn70xx cn73xx;
	struct cvmx_pcieepx_cfg452_cn70xx cn78xx;
	struct cvmx_pcieepx_cfg452_cn70xx cn78xxp1;
	struct cvmx_pcieepx_cfg452_cn61xx cnf71xx;
	struct cvmx_pcieepx_cfg452_cn70xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg452 cvmx_pcieepx_cfg452_t;

/**
 * cvmx_pcieep#_cfg453
 *
 * This register contains the four hundred fifty-fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg453 {
	u32 u32;
	struct cvmx_pcieepx_cfg453_s {
		u32 dlld : 1;
		u32 reserved_26_30 : 5;
		u32 ack_nak : 1;
		u32 fcd : 1;
		u32 ilst : 24;
	} s;
	struct cvmx_pcieepx_cfg453_s cn52xx;
	struct cvmx_pcieepx_cfg453_s cn52xxp1;
	struct cvmx_pcieepx_cfg453_s cn56xx;
	struct cvmx_pcieepx_cfg453_s cn56xxp1;
	struct cvmx_pcieepx_cfg453_s cn61xx;
	struct cvmx_pcieepx_cfg453_s cn63xx;
	struct cvmx_pcieepx_cfg453_s cn63xxp1;
	struct cvmx_pcieepx_cfg453_s cn66xx;
	struct cvmx_pcieepx_cfg453_s cn68xx;
	struct cvmx_pcieepx_cfg453_s cn68xxp1;
	struct cvmx_pcieepx_cfg453_s cn70xx;
	struct cvmx_pcieepx_cfg453_s cn70xxp1;
	struct cvmx_pcieepx_cfg453_s cn73xx;
	struct cvmx_pcieepx_cfg453_s cn78xx;
	struct cvmx_pcieepx_cfg453_s cn78xxp1;
	struct cvmx_pcieepx_cfg453_s cnf71xx;
	struct cvmx_pcieepx_cfg453_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg453 cvmx_pcieepx_cfg453_t;

/**
 * cvmx_pcieep#_cfg454
 *
 * This register contains the four hundred fifty-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg454 {
	u32 u32;
	struct cvmx_pcieepx_cfg454_s {
		u32 cx_nfunc : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_11_13 : 3;
		u32 nskps : 3;
		u32 reserved_0_7 : 8;
	} s;
	struct cvmx_pcieepx_cfg454_cn52xx {
		u32 reserved_29_31 : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_11_13 : 3;
		u32 nskps : 3;
		u32 reserved_4_7 : 4;
		u32 ntss : 4;
	} cn52xx;
	struct cvmx_pcieepx_cfg454_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg454_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg454_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg454_cn61xx {
		u32 cx_nfunc : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_8_13 : 6;
		u32 mfuncn : 8;
	} cn61xx;
	struct cvmx_pcieepx_cfg454_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg454_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg454_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg454_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg454_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg454_cn70xx {
		u32 reserved_24_31 : 8;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_8_13 : 6;
		u32 mfuncn : 8;
	} cn70xx;
	struct cvmx_pcieepx_cfg454_cn70xx cn70xxp1;
	struct cvmx_pcieepx_cfg454_cn73xx {
		u32 reserved_29_31 : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_8_13 : 6;
		u32 mfuncn : 8;
	} cn73xx;
	struct cvmx_pcieepx_cfg454_cn73xx cn78xx;
	struct cvmx_pcieepx_cfg454_cn73xx cn78xxp1;
	struct cvmx_pcieepx_cfg454_cn61xx cnf71xx;
	struct cvmx_pcieepx_cfg454_cn73xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg454 cvmx_pcieepx_cfg454_t;

/**
 * cvmx_pcieep#_cfg455
 *
 * This register contains the four hundred fifty-sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg455 {
	u32 u32;
	struct cvmx_pcieepx_cfg455_s {
		u32 m_cfg0_filt : 1;
		u32 m_io_filt : 1;
		u32 msg_ctrl : 1;
		u32 m_cpl_ecrc_filt : 1;
		u32 m_ecrc_filt : 1;
		u32 m_cpl_len_err : 1;
		u32 m_cpl_attr_err : 1;
		u32 m_cpl_tc_err : 1;
		u32 m_cpl_fun_err : 1;
		u32 m_cpl_rid_err : 1;
		u32 m_cpl_tag_err : 1;
		u32 m_lk_filt : 1;
		u32 m_cfg1_filt : 1;
		u32 m_bar_match : 1;
		u32 m_pois_filt : 1;
		u32 m_fun : 1;
		u32 dfcwt : 1;
		u32 reserved_11_14 : 4;
		u32 skpiv : 11;
	} s;
	struct cvmx_pcieepx_cfg455_s cn52xx;
	struct cvmx_pcieepx_cfg455_s cn52xxp1;
	struct cvmx_pcieepx_cfg455_s cn56xx;
	struct cvmx_pcieepx_cfg455_s cn56xxp1;
	struct cvmx_pcieepx_cfg455_s cn61xx;
	struct cvmx_pcieepx_cfg455_s cn63xx;
	struct cvmx_pcieepx_cfg455_s cn63xxp1;
	struct cvmx_pcieepx_cfg455_s cn66xx;
	struct cvmx_pcieepx_cfg455_s cn68xx;
	struct cvmx_pcieepx_cfg455_s cn68xxp1;
	struct cvmx_pcieepx_cfg455_s cn70xx;
	struct cvmx_pcieepx_cfg455_s cn70xxp1;
	struct cvmx_pcieepx_cfg455_s cn73xx;
	struct cvmx_pcieepx_cfg455_s cn78xx;
	struct cvmx_pcieepx_cfg455_s cn78xxp1;
	struct cvmx_pcieepx_cfg455_s cnf71xx;
	struct cvmx_pcieepx_cfg455_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg455 cvmx_pcieepx_cfg455_t;

/**
 * cvmx_pcieep#_cfg456
 *
 * This register contains the four hundred fifty-seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg456 {
	u32 u32;
	struct cvmx_pcieepx_cfg456_s {
		u32 reserved_4_31 : 28;
		u32 m_handle_flush : 1;
		u32 m_dabort_4ucpl : 1;
		u32 m_vend1_drp : 1;
		u32 m_vend0_drp : 1;
	} s;
	struct cvmx_pcieepx_cfg456_cn52xx {
		u32 reserved_2_31 : 30;
		u32 m_vend1_drp : 1;
		u32 m_vend0_drp : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg456_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg456_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg456_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg456_s cn61xx;
	struct cvmx_pcieepx_cfg456_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg456_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg456_s cn66xx;
	struct cvmx_pcieepx_cfg456_s cn68xx;
	struct cvmx_pcieepx_cfg456_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg456_s cn70xx;
	struct cvmx_pcieepx_cfg456_s cn70xxp1;
	struct cvmx_pcieepx_cfg456_s cn73xx;
	struct cvmx_pcieepx_cfg456_s cn78xx;
	struct cvmx_pcieepx_cfg456_s cn78xxp1;
	struct cvmx_pcieepx_cfg456_s cnf71xx;
	struct cvmx_pcieepx_cfg456_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg456 cvmx_pcieepx_cfg456_t;

/**
 * cvmx_pcieep#_cfg458
 *
 * This register contains the four hundred fifty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg458 {
	u32 u32;
	struct cvmx_pcieepx_cfg458_s {
		u32 dbg_info_l32 : 32;
	} s;
	struct cvmx_pcieepx_cfg458_s cn52xx;
	struct cvmx_pcieepx_cfg458_s cn52xxp1;
	struct cvmx_pcieepx_cfg458_s cn56xx;
	struct cvmx_pcieepx_cfg458_s cn56xxp1;
	struct cvmx_pcieepx_cfg458_s cn61xx;
	struct cvmx_pcieepx_cfg458_s cn63xx;
	struct cvmx_pcieepx_cfg458_s cn63xxp1;
	struct cvmx_pcieepx_cfg458_s cn66xx;
	struct cvmx_pcieepx_cfg458_s cn68xx;
	struct cvmx_pcieepx_cfg458_s cn68xxp1;
	struct cvmx_pcieepx_cfg458_s cn70xx;
	struct cvmx_pcieepx_cfg458_s cn70xxp1;
	struct cvmx_pcieepx_cfg458_s cn73xx;
	struct cvmx_pcieepx_cfg458_s cn78xx;
	struct cvmx_pcieepx_cfg458_s cn78xxp1;
	struct cvmx_pcieepx_cfg458_s cnf71xx;
	struct cvmx_pcieepx_cfg458_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg458 cvmx_pcieepx_cfg458_t;

/**
 * cvmx_pcieep#_cfg459
 *
 * This register contains the four hundred sixtieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg459 {
	u32 u32;
	struct cvmx_pcieepx_cfg459_s {
		u32 dbg_info_u32 : 32;
	} s;
	struct cvmx_pcieepx_cfg459_s cn52xx;
	struct cvmx_pcieepx_cfg459_s cn52xxp1;
	struct cvmx_pcieepx_cfg459_s cn56xx;
	struct cvmx_pcieepx_cfg459_s cn56xxp1;
	struct cvmx_pcieepx_cfg459_s cn61xx;
	struct cvmx_pcieepx_cfg459_s cn63xx;
	struct cvmx_pcieepx_cfg459_s cn63xxp1;
	struct cvmx_pcieepx_cfg459_s cn66xx;
	struct cvmx_pcieepx_cfg459_s cn68xx;
	struct cvmx_pcieepx_cfg459_s cn68xxp1;
	struct cvmx_pcieepx_cfg459_s cn70xx;
	struct cvmx_pcieepx_cfg459_s cn70xxp1;
	struct cvmx_pcieepx_cfg459_s cn73xx;
	struct cvmx_pcieepx_cfg459_s cn78xx;
	struct cvmx_pcieepx_cfg459_s cn78xxp1;
	struct cvmx_pcieepx_cfg459_s cnf71xx;
	struct cvmx_pcieepx_cfg459_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg459 cvmx_pcieepx_cfg459_t;

/**
 * cvmx_pcieep#_cfg460
 *
 * This register contains the four hundred sixty-first 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg460 {
	u32 u32;
	struct cvmx_pcieepx_cfg460_s {
		u32 reserved_20_31 : 12;
		u32 tphfcc : 8;
		u32 tpdfcc : 12;
	} s;
	struct cvmx_pcieepx_cfg460_s cn52xx;
	struct cvmx_pcieepx_cfg460_s cn52xxp1;
	struct cvmx_pcieepx_cfg460_s cn56xx;
	struct cvmx_pcieepx_cfg460_s cn56xxp1;
	struct cvmx_pcieepx_cfg460_s cn61xx;
	struct cvmx_pcieepx_cfg460_s cn63xx;
	struct cvmx_pcieepx_cfg460_s cn63xxp1;
	struct cvmx_pcieepx_cfg460_s cn66xx;
	struct cvmx_pcieepx_cfg460_s cn68xx;
	struct cvmx_pcieepx_cfg460_s cn68xxp1;
	struct cvmx_pcieepx_cfg460_s cn70xx;
	struct cvmx_pcieepx_cfg460_s cn70xxp1;
	struct cvmx_pcieepx_cfg460_s cn73xx;
	struct cvmx_pcieepx_cfg460_s cn78xx;
	struct cvmx_pcieepx_cfg460_s cn78xxp1;
	struct cvmx_pcieepx_cfg460_s cnf71xx;
	struct cvmx_pcieepx_cfg460_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg460 cvmx_pcieepx_cfg460_t;

/**
 * cvmx_pcieep#_cfg461
 *
 * This register contains the four hundred sixty-second 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg461 {
	u32 u32;
	struct cvmx_pcieepx_cfg461_s {
		u32 reserved_20_31 : 12;
		u32 tchfcc : 8;
		u32 tcdfcc : 12;
	} s;
	struct cvmx_pcieepx_cfg461_s cn52xx;
	struct cvmx_pcieepx_cfg461_s cn52xxp1;
	struct cvmx_pcieepx_cfg461_s cn56xx;
	struct cvmx_pcieepx_cfg461_s cn56xxp1;
	struct cvmx_pcieepx_cfg461_s cn61xx;
	struct cvmx_pcieepx_cfg461_s cn63xx;
	struct cvmx_pcieepx_cfg461_s cn63xxp1;
	struct cvmx_pcieepx_cfg461_s cn66xx;
	struct cvmx_pcieepx_cfg461_s cn68xx;
	struct cvmx_pcieepx_cfg461_s cn68xxp1;
	struct cvmx_pcieepx_cfg461_s cn70xx;
	struct cvmx_pcieepx_cfg461_s cn70xxp1;
	struct cvmx_pcieepx_cfg461_s cn73xx;
	struct cvmx_pcieepx_cfg461_s cn78xx;
	struct cvmx_pcieepx_cfg461_s cn78xxp1;
	struct cvmx_pcieepx_cfg461_s cnf71xx;
	struct cvmx_pcieepx_cfg461_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg461 cvmx_pcieepx_cfg461_t;

/**
 * cvmx_pcieep#_cfg462
 *
 * This register contains the four hundred sixty-third 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg462 {
	u32 u32;
	struct cvmx_pcieepx_cfg462_s {
		u32 reserved_20_31 : 12;
		u32 tchfcc : 8;
		u32 tcdfcc : 12;
	} s;
	struct cvmx_pcieepx_cfg462_s cn52xx;
	struct cvmx_pcieepx_cfg462_s cn52xxp1;
	struct cvmx_pcieepx_cfg462_s cn56xx;
	struct cvmx_pcieepx_cfg462_s cn56xxp1;
	struct cvmx_pcieepx_cfg462_s cn61xx;
	struct cvmx_pcieepx_cfg462_s cn63xx;
	struct cvmx_pcieepx_cfg462_s cn63xxp1;
	struct cvmx_pcieepx_cfg462_s cn66xx;
	struct cvmx_pcieepx_cfg462_s cn68xx;
	struct cvmx_pcieepx_cfg462_s cn68xxp1;
	struct cvmx_pcieepx_cfg462_s cn70xx;
	struct cvmx_pcieepx_cfg462_s cn70xxp1;
	struct cvmx_pcieepx_cfg462_s cn73xx;
	struct cvmx_pcieepx_cfg462_s cn78xx;
	struct cvmx_pcieepx_cfg462_s cn78xxp1;
	struct cvmx_pcieepx_cfg462_s cnf71xx;
	struct cvmx_pcieepx_cfg462_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg462 cvmx_pcieepx_cfg462_t;

/**
 * cvmx_pcieep#_cfg463
 *
 * This register contains the four hundred sixty-fourth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg463 {
	u32 u32;
	struct cvmx_pcieepx_cfg463_s {
		u32 fcltoe : 1;
		u32 reserved_29_30 : 2;
		u32 fcltov : 13;
		u32 reserved_3_15 : 13;
		u32 rqne : 1;
		u32 trbne : 1;
		u32 rtlpfccnr : 1;
	} s;
	struct cvmx_pcieepx_cfg463_cn52xx {
		u32 reserved_3_31 : 29;
		u32 rqne : 1;
		u32 trbne : 1;
		u32 rtlpfccnr : 1;
	} cn52xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn52xxp1;
	struct cvmx_pcieepx_cfg463_cn52xx cn56xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn56xxp1;
	struct cvmx_pcieepx_cfg463_cn52xx cn61xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn63xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn63xxp1;
	struct cvmx_pcieepx_cfg463_cn52xx cn66xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn68xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn68xxp1;
	struct cvmx_pcieepx_cfg463_cn52xx cn70xx;
	struct cvmx_pcieepx_cfg463_cn52xx cn70xxp1;
	struct cvmx_pcieepx_cfg463_s cn73xx;
	struct cvmx_pcieepx_cfg463_s cn78xx;
	struct cvmx_pcieepx_cfg463_s cn78xxp1;
	struct cvmx_pcieepx_cfg463_cn52xx cnf71xx;
	struct cvmx_pcieepx_cfg463_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg463 cvmx_pcieepx_cfg463_t;

/**
 * cvmx_pcieep#_cfg464
 *
 * This register contains the four hundred sixty-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg464 {
	u32 u32;
	struct cvmx_pcieepx_cfg464_s {
		u32 wrr_vc3 : 8;
		u32 wrr_vc2 : 8;
		u32 wrr_vc1 : 8;
		u32 wrr_vc0 : 8;
	} s;
	struct cvmx_pcieepx_cfg464_s cn52xx;
	struct cvmx_pcieepx_cfg464_s cn52xxp1;
	struct cvmx_pcieepx_cfg464_s cn56xx;
	struct cvmx_pcieepx_cfg464_s cn56xxp1;
	struct cvmx_pcieepx_cfg464_s cn61xx;
	struct cvmx_pcieepx_cfg464_s cn63xx;
	struct cvmx_pcieepx_cfg464_s cn63xxp1;
	struct cvmx_pcieepx_cfg464_s cn66xx;
	struct cvmx_pcieepx_cfg464_s cn68xx;
	struct cvmx_pcieepx_cfg464_s cn68xxp1;
	struct cvmx_pcieepx_cfg464_s cn70xx;
	struct cvmx_pcieepx_cfg464_s cn70xxp1;
	struct cvmx_pcieepx_cfg464_s cn73xx;
	struct cvmx_pcieepx_cfg464_s cn78xx;
	struct cvmx_pcieepx_cfg464_s cn78xxp1;
	struct cvmx_pcieepx_cfg464_s cnf71xx;
	struct cvmx_pcieepx_cfg464_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg464 cvmx_pcieepx_cfg464_t;

/**
 * cvmx_pcieep#_cfg465
 *
 * This register contains the four hundred sixty-sixth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg465 {
	u32 u32;
	struct cvmx_pcieepx_cfg465_s {
		u32 wrr_vc7 : 8;
		u32 wrr_vc6 : 8;
		u32 wrr_vc5 : 8;
		u32 wrr_vc4 : 8;
	} s;
	struct cvmx_pcieepx_cfg465_s cn52xx;
	struct cvmx_pcieepx_cfg465_s cn52xxp1;
	struct cvmx_pcieepx_cfg465_s cn56xx;
	struct cvmx_pcieepx_cfg465_s cn56xxp1;
	struct cvmx_pcieepx_cfg465_s cn61xx;
	struct cvmx_pcieepx_cfg465_s cn63xx;
	struct cvmx_pcieepx_cfg465_s cn63xxp1;
	struct cvmx_pcieepx_cfg465_s cn66xx;
	struct cvmx_pcieepx_cfg465_s cn68xx;
	struct cvmx_pcieepx_cfg465_s cn68xxp1;
	struct cvmx_pcieepx_cfg465_s cn70xx;
	struct cvmx_pcieepx_cfg465_s cn70xxp1;
	struct cvmx_pcieepx_cfg465_s cn73xx;
	struct cvmx_pcieepx_cfg465_s cn78xx;
	struct cvmx_pcieepx_cfg465_s cn78xxp1;
	struct cvmx_pcieepx_cfg465_s cnf71xx;
	struct cvmx_pcieepx_cfg465_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg465 cvmx_pcieepx_cfg465_t;

/**
 * cvmx_pcieep#_cfg466
 *
 * This register contains the four hundred sixty-seventh 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg466 {
	u32 u32;
	struct cvmx_pcieepx_cfg466_s {
		u32 rx_queue_order : 1;
		u32 type_ordering : 1;
		u32 reserved_24_29 : 6;
		u32 queue_mode : 3;
		u32 reserved_20_20 : 1;
		u32 header_credits : 8;
		u32 data_credits : 12;
	} s;
	struct cvmx_pcieepx_cfg466_s cn52xx;
	struct cvmx_pcieepx_cfg466_s cn52xxp1;
	struct cvmx_pcieepx_cfg466_s cn56xx;
	struct cvmx_pcieepx_cfg466_s cn56xxp1;
	struct cvmx_pcieepx_cfg466_s cn61xx;
	struct cvmx_pcieepx_cfg466_s cn63xx;
	struct cvmx_pcieepx_cfg466_s cn63xxp1;
	struct cvmx_pcieepx_cfg466_s cn66xx;
	struct cvmx_pcieepx_cfg466_s cn68xx;
	struct cvmx_pcieepx_cfg466_s cn68xxp1;
	struct cvmx_pcieepx_cfg466_s cn70xx;
	struct cvmx_pcieepx_cfg466_s cn70xxp1;
	struct cvmx_pcieepx_cfg466_s cn73xx;
	struct cvmx_pcieepx_cfg466_s cn78xx;
	struct cvmx_pcieepx_cfg466_s cn78xxp1;
	struct cvmx_pcieepx_cfg466_s cnf71xx;
	struct cvmx_pcieepx_cfg466_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg466 cvmx_pcieepx_cfg466_t;

/**
 * cvmx_pcieep#_cfg467
 *
 * This register contains the four hundred sixty-eighth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg467 {
	u32 u32;
	struct cvmx_pcieepx_cfg467_s {
		u32 reserved_24_31 : 8;
		u32 queue_mode : 3;
		u32 reserved_20_20 : 1;
		u32 header_credits : 8;
		u32 data_credits : 12;
	} s;
	struct cvmx_pcieepx_cfg467_s cn52xx;
	struct cvmx_pcieepx_cfg467_s cn52xxp1;
	struct cvmx_pcieepx_cfg467_s cn56xx;
	struct cvmx_pcieepx_cfg467_s cn56xxp1;
	struct cvmx_pcieepx_cfg467_s cn61xx;
	struct cvmx_pcieepx_cfg467_s cn63xx;
	struct cvmx_pcieepx_cfg467_s cn63xxp1;
	struct cvmx_pcieepx_cfg467_s cn66xx;
	struct cvmx_pcieepx_cfg467_s cn68xx;
	struct cvmx_pcieepx_cfg467_s cn68xxp1;
	struct cvmx_pcieepx_cfg467_s cn70xx;
	struct cvmx_pcieepx_cfg467_s cn70xxp1;
	struct cvmx_pcieepx_cfg467_s cn73xx;
	struct cvmx_pcieepx_cfg467_s cn78xx;
	struct cvmx_pcieepx_cfg467_s cn78xxp1;
	struct cvmx_pcieepx_cfg467_s cnf71xx;
	struct cvmx_pcieepx_cfg467_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg467 cvmx_pcieepx_cfg467_t;

/**
 * cvmx_pcieep#_cfg468
 *
 * This register contains the four hundred sixty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg468 {
	u32 u32;
	struct cvmx_pcieepx_cfg468_s {
		u32 reserved_24_31 : 8;
		u32 queue_mode : 3;
		u32 reserved_20_20 : 1;
		u32 header_credits : 8;
		u32 data_credits : 12;
	} s;
	struct cvmx_pcieepx_cfg468_s cn52xx;
	struct cvmx_pcieepx_cfg468_s cn52xxp1;
	struct cvmx_pcieepx_cfg468_s cn56xx;
	struct cvmx_pcieepx_cfg468_s cn56xxp1;
	struct cvmx_pcieepx_cfg468_s cn61xx;
	struct cvmx_pcieepx_cfg468_s cn63xx;
	struct cvmx_pcieepx_cfg468_s cn63xxp1;
	struct cvmx_pcieepx_cfg468_s cn66xx;
	struct cvmx_pcieepx_cfg468_s cn68xx;
	struct cvmx_pcieepx_cfg468_s cn68xxp1;
	struct cvmx_pcieepx_cfg468_s cn70xx;
	struct cvmx_pcieepx_cfg468_s cn70xxp1;
	struct cvmx_pcieepx_cfg468_s cn73xx;
	struct cvmx_pcieepx_cfg468_s cn78xx;
	struct cvmx_pcieepx_cfg468_s cn78xxp1;
	struct cvmx_pcieepx_cfg468_s cnf71xx;
	struct cvmx_pcieepx_cfg468_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg468 cvmx_pcieepx_cfg468_t;

/**
 * cvmx_pcieep#_cfg490
 *
 * PCIE_CFG490 = Four hundred ninety-first 32-bits of PCIE type 0 config space
 * (VC0 Posted Buffer Depth)
 */
union cvmx_pcieepx_cfg490 {
	u32 u32;
	struct cvmx_pcieepx_cfg490_s {
		u32 reserved_26_31 : 6;
		u32 header_depth : 10;
		u32 reserved_14_15 : 2;
		u32 data_depth : 14;
	} s;
	struct cvmx_pcieepx_cfg490_s cn52xx;
	struct cvmx_pcieepx_cfg490_s cn52xxp1;
	struct cvmx_pcieepx_cfg490_s cn56xx;
	struct cvmx_pcieepx_cfg490_s cn56xxp1;
	struct cvmx_pcieepx_cfg490_s cn61xx;
	struct cvmx_pcieepx_cfg490_s cn63xx;
	struct cvmx_pcieepx_cfg490_s cn63xxp1;
	struct cvmx_pcieepx_cfg490_s cn66xx;
	struct cvmx_pcieepx_cfg490_s cn68xx;
	struct cvmx_pcieepx_cfg490_s cn68xxp1;
	struct cvmx_pcieepx_cfg490_s cn70xx;
	struct cvmx_pcieepx_cfg490_s cn70xxp1;
	struct cvmx_pcieepx_cfg490_s cnf71xx;
};

typedef union cvmx_pcieepx_cfg490 cvmx_pcieepx_cfg490_t;

/**
 * cvmx_pcieep#_cfg491
 *
 * PCIE_CFG491 = Four hundred ninety-second 32-bits of PCIE type 0 config space
 * (VC0 Non-Posted Buffer Depth)
 */
union cvmx_pcieepx_cfg491 {
	u32 u32;
	struct cvmx_pcieepx_cfg491_s {
		u32 reserved_26_31 : 6;
		u32 header_depth : 10;
		u32 reserved_14_15 : 2;
		u32 data_depth : 14;
	} s;
	struct cvmx_pcieepx_cfg491_s cn52xx;
	struct cvmx_pcieepx_cfg491_s cn52xxp1;
	struct cvmx_pcieepx_cfg491_s cn56xx;
	struct cvmx_pcieepx_cfg491_s cn56xxp1;
	struct cvmx_pcieepx_cfg491_s cn61xx;
	struct cvmx_pcieepx_cfg491_s cn63xx;
	struct cvmx_pcieepx_cfg491_s cn63xxp1;
	struct cvmx_pcieepx_cfg491_s cn66xx;
	struct cvmx_pcieepx_cfg491_s cn68xx;
	struct cvmx_pcieepx_cfg491_s cn68xxp1;
	struct cvmx_pcieepx_cfg491_s cn70xx;
	struct cvmx_pcieepx_cfg491_s cn70xxp1;
	struct cvmx_pcieepx_cfg491_s cnf71xx;
};

typedef union cvmx_pcieepx_cfg491 cvmx_pcieepx_cfg491_t;

/**
 * cvmx_pcieep#_cfg492
 *
 * PCIE_CFG492 = Four hundred ninety-third 32-bits of PCIE type 0 config space
 * (VC0 Completion Buffer Depth)
 */
union cvmx_pcieepx_cfg492 {
	u32 u32;
	struct cvmx_pcieepx_cfg492_s {
		u32 reserved_26_31 : 6;
		u32 header_depth : 10;
		u32 reserved_14_15 : 2;
		u32 data_depth : 14;
	} s;
	struct cvmx_pcieepx_cfg492_s cn52xx;
	struct cvmx_pcieepx_cfg492_s cn52xxp1;
	struct cvmx_pcieepx_cfg492_s cn56xx;
	struct cvmx_pcieepx_cfg492_s cn56xxp1;
	struct cvmx_pcieepx_cfg492_s cn61xx;
	struct cvmx_pcieepx_cfg492_s cn63xx;
	struct cvmx_pcieepx_cfg492_s cn63xxp1;
	struct cvmx_pcieepx_cfg492_s cn66xx;
	struct cvmx_pcieepx_cfg492_s cn68xx;
	struct cvmx_pcieepx_cfg492_s cn68xxp1;
	struct cvmx_pcieepx_cfg492_s cn70xx;
	struct cvmx_pcieepx_cfg492_s cn70xxp1;
	struct cvmx_pcieepx_cfg492_s cnf71xx;
};

typedef union cvmx_pcieepx_cfg492 cvmx_pcieepx_cfg492_t;

/**
 * cvmx_pcieep#_cfg515
 *
 * This register contains the five hundred sixteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg515 {
	u32 u32;
	struct cvmx_pcieepx_cfg515_s {
		u32 reserved_21_31 : 11;
		u32 s_d_e : 1;
		u32 ctcrb : 1;
		u32 cpyts : 1;
		u32 dsc : 1;
		u32 reserved_8_16 : 9;
		u32 n_fts : 8;
	} s;
	struct cvmx_pcieepx_cfg515_cn61xx {
		u32 reserved_21_31 : 11;
		u32 s_d_e : 1;
		u32 ctcrb : 1;
		u32 cpyts : 1;
		u32 dsc : 1;
		u32 le : 9;
		u32 n_fts : 8;
	} cn61xx;
	struct cvmx_pcieepx_cfg515_cn61xx cn63xx;
	struct cvmx_pcieepx_cfg515_cn61xx cn63xxp1;
	struct cvmx_pcieepx_cfg515_cn61xx cn66xx;
	struct cvmx_pcieepx_cfg515_cn61xx cn68xx;
	struct cvmx_pcieepx_cfg515_cn61xx cn68xxp1;
	struct cvmx_pcieepx_cfg515_cn61xx cn70xx;
	struct cvmx_pcieepx_cfg515_cn61xx cn70xxp1;
	struct cvmx_pcieepx_cfg515_cn61xx cn73xx;
	struct cvmx_pcieepx_cfg515_cn78xx {
		u32 reserved_21_31 : 11;
		u32 s_d_e : 1;
		u32 ctcrb : 1;
		u32 cpyts : 1;
		u32 dsc : 1;
		u32 alaneflip : 1;
		u32 pdetlane : 3;
		u32 nlanes : 5;
		u32 n_fts : 8;
	} cn78xx;
	struct cvmx_pcieepx_cfg515_cn61xx cn78xxp1;
	struct cvmx_pcieepx_cfg515_cn61xx cnf71xx;
	struct cvmx_pcieepx_cfg515_cn78xx cnf75xx;
};

typedef union cvmx_pcieepx_cfg515 cvmx_pcieepx_cfg515_t;

/**
 * cvmx_pcieep#_cfg516
 *
 * This register contains the five hundred seventeenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg516 {
	u32 u32;
	struct cvmx_pcieepx_cfg516_s {
		u32 phy_stat : 32;
	} s;
	struct cvmx_pcieepx_cfg516_s cn52xx;
	struct cvmx_pcieepx_cfg516_s cn52xxp1;
	struct cvmx_pcieepx_cfg516_s cn56xx;
	struct cvmx_pcieepx_cfg516_s cn56xxp1;
	struct cvmx_pcieepx_cfg516_s cn61xx;
	struct cvmx_pcieepx_cfg516_s cn63xx;
	struct cvmx_pcieepx_cfg516_s cn63xxp1;
	struct cvmx_pcieepx_cfg516_s cn66xx;
	struct cvmx_pcieepx_cfg516_s cn68xx;
	struct cvmx_pcieepx_cfg516_s cn68xxp1;
	struct cvmx_pcieepx_cfg516_s cn70xx;
	struct cvmx_pcieepx_cfg516_s cn70xxp1;
	struct cvmx_pcieepx_cfg516_s cn73xx;
	struct cvmx_pcieepx_cfg516_s cn78xx;
	struct cvmx_pcieepx_cfg516_s cn78xxp1;
	struct cvmx_pcieepx_cfg516_s cnf71xx;
	struct cvmx_pcieepx_cfg516_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg516 cvmx_pcieepx_cfg516_t;

/**
 * cvmx_pcieep#_cfg517
 *
 * This register contains the five hundred eighteenth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg517 {
	u32 u32;
	struct cvmx_pcieepx_cfg517_s {
		u32 phy_ctrl : 32;
	} s;
	struct cvmx_pcieepx_cfg517_s cn52xx;
	struct cvmx_pcieepx_cfg517_s cn52xxp1;
	struct cvmx_pcieepx_cfg517_s cn56xx;
	struct cvmx_pcieepx_cfg517_s cn56xxp1;
	struct cvmx_pcieepx_cfg517_s cn61xx;
	struct cvmx_pcieepx_cfg517_s cn63xx;
	struct cvmx_pcieepx_cfg517_s cn63xxp1;
	struct cvmx_pcieepx_cfg517_s cn66xx;
	struct cvmx_pcieepx_cfg517_s cn68xx;
	struct cvmx_pcieepx_cfg517_s cn68xxp1;
	struct cvmx_pcieepx_cfg517_s cn70xx;
	struct cvmx_pcieepx_cfg517_s cn70xxp1;
	struct cvmx_pcieepx_cfg517_s cn73xx;
	struct cvmx_pcieepx_cfg517_s cn78xx;
	struct cvmx_pcieepx_cfg517_s cn78xxp1;
	struct cvmx_pcieepx_cfg517_s cnf71xx;
	struct cvmx_pcieepx_cfg517_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg517 cvmx_pcieepx_cfg517_t;

/**
 * cvmx_pcieep#_cfg548
 *
 * This register contains the five hundred forty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg548 {
	u32 u32;
	struct cvmx_pcieepx_cfg548_s {
		u32 reserved_26_31 : 6;
		u32 rss : 2;
		u32 eiedd : 1;
		u32 reserved_19_22 : 4;
		u32 dcbd : 1;
		u32 dtdd : 1;
		u32 ed : 1;
		u32 reserved_13_15 : 3;
		u32 rxeq_ph01_en : 1;
		u32 erd : 1;
		u32 ecrd : 1;
		u32 ep2p3d : 1;
		u32 dsg3 : 1;
		u32 reserved_1_7 : 7;
		u32 grizdnc : 1;
	} s;
	struct cvmx_pcieepx_cfg548_s cn73xx;
	struct cvmx_pcieepx_cfg548_s cn78xx;
	struct cvmx_pcieepx_cfg548_s cn78xxp1;
	struct cvmx_pcieepx_cfg548_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg548 cvmx_pcieepx_cfg548_t;

/**
 * cvmx_pcieep#_cfg554
 *
 * This register contains the five hundred fifty-fifth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg554 {
	u32 u32;
	struct cvmx_pcieepx_cfg554_s {
		u32 reserved_27_31 : 5;
		u32 scefpm : 1;
		u32 reserved_25_25 : 1;
		u32 iif : 1;
		u32 prv : 16;
		u32 reserved_6_7 : 2;
		u32 p23td : 1;
		u32 bt : 1;
		u32 fm : 4;
	} s;
	struct cvmx_pcieepx_cfg554_cn73xx {
		u32 reserved_25_31 : 7;
		u32 iif : 1;
		u32 prv : 16;
		u32 reserved_6_7 : 2;
		u32 p23td : 1;
		u32 bt : 1;
		u32 fm : 4;
	} cn73xx;
	struct cvmx_pcieepx_cfg554_s cn78xx;
	struct cvmx_pcieepx_cfg554_s cn78xxp1;
	struct cvmx_pcieepx_cfg554_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg554 cvmx_pcieepx_cfg554_t;

/**
 * cvmx_pcieep#_cfg558
 *
 * This register contains the five hundred fifty-ninth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg558 {
	u32 u32;
	struct cvmx_pcieepx_cfg558_s {
		u32 ple : 1;
		u32 rxstatus : 31;
	} s;
	struct cvmx_pcieepx_cfg558_s cn73xx;
	struct cvmx_pcieepx_cfg558_s cn78xx;
	struct cvmx_pcieepx_cfg558_s cn78xxp1;
	struct cvmx_pcieepx_cfg558_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg558 cvmx_pcieepx_cfg558_t;

/**
 * cvmx_pcieep#_cfg559
 *
 * This register contains the five hundred sixtieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pcieepx_cfg559 {
	u32 u32;
	struct cvmx_pcieepx_cfg559_s {
		u32 reserved_1_31 : 31;
		u32 dbi_ro_wr_en : 1;
	} s;
	struct cvmx_pcieepx_cfg559_s cn73xx;
	struct cvmx_pcieepx_cfg559_s cn78xx;
	struct cvmx_pcieepx_cfg559_s cn78xxp1;
	struct cvmx_pcieepx_cfg559_s cnf75xx;
};

typedef union cvmx_pcieepx_cfg559 cvmx_pcieepx_cfg559_t;

#endif
