#define XERR
#include "loop.ih"

    // no tumor is present. Maybe false postive, if not: true negative

        // by screen.cc

bool Loop::falsePositive(ModBase *modBase, double screeningAge)
{
    double rnd = Random::instance().uniform();
    double spec = modBase->specificity(screeningAge);

    if (rnd <= spec)
    {
        //        ++d_nRoundTN[d_round];
        modBase->addTrueNegative(d_round);

        g_log << "      " << rnd << " <= specificity(" <<
                screeningAge << ") = " << spec << ": no false positive\n";

        return false;           // not a false positive: a true negative
    }

    g_log << "      " << rnd << " > specificity(" <<
            screeningAge << ") = " << spec << ": false positive\n";

    modBase->addFalsePositive(d_round);
    //        ++d_nRoundFP[d_round];

    d_roundInfo[d_round] = FALSE_POSITIVE;

        // add the using costs to the case and biop costs
    d_caseCost += addBiopCosts(d_costs.usingAt(screeningAge));

    return true;                // biopsy shows a false positive
}



