--- a/Library/abs_theory/Manual/Makefile
+++ b/Library/abs_theory/Manual/Makefile
@@ -15,13 +15,13 @@
 
 clean:;                                                                 \
     rm -f *.dvi *.aux *.toc *.log *.idx *.ilg entries.tex;              \
-    echo "\begin{theindex}" >index.tex;                                 \
-    echo "\mbox{}" >>index.tex;                                         \
-    echo "\end{theindex}" >>index.tex
+    printf '\\begin{theindex}' >index.tex;                                 \
+    printf '\\mbox{}' >>index.tex;                                         \
+    printf '\\end{theindex}' >>index.tex
 
 ids:;                                                                   \
-    echo "\chapter{ML Functions in the {\tt abs\_theory} Library}" >entries.tex;   \
-    echo "\input{entries-intro}" >>entries.tex;                         \
+    printf '\\chapter{ML Functions in the {\\tt abs\\_theory} Library}' >entries.tex;   \
+    printf '\\input{entries-intro}' >>entries.tex;                         \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index:;                                                                 \
--- a/Library/arith/Manual/Makefile
+++ b/Library/arith/Manual/Makefile
@@ -26,16 +26,16 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the arith Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the arith Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index: 
--- a/Library/finite_sets/Manual/Makefile
+++ b/Library/finite_sets/Manual/Makefile
@@ -26,45 +26,45 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: theorems ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{The type definition}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{The type definition}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/sdef theorems.tex
-	@echo "\section{Basic properties of {\tt EMPTY}, {\tt INSERT}, and {\tt IN}}">>theorems.tex
+	@printf '\\section{Basic properties of {\\tt EMPTY}, {\\tt INSERT}, and {\\tt IN}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/basic theorems.tex
-	@echo "\section{Set inclusion}">>theorems.tex
+	@printf '\\section{Set inclusion}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/subs theorems.tex
-	@echo "\section{Intersection and union}">>theorems.tex
+	@printf '\\section{Intersection and union}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/unin theorems.tex
-	@echo "\section{Set difference}">>theorems.tex
+	@printf '\\section{Set difference}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/diff theorems.tex
-	@echo "\section{Deletion of an element}">>theorems.tex
+	@printf '\\section{Deletion of an element}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/del theorems.tex
-	@echo "\section{Disjoint sets}">>theorems.tex
+	@printf '\\section{Disjoint sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/disj theorems.tex
-	@echo "\section{The {\tt CHOICE} and {\tt REST} functions}">>theorems.tex
+	@printf '\\section{The {\\tt CHOICE} and {\\tt REST} functions}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/chre theorems.tex
-	@echo "\section{Image of a function on a set}">>theorems.tex
+	@printf '\\section{Image of a function on a set}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/image theorems.tex
-	@echo "\section{Mappings between sets}">>theorems.tex
+	@printf '\\section{Mappings between sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/fun theorems.tex
-	@echo "\section{Singleton sets}">>theorems.tex
+	@printf '\\section{Singleton sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/sing theorems.tex
-	@echo "\section{Cardinality of sets}">>theorems.tex
+	@printf '\\section{Cardinality of sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/card theorems.tex
 
 index: 
--- a/Library/latex-hol/Manual/Makefile
+++ b/Library/latex-hol/Manual/Makefile
@@ -28,16 +28,16 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids 
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the {\tt latex-hol} Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the {\\tt latex-hol} Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 
--- a/Library/more_arithmetic/Manual/Makefile
+++ b/Library/more_arithmetic/Manual/Makefile
@@ -26,40 +26,40 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids theorems
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the more\_arithmetic Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the more\\_arithmetic Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}\label{thms}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{Theorems about Inequalities}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}\\label{thms}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{Theorems about Inequalities}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/ineq theorems.tex
-	@echo "\section{Theorems about {\tt 0}}">>theorems.tex
+	@printf '\\section{Theorems about {\\tt 0}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/zero_ineq theorems.tex
-	@echo "\section{Theorems about {\tt SUC}}">>theorems.tex
+	@printf '\\section{Theorems about {\\tt SUC}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/suc theorems.tex
-	@echo "\section{Theorems about {\tt PRE}}">>theorems.tex
+	@printf '\\section{Theorems about {\\tt PRE}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/pre theorems.tex
-	@echo "\section{Theorems about Addition}">>theorems.tex
+	@printf '\\section{Theorems about Addition}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/add theorems.tex
-	@echo "\section{Theorems about Subtraction}">>theorems.tex
+	@printf '\\section{Theorems about Subtraction}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/sub theorems.tex
-	@echo "\section{Theorems about Multiplication and Exponential Functions}">>theorems.tex
+	@printf '\\section{Theorems about Multiplication and Exponential Functions}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/mult theorems.tex
-	@echo "\section{Theorems about Division}">>theorems.tex
+	@printf '\\section{Theorems about Division}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/div_mod theorems.tex
-	@echo "\section{Theorems about Maximum and Minimum}">>theorems.tex
+	@printf '\\section{Theorems about Maximum and Minimum}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/min_max theorems.tex
-	@echo "\section{Theorems about Odd and Even Numbers}">>theorems.tex
+	@printf '\\section{Theorems about Odd and Even Numbers}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/odd_even theorems.tex
 
 index: 
--- a/Library/numeral/Manual/Makefile
+++ b/Library/numeral/Manual/Makefile
@@ -15,19 +15,19 @@
 
 clean:;                                                                 \
     rm -f *.dvi *.aux *.toc *.log *.idx *.ilg entries.tex;              \
-    echo "\begin{theindex}" >index.tex;                                 \
-    echo "\mbox{}" >>index.tex;                                         \
-    echo "\end{theindex}" >>index.tex
+    printf '\\begin{theindex}' >index.tex;                                 \
+    printf '\\mbox{}' >>index.tex;                                         \
+    printf '\\end{theindex}' >>index.tex
 
 ids:;                                                                   \
-    echo "\chapter{ML Functions in the numeral Library}" >entries.tex;  \
-    echo "\input{entries-intro}" >>entries.tex;                         \
+    printf '\\chapter{ML Functions in the numeral Library}' >entries.tex;  \
+    printf '\\input{entries-intro}' >>entries.tex;                         \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 thms:;                                                                  \
-    echo "\chapter{Pre-proved Theorems}" > theorems.tex;                \
-    echo "\input{theorems-intro}" >> theorems.tex;                      \
-    echo "\section{Numeral theory}" >> theorems.tex;                    \
+    printf '\\chapter{Pre-proved Theorems}' > theorems.tex;                \
+    printf '\\input{theorems-intro}' >> theorems.tex;                      \
+    printf '\\section{Numeral theory}' >> theorems.tex;                    \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/numeral theorems.tex
 
 index:;                                                                 \
--- a/Library/pair/Manual/Makefile
+++ b/Library/pair/Manual/Makefile
@@ -26,19 +26,19 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg entries.tex theorems.tex; \
-	echo "\begin{theindex}" >index.tex;                                 \
-	echo "\mbox{}" >>index.tex;                                         \
-	echo "\end{theindex}" >>index.tex
+	printf '\\begin{theindex}' >index.tex;                                 \
+	printf '\\mbox{}' >>index.tex;                                         \
+	printf '\\end{theindex}' >>index.tex
 
 ids:
-	echo "\chapter{ML Functions in the pair Library}" >entries.tex;   	\
-	echo "\input{entries-intro}" >>entries.tex;                         \
+	printf '\\chapter{ML Functions in the pair Library}' >entries.tex;   	\
+	printf '\\input{entries-intro}' >>entries.tex;                         \
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{Theorems}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{Theorems}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms theorems.tex
 
 index:
--- a/Library/parser/Manual/Makefile
+++ b/Library/parser/Manual/Makefile
@@ -25,20 +25,20 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids theorems
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the parser Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the parser Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
 
 index: 
 	${MAKEINDEX} parser.idx index.tex 
--- a/Library/pred_sets/Manual/Makefile
+++ b/Library/pred_sets/Manual/Makefile
@@ -25,47 +25,47 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: theorems ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{Membership, equality, and set specifications}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{Membership, equality, and set specifications}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/mem theorems.tex
-	@echo "\section{The empty and universal sets}">>theorems.tex
+	@printf '\\section{The empty and universal sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/emuniv theorems.tex
-	@echo "\section{Set inclusion}">>theorems.tex
+	@printf '\\section{Set inclusion}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/subs theorems.tex
-	@echo "\section{Intersection and union}">>theorems.tex
+	@printf '\\section{Intersection and union}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/unin theorems.tex
-	@echo "\section{Set difference}">>theorems.tex
+	@printf '\\section{Set difference}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/diff theorems.tex
-	@echo "\section{Disjoint sets}">>theorems.tex
+	@printf '\\section{Disjoint sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/disj theorems.tex
-	@echo "\section{Insertion and deletion of an element}">>theorems.tex
+	@printf '\\section{Insertion and deletion of an element}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/insdel theorems.tex
-	@echo "\section{The {\tt CHOICE} and {\tt REST} functions}">>theorems.tex
+	@printf '\\section{The {\\tt CHOICE} and {\\tt REST} functions}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/chre theorems.tex
-	@echo "\section{Image of a function on a set}">>theorems.tex
+	@printf '\\section{Image of a function on a set}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/image theorems.tex
-	@echo "\section{Mappings between sets}">>theorems.tex
+	@printf '\\section{Mappings between sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/fun theorems.tex
-	@echo "\section{Singleton sets}">>theorems.tex
+	@printf '\\section{Singleton sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/sing theorems.tex
-	@echo "\section{Finite and infinite sets}">>theorems.tex
+	@printf '\\section{Finite and infinite sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/fin theorems.tex
-	@echo "\section{Cardinality of sets}">>theorems.tex
+	@printf '\\section{Cardinality of sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/card theorems.tex
 
 index: 
--- a/Library/prettyp/Manual/Makefile
+++ b/Library/prettyp/Manual/Makefile
@@ -26,16 +26,16 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the prettyp Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the prettyp Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index: 
--- a/Library/reals/Manual/Makefile
+++ b/Library/reals/Manual/Makefile
@@ -15,34 +15,34 @@
 
 clean:;                                                                    \
     rm -f *.dvi *.aux *.toc *.log *.idx *.ilg;                             \
-    echo "\begin{theindex}" >index.tex;                                    \
-    echo "\mbox{}" >>index.tex;                                            \
-    echo "\end{theindex}" >>index.tex
+    printf '\\begin{theindex}' >index.tex;                                    \
+    printf '\\mbox{}' >>index.tex;                                            \
+    printf '\\end{theindex}' >>index.tex
 
 tex: theorems
 
 theorems:;                                                                 \
-    echo "\chapter{Pre-proved Theorems}" >theorems.tex;                    \
-    echo "\input{theorems-intro}" >>theorems.tex;                          \
-    echo "\section{HRAT}" >>theorems.tex;                                  \
+    printf '\\chapter{Pre-proved Theorems}' >theorems.tex;                    \
+    printf '\\input{theorems-intro}' >>theorems.tex;                          \
+    printf '\\section{HRAT}' >>theorems.tex;                                  \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/HRAT theorems.tex;     \
-    echo "\section{HREAL}" >>theorems.tex;                                 \
+    printf '\\section{HREAL}' >>theorems.tex;                                 \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/HREAL theorems.tex;    \
-    echo "\section{REALAX}" >>theorems.tex;                                \
+    printf '\\section{REALAX}' >>theorems.tex;                                \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/REALAX theorems.tex;   \
-    echo "\section{REAL}" >>theorems.tex;                                  \
+    printf '\\section{REAL}' >>theorems.tex;                                  \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/REAL theorems.tex;     \
-    echo "\section{TOPOLOGY}" >>theorems.tex;                              \
+    printf '\\section{TOPOLOGY}' >>theorems.tex;                              \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/TOPOLOGY theorems.tex; \
-    echo "\section{NETS}" >>theorems.tex;                                  \
+    printf '\\section{NETS}' >>theorems.tex;                                  \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/NETS theorems.tex;     \
-    echo "\section{LIM}" >>theorems.tex;                                   \
+    printf '\\section{LIM}' >>theorems.tex;                                   \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/LIM theorems.tex;      \
-    echo "\section{SEQ}" >>theorems.tex;                                   \
+    printf '\\section{SEQ}' >>theorems.tex;                                   \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/SEQ theorems.tex;      \
-    echo "\section{POWSER}" >>theorems.tex;                                \
+    printf '\\section{POWSER}' >>theorems.tex;                                \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/POWSER theorems.tex;   \
-    echo "\section{TRANSC}" >>theorems.tex;                                \
+    printf '\\section{TRANSC}' >>theorems.tex;                                \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/TRANSC theorems.tex
 
 reals:;                                                                    \
--- a/Library/record_proof/Manual/Makefile
+++ b/Library/record_proof/Manual/Makefile
@@ -27,17 +27,17 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex:	 functions
 	@echo "TeX files made"
 
 functions:
-	@echo "\chapter{ML Functions in the {\tt record\_proof} Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the {\\tt record\\_proof} Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help} entries.tex
 
 index: 
--- a/Library/reduce/Manual/Makefile
+++ b/Library/reduce/Manual/Makefile
@@ -15,13 +15,13 @@
 
 clean:;                                                                 \
     rm -f *.dvi *.aux *.toc *.log *.idx *.ilg entries.tex;              \
-    echo "\begin{theindex}" >index.tex;                                 \
-    echo "\mbox{}" >>index.tex;                                         \
-    echo "\end{theindex}" >>index.tex
+    printf '\\begin{theindex}' >index.tex;                                 \
+    printf '\\mbox{}' >>index.tex;                                         \
+    printf '\\end{theindex}' >>index.tex
 
 ids:;                                                                   \
-    echo "\chapter{ML Functions in the reduce Library}" >entries.tex;   \
-    echo "\input{entries-intro}" >>entries.tex;                         \
+    printf '\\chapter{ML Functions in the reduce Library}' >entries.tex;   \
+    printf '\\input{entries-intro}' >>entries.tex;                         \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index:;                                                                 \
--- a/Library/res_quan/Manual/Makefile
+++ b/Library/res_quan/Manual/Makefile
@@ -27,22 +27,22 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: theorems functions
 	@echo "TeX files made"
 
 functions:
-	@echo "\chapter{ML Functions in the {\tt res\_quan} Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the {\\tt res\\_quan} Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms theorems.tex
 
 index: 
--- a/Library/sets/Manual/Makefile
+++ b/Library/sets/Manual/Makefile
@@ -26,49 +26,49 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: theorems ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the sets Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the sets Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{The type definition}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{The type definition}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/sdef theorems.tex
-	@echo "\section{Membership, equality, and set specifications}">>theorems.tex
+	@printf '\\section{Membership, equality, and set specifications}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/mem theorems.tex
-	@echo "\section{The empty and universal sets}">>theorems.tex
+	@printf '\\section{The empty and universal sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/emuniv theorems.tex
-	@echo "\section{Set inclusion}">>theorems.tex
+	@printf '\\section{Set inclusion}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/subs theorems.tex
-	@echo "\section{Intersection and union}">>theorems.tex
+	@printf '\\section{Intersection and union}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/unin theorems.tex
-	@echo "\section{Set difference}">>theorems.tex
+	@printf '\\section{Set difference}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/diff theorems.tex
-	@echo "\section{Disjoint sets}">>theorems.tex
+	@printf '\\section{Disjoint sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/disj theorems.tex
-	@echo "\section{Insertion and deletion of an element}">>theorems.tex
+	@printf '\\section{Insertion and deletion of an element}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/insdel theorems.tex
-	@echo "\section{The {\tt CHOICE} and {\tt REST} functions}">>theorems.tex
+	@printf '\\section{The {\\tt CHOICE} and {\\tt REST} functions}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/chre theorems.tex
-	@echo "\section{Image of a function on a set}">>theorems.tex
+	@printf '\\section{Image of a function on a set}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/image theorems.tex
-	@echo "\section{Mappings between sets}">>theorems.tex
+	@printf '\\section{Mappings between sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/fun theorems.tex
-	@echo "\section{Singleton sets}">>theorems.tex
+	@printf '\\section{Singleton sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/sing theorems.tex
-	@echo "\section{Finite and infinite sets}">>theorems.tex
+	@printf '\\section{Finite and infinite sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/fin theorems.tex
-	@echo "\section{Cardinality of sets}">>theorems.tex
+	@printf '\\section{Cardinality of sets}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/card theorems.tex
 
 index: 
--- a/Library/string/Manual/Makefile
+++ b/Library/string/Manual/Makefile
@@ -26,24 +26,24 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids theorems
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the string Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the string Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{Definitions}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{Definitions}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/defs theorems.tex
-	@echo "\section{Theorems}">>theorems.tex
+	@printf '\\section{Theorems}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms theorems.tex
 
 index: 
--- a/Library/taut/Manual/Makefile
+++ b/Library/taut/Manual/Makefile
@@ -26,16 +26,16 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the taut Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the taut Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index: 
--- a/Library/trs/Manual/Makefile
+++ b/Library/trs/Manual/Makefile
@@ -26,16 +26,16 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the trs Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the trs Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index: 
--- a/Library/unwind/Manual/Makefile
+++ b/Library/unwind/Manual/Makefile
@@ -26,16 +26,16 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{ML Functions in the unwind Library}">entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the unwind Library}'>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 index: 
--- a/Library/wellorder/Manual/Makefile
+++ b/Library/wellorder/Manual/Makefile
@@ -14,26 +14,26 @@
 
 clean:;                                                                 \
     rm -f *.dvi *.aux *.toc *.log *.idx *.ilg entries.tex;              \
-    echo "\begin{theindex}" >index.tex;                                 \
-    echo "\mbox{}" >>index.tex;                                         \
-    echo "\end{theindex}" >>index.tex
+    printf '\\begin{theindex}' >index.tex;                                 \
+    printf '\\mbox{}' >>index.tex;                                         \
+    printf '\\end{theindex}' >>index.tex
 
 tex: theorems ids
 
 ids:;                                                                   \
-    echo "\chapter{ML Functions in the wellorder Library}" >entries.tex;\
-    echo "\label{entries}" >>entries.tex;                               \
-    echo "\input{entries-intro}" >>entries.tex;                         \
+    printf '\\chapter{ML Functions in the wellorder Library}' >entries.tex;\
+    printf '\\label{entries}' >>entries.tex;                               \
+    printf '\\input{entries-intro}' >>entries.tex;                         \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:;                                                              \
-    echo "\chapter{Pre-proved Theorems}" >theorems.tex;                 \
-    echo "\input{theorems-intro}" >>theorems.tex;                       \
-    echo "\section{Basic definitions}" >>theorems.tex;                  \
+    printf '\\chapter{Pre-proved Theorems}' >theorems.tex;                 \
+    printf '\\input{theorems-intro}' >>theorems.tex;                       \
+    printf '\\section{Basic definitions}' >>theorems.tex;                  \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/defs theorems.tex;  \
-    echo "\section{Miscellaneous lemmas}" >>theorems.tex;               \
+    printf '\\section{Miscellaneous lemmas}' >>theorems.tex;               \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/lemmas theorems.tex;\
-    echo "\section{Main theorems}"  >>theorems.tex;                     \
+    printf '\\section{Main theorems}'  >>theorems.tex;                     \
     /bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/main theorems.tex
 
 wellorder:;                                                             \
--- a/Library/window/Manual/Makefile
+++ b/Library/window/Manual/Makefile
@@ -26,24 +26,24 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg entries.tex *.bak;        \
-	echo "\begin{theindex}" >index.tex;                                 \
-	echo "\mbox{}" >>index.tex;                                         \
-	echo "\end{theindex}" >>index.tex
+	printf '\\begin{theindex}' >index.tex;                                 \
+	printf '\\mbox{}' >>index.tex;                                         \
+	printf '\\end{theindex}' >>index.tex
 
 tex: ids theorems
 	@echo "TeX files makde"
 
 ids:
-	echo "\chapter{ML Functions in the window Library}" >entries.tex;   \
-	echo "\input{entries-intro}" >>entries.tex;                         \
+	printf '\\chapter{ML Functions in the window Library}' >entries.tex;   \
+	printf '\\input{entries-intro}' >>entries.tex;                         \
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{Definitions}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{Definitions}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/defs theorems.tex
-	@echo "\section{Theorems}">>theorems.tex
+	@printf '\\section{Theorems}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms theorems.tex
 
 index:
--- a/Library/word/Manual/Makefile
+++ b/Library/word/Manual/Makefile
@@ -27,33 +27,33 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: theorems functions
 	@echo "TeX files made"
 
 functions:
-	@echo "\chapter{ML Functions in the {\tt word} Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the {\\tt word} Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/entries entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{The theory {\tt word\_base}}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{The theory {\\tt word\\_base}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/word_base theorems.tex
-	@echo "\section{The theory {\tt word\_bitop}}">>theorems.tex
+	@printf '\\section{The theory {\\tt word\\_bitop}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/word_bitop theorems.tex
-	@echo "\section{The theory {\tt word\_num}}">>theorems.tex
+	@printf '\\section{The theory {\\tt word\\_num}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/word_num theorems.tex
-	@echo "\section{The theory {\tt bword\_bitop}}">>theorems.tex
+	@printf '\\section{The theory {\\tt bword\\_bitop}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/bword_bitop theorems.tex
-	@echo "\section{The theory {\tt bword\_num}}">>theorems.tex
+	@printf '\\section{The theory {\\tt bword\\_num}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/bword_num theorems.tex
-	@echo "\section{The theory {\tt bword\_arith}}">>theorems.tex
+	@printf '\\section{The theory {\\tt bword\\_arith}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/thms/bword_arith theorems.tex
 
 index: 
--- a/Manual/Reference/Makefile
+++ b/Manual/Reference/Makefile
@@ -19,46 +19,46 @@
 
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex: ids theorems
 	@echo "TeX files made"
 
 ids:
-	@echo "\chapter{Pre-defined ML Identifiers}" > entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{Pre-defined ML Identifiers}' > entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/ENTRIES entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{Definitions of Basic Logical Constants}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{Definitions of Basic Logical Constants}'>>theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/basic-logic theorems.tex
-	@echo "\section{Constants for syntactic abbreviations}" >> theorems.tex
+	@printf '\\section{Constants for syntactic abbreviations}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/syntax theorems.tex
-	@echo "\section{Axioms}" >> theorems.tex
+	@printf '\\section{Axioms}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/axioms theorems.tex
-	@echo "\section{Logical tautologies}" >> theorems.tex
+	@printf '\\section{Logical tautologies}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/logic theorems.tex
-	@echo "\section{Theorems about functions}" >> theorems.tex
+	@printf '\\section{Theorems about functions}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/functions theorems.tex
-	@echo "\section{Theorems about the type {\tt one}}" >> theorems.tex
+	@printf '\\section{Theorems about the type {\\tt one}}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/one theorems.tex
-	@echo "\section{Theorems about combinators}" >> theorems.tex
+	@printf '\\section{Theorems about combinators}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/combin theorems.tex
-	@echo "\section{Theorems about pairs}" >> theorems.tex
+	@printf '\\section{Theorems about pairs}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/pairs theorems.tex
-	@echo "\section{Theorems about disjoint sums}" >> theorems.tex
+	@printf '\\section{Theorems about disjoint sums}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/sum theorems.tex
-	@echo "\section{Theorems about arithmetic}" >> theorems.tex
+	@printf '\\section{Theorems about arithmetic}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/arith theorems.tex
-	@echo "\section{Theorems about lists}" >> theorems.tex
+	@printf '\\section{Theorems about lists}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/list theorems.tex
-	@echo "\section{Theorems about trees}" >> theorems.tex
+	@printf '\\section{Theorems about trees}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/tree theorems.tex
-	@echo "\section{Theorems used to define types}" >> theorems.tex
+	@printf '\\section{Theorems used to define types}' >> theorems.tex
 	/bin/sh bin/doc-to-tex ${D2TSED} ${Helpd}/THEOREMS/tydefs theorems.tex
 
 reference: 
--- a/contrib/wordn/Manual/Makefile
+++ b/contrib/wordn/Manual/Makefile
@@ -26,27 +26,27 @@
 # ---------------------------------------------------------------------
 clean:
 	rm -f *.dvi *.aux *.toc *.log *.idx *.ilg
-	@echo "\begin{theindex}" > index.tex
-	@echo "\mbox{}" >> index.tex
-	@echo "\end{theindex}" >> index.tex
+	@printf '\\begin{theindex}' > index.tex
+	@printf '\\mbox{}' >> index.tex
+	@printf '\\end{theindex}' >> index.tex
 
 tex:	entries theorems
 	@echo "TeX files made"
 
 entries:
-	@echo "\chapter{ML Functions in the wordn Library}">entries.tex
-	@echo "\label{entries}">>entries.tex
-	@echo "\input{entries-intro}" >> entries.tex
+	@printf '\\chapter{ML Functions in the wordn Library}'>entries.tex
+	@printf '\\label{entries}'>>entries.tex
+	@printf '\\input{entries-intro}' >> entries.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/ENTRIES entries.tex
 
 theorems:
-	@echo "\chapter{Pre-proved Theorems}" > theorems.tex
-	@echo "\input{theorems-intro}" >> theorems.tex
-	@echo "\section{The theory {\tt wordn\_base}}">>theorems.tex
+	@printf '\\chapter{Pre-proved Theorems}' > theorems.tex
+	@printf '\\input{theorems-intro}' >> theorems.tex
+	@printf '\\section{The theory {\\tt wordn\\_base}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/THEOREMS/base theorems.tex
-	@echo "\section{The theory {\tt wordn\_bitops}}">>theorems.tex
+	@printf '\\section{The theory {\\tt wordn\\_bitops}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/THEOREMS/bitops theorems.tex
-	@echo "\section{The theory {\tt wordn\_num}}">>theorems.tex
+	@printf '\\section{The theory {\\tt wordn\\_num}}'>>theorems.tex
 	/bin/sh ${DOCTOTEX} ${DOCTOTEXSED} ${Help}/THEOREMS/num theorems.tex
 
 index: 
