// Copyright (c) Meta Platforms, Inc. and affiliates.

#pragma once
#include <string>

// String literal of chunked version of ppmf_unit_1.csv. Should only be included
// in tests.
const std::string ppmfCsvString =
        R"(RTYPE,GQTYPE,TEN,VACS,HHSIZE,HHT,HHT2,CPLT,UPART,MULTG,THHLDRAGE,THHSPAN,THHRACE,PAOC,TP18,TP60,TP65,TP75,PAC,HHSEX,TENSHORT,HH_STATUS,TABBLKST,TABBLKCOU,TABTRACTCE,TABBLK,TABBLKGRPCE,AIANNHCE,AIANNHFP,AIANNHNS,AIHHTLI,ANRCFP,ANRCNS,AREALAND,AREAWATER,AREAWATERCSTL,AREAWATERGRLK,AREAWATERINLD,AREAWATERTSEA,CBSAFP,CD116FP,CNECTAFP,CONCITFP,CONCITNS,COUNTYFS,COUNTYNS,COUSUBFP,COUSUBFS,COUSUBNS,CSAFP,DIVISIONCE,ESTATEFP,ESTATENS,INTPTLAT,INTPTLON,LWBLKTYP,MEMI,METDIVFP,NECTADIVFP,NECTAFP,NMEMI,PCICBSA,PCINECTA,PLACEFP,PLACEFS,PLACENS,PUMA,REGIONCE,SDELMLEA,SDSECLEA,SDUNILEA,SLDLST,SLDUST,STATENS,SUBMCDFP,SUBMCDNS,TBLKGRPCE,TRIBALSUBCE,TRIBALSUBFP,TRIBALSUBNS,TTRACTCE,UACE,UATYP,UGACE,UR,VTDST,ZCTA5CE
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,1,0,2,3,06,5,5,0,3,1,02,1,1,0,0,0,1,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,4,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,4,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,4,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,4,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,4,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,4,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,3,0,2,3,07,5,5,0,3,1,02,4,0,0,0,0,4,2,2,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,3,3,06,5,5,1,3,2,01,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,1,0,3,3,06,5,5,1,3,2,07,2,1,0,0,0,2,2,1,1,37,025,041304,2027,2,9999,99999,99999999,9,99999,99999999,116377,0,0,0,0,0,16740,08,999,99999,99999999,A,01008540,93380,N,01026472,172,5,99999,99999999,+35.4314174,-080.7374926,L,1,99999,99999,99999,9,Y,N,14100,A,02404117,03200,3,99999,99999,00530,082,036,01027616,99999,99999999,9,999,99999,99999999,999999,19558,U,99999,U,002-08,28027
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,2,1,1,25,013,813206,3004,3,9999,99999,99999999,9,99999,99999999,22346,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0768080,-072.6561350,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000020,01030
2,000,3,0,2,1,02,1,5,0,1,1,01,4,0,0,0,0,4,1,2,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,3,0,2,5,12,5,5,0,1,1,07,4,0,0,0,0,4,1,2,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,1,0,2,5,04,3,2,0,2,1,01,4,0,0,0,0,4,1,1,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,1,0,2,5,04,3,2,0,2,1,01,4,0,0,0,0,4,1,1,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,3,0,5,1,01,1,5,1,2,2,02,2,1,0,0,0,2,1,2,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,3,0,3,1,01,1,5,1,2,2,06,2,1,0,0,0,2,1,2,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,1,0,3,2,04,3,2,1,3,1,01,4,0,0,0,0,4,1,1,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,1,0,4,2,10,5,5,1,3,1,01,3,1,0,0,0,3,1,1,1,25,013,813206,3005,3,9999,99999,99999999,9,99999,99999999,239620,0,0,0,0,0,44140,01,790,99999,99999999,N,00606933,00840,F,00618180,999,1,99999,99999999,+42.0732068,-072.6533511,L,1,99999,99999,78100,1,N,N,00840,A,00618180,00401,1,99999,99999,01800,104,005,00606926,99999,99999999,9,999,99999,99999999,999999,83926,U,99999,U,000022,01030
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3001,3,9999,99999,99999999,9,99999,99999999,4763673,14576,0,0,14576,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3273447,-089.0521266,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3004,3,9999,99999,99999999,9,99999,99999999,43261,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3324832,-089.0466399,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38841
2,000,3,0,4,5,12,5,5,1,1,2,06,4,0,0,0,0,4,1,2,1,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,3,0,2,5,04,3,2,0,4,1,01,4,0,0,0,0,4,1,2,1,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,1,0,5,1,01,1,5,1,4,2,06,2,1,0,0,0,2,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,5,1,01,1,5,1,4,2,06,2,1,0,0,0,2,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,5,1,01,1,5,1,4,2,06,2,1,0,0,0,2,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,3,1,02,1,5,1,4,2,06,4,0,0,0,0,4,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,3,0,3,1,02,1,5,1,6,2,01,4,0,1,0,0,4,1,2,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,3,0,6,1,01,1,5,2,6,2,07,2,1,1,0,0,3,1,2,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,3,0,2,1,02,1,5,0,6,2,07,4,0,1,0,0,4,1,2,1,16,027,021004,1009,1,9999,99999,99999999,9,99999,99999999,61301,0,0,0,0,0,14260,01,999,99999,99999999,A,00399406,92438,S,01936772,147,8,99999,99999999,+43.6273385,-116.6918016,L,1,99999,99999,99999,9,N,N,12250,A,02409956,00500,4,99999,99999,00510,010,010,01779783,99999,99999999,9,999,99999,99999999,999999,60976,U,99999,U,271017,83607
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,3,2,11,5,5,1,4,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,5,1,01,1,5,2,4,1,01,2,1,1,1,1,2,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,6,1,02,1,5,2,5,1,01,4,1,0,0,0,3,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1011,1,9999,99999,99999999,9,99999,99999999,405420,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1336697,-115.9816568,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1011,1,9999,99999,99999999,9,99999,99999999,405420,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1336697,-115.9816568,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1015,1,9999,99999,99999999,9,99999,99999999,125870,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1213925,-115.9799765,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1015,1,9999,99999,99999999,9,99999,99999999,125870,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1213925,-115.9799765,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,16,015,950202,1018,1,9999,99999,99999999,9,99999,99999999,501419,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1240551,-115.9688402,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1020,1,9999,99999,99999999,9,99999,99999999,379143,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1212020,-115.9626925,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1020,1,9999,99999,99999999,9,99999,99999999,379143,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1212020,-115.9626925,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1020,1,9999,99999,99999999,9,99999,99999999,379143,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1212020,-115.9626925,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1020,1,9999,99999,99999999,9,99999,99999999,379143,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1212020,-115.9626925,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,3,0,4,1,01,1,5,1,4,2,07,2,1,0,0,0,2,1,2,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,3,0,6,1,02,1,5,2,4,2,07,4,1,0,0,0,3,1,2,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,2,0,2,5,12,5,5,0,5,1,01,4,0,0,0,0,4,1,1,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,2,0,2,5,12,5,5,0,5,1,01,4,0,0,0,0,4,1,1,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,2,0,2,5,12,5,5,0,5,1,01,4,0,0,0,0,4,1,1,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,3,0,4,2,11,5,5,2,6,1,01,4,1,1,0,0,2,1,2,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,2,0,2,5,12,5,5,0,6,1,01,4,0,1,1,0,4,1,1,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,3,0,2,1,02,1,5,0,6,2,07,4,0,1,1,0,4,1,2,1,04,019,004715,3009,3,9999,99999,99999999,9,99999,99999999,265352,0,0,0,0,0,46060,01,999,99999,99999999,A,00025446,93570,S,01934987,536,8,99999,99999999,+32.4937536,-110.9218649,L,1,99999,99999,99999,9,N,N,11160,S,02407989,01903,4,99999,99999,00680,011,011,01779777,99999,99999999,9,999,99999,99999999,999999,88732,U,99999,U,000024,85739
2,000,3,0,1,4,09,0,0,0,6,2,06,4,0,1,0,0,4,1,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,4,1,02,1,5,2,8,1,04,4,1,1,1,1,2,1,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,4,09,0,0,0,9,1,04,4,0,1,1,1,4,1,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,1,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,2,1,02,1,5,0,2,1,07,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,2,2,04,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,2,3,06,5,5,0,3,2,01,2,1,0,0,0,2,2,2,1,06,037,433505,1007,1,9999,99999,99999999,9,99999,99999999,62434,0,0,0,0,0,31080,32,999,99999,99999999,A,00277283,93510,S,01935356,348,9,99999,99999999,+34.0599812,-118.0412977,L,1,31084,99999,99999,9,N,N,22230,A,02410413,03738,4,26190,12120,99999,049,022,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91733
2,000,3,0,5,3,06,5,5,1,3,2,01,2,1,0,0,0,2,2,2,1,06,037,433505,1007,1,9999,99999,99999999,9,99999,99999999,62434,0,0,0,0,0,31080,32,999,99999,99999999,A,00277283,93510,S,01935356,348,9,99999,99999999,+34.0599812,-118.0412977,L,1,31084,99999,99999,9,N,N,22230,A,02410413,03738,4,26190,12120,99999,049,022,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91733
2,000,3,0,5,3,03,3,4,2,3,2,01,2,1,1,1,0,2,2,2,1,06,037,433505,1007,1,9999,99999,99999999,9,99999,99999999,62434,0,0,0,0,0,31080,32,999,99999,99999999,A,00277283,93510,S,01935356,348,9,99999,99999999,+34.0599812,-118.0412977,L,1,31084,99999,99999,9,N,N,22230,A,02410413,03738,4,26190,12120,99999,049,022,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91733
2,000,1,0,4,3,06,5,5,1,3,2,06,3,1,0,0,0,3,2,1,1,06,037,433505,1007,1,9999,99999,99999999,9,99999,99999999,62434,0,0,0,0,0,31080,32,999,99999,99999999,A,00277283,93510,S,01935356,348,9,99999,99999999,+34.0599812,-118.0412977,L,1,31084,99999,99999,9,N,N,22230,A,02410413,03738,4,26190,12120,99999,049,022,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91733
2,000,2,0,7,1,01,1,5,1,3,2,06,3,1,0,0,0,3,2,1,1,06,037,433505,1007,1,9999,99999,99999999,9,99999,99999999,62434,0,0,0,0,0,31080,32,999,99999,99999999,A,00277283,93510,S,01935356,348,9,99999,99999999,+34.0599812,-118.0412977,L,1,31084,99999,99999,9,N,N,22230,A,02410413,03738,4,26190,12120,99999,049,022,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91733
2,000,3,0,3,1,01,1,5,1,2,2,01,1,1,0,0,0,1,2,2,1,06,019,007300,5025,5,9999,99999,99999999,9,99999,99999999,1290504,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.5218096,-119.6918402,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,2,0,4,1,02,1,5,1,4,1,01,4,0,1,0,0,4,2,1,1,06,019,007300,5025,5,9999,99999,99999999,9,99999,99999999,1290504,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.5218096,-119.6918402,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,06,019,007300,5025,5,9999,99999,99999999,9,99999,99999999,1290504,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.5218096,-119.6918402,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,3,0,4,3,03,3,4,1,2,2,06,1,1,0,0,0,1,2,2,1,06,019,007300,5026,5,9999,99999,99999999,9,99999,99999999,2586491,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.5109275,-119.6919121,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,3,0,3,1,01,2,5,1,3,2,02,2,1,0,0,0,2,2,2,1,06,019,007300,5026,5,9999,99999,99999999,9,99999,99999999,2586491,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.5109275,-119.6919121,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,06,019,007300,5027,5,9999,99999,99999999,9,99999,99999999,2573806,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.4964888,-119.6919940,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,1,0,7,1,01,1,5,1,3,2,01,2,1,0,0,0,2,1,1,1,06,019,007300,5027,5,9999,99999,99999999,9,99999,99999999,2573806,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.4964888,-119.6919940,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,3,0,5,2,10,5,5,2,3,2,07,2,1,1,1,0,2,1,2,1,06,019,007300,5027,5,9999,99999,99999999,9,99999,99999999,2573806,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.4964888,-119.6919940,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,1,0,0,4,1,1,1,06,019,007300,5027,5,9999,99999,99999999,9,99999,99999999,2573806,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.4964888,-119.6919940,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,3,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,2,1,06,019,007300,5027,5,9999,99999,99999999,9,99999,99999999,2573806,0,0,0,0,0,23420,21,999,99999,99999999,A,00277274,92990,S,01935304,260,9,99999,99999999,+36.4964888,-119.6919940,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01901,4,99999,99999,21150,031,012,01779778,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,,93662
2,000,2,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,1,1,12,039,020300,3025,3,9999,99999,99999999,9,99999,99999999,6020,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6264397,-084.6682511,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,2,0,1,6,05,0,0,0,8,1,02,4,0,1,1,1,4,2,1,1,12,039,020300,3025,3,9999,99999,99999999,9,99999,99999999,6020,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6264397,-084.6682511,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,2,0,1,6,05,0,0,0,8,1,02,4,0,1,1,1,4,2,1,1,12,039,020300,3025,3,9999,99999,99999999,9,99999,99999999,6020,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6264397,-084.6682511,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,2,0,1,6,05,0,0,0,9,1,02,4,0,1,1,1,4,2,1,1,12,039,020300,3025,3,9999,99999,99999999,9,99999,99999999,6020,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6264397,-084.6682511,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,2,0,1,6,05,0,0,0,9,1,02,4,0,1,1,1,4,2,1,1,12,039,020300,3025,3,9999,99999,99999999,9,99999,99999999,6020,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6264397,-084.6682511,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,12,039,020300,3025,3,9999,99999,99999999,9,99999,99999999,6020,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6264397,-084.6682511,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,3,0,4,2,03,3,2,1,2,1,02,1,1,0,0,0,1,1,2,1,12,039,020300,3026,3,9999,99999,99999999,9,99999,99999999,7689,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6163505,-084.6683761,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,3,0,4,2,03,3,2,1,3,1,02,1,1,0,0,0,3,1,2,1,12,039,020300,3026,3,9999,99999,99999999,9,99999,99999999,7689,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6163505,-084.6683761,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,3,0,4,2,03,3,2,1,3,1,02,2,1,0,0,0,2,1,2,1,12,039,020300,3026,3,9999,99999,99999999,9,99999,99999999,7689,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6163505,-084.6683761,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,3,0,2,5,04,3,2,0,3,2,06,4,0,0,0,0,4,1,2,1,12,039,020300,3026,3,9999,99999,99999999,9,99999,99999999,7689,0,0,0,0,0,45220,05,999,99999,99999999,A,00306918,92912,S,01935911,999,5,99999,99999999,+30.6163505,-084.6683761,L,1,99999,99999,99999,9,N,N,27650,A,02403762,01398,3,99999,99999,00600,008,003,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,32332
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,17,057,952800,3012,3,9999,99999,99999999,9,99999,99999999,65303,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6957494,-090.0045267,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,2,5,04,3,2,0,4,1,01,4,0,0,0,0,4,1,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,1,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,3,3,06,5,5,1,2,1,01,3,1,0,0,0,3,2,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,1,0,3,5,04,3,2,1,7,1,01,4,0,1,1,0,4,1,1,1,55,083,100600,1046,1,9999,99999,99999999,9,99999,99999999,125800,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0477030,-088.3680793,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,4,0,3,2,11,5,5,1,8,1,01,4,1,1,1,1,2,1,2,1,55,083,100600,1046,1,9999,99999,99999999,9,99999,99999999,125800,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0477030,-088.3680793,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,2,1,1,55,083,100600,1046,1,9999,99999,99999999,9,99999,99999999,125800,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0477030,-088.3680793,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,4,0,3,3,06,5,5,1,2,1,07,2,1,0,0,0,2,2,2,1,55,083,100600,1046,1,9999,99999,99999999,9,99999,99999999,125800,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0477030,-088.3680793,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,4,0,2,3,07,5,5,0,3,1,01,4,0,1,0,0,4,2,2,1,55,083,100600,1046,1,9999,99999,99999999,9,99999,99999999,125800,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0477030,-088.3680793,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,4,0,4,3,07,5,5,2,5,1,01,4,1,0,0,0,2,2,2,1,55,083,100600,1046,1,9999,99999,99999999,9,99999,99999999,125800,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0477030,-088.3680793,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,6,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,5,2,03,3,2,1,3,1,01,3,1,0,0,0,3,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,131,950305,3239,3,9999,99999,99999999,9,99999,99999999,3898978,0,0,0,0,0,18880,01,999,99999,99999999,A,00295727,90819,S,01935744,999,5,99999,99999999,+30.6971999,-086.2001476,L,1,99999,99999,99999,9,9,9,99999,9,99999999,05998,3,99999,99999,01980,005,002,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000330,32435
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,2,5,12,5,5,0,4,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,2,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,3,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,4,3,06,5,5,1,3,1,01,3,1,0,0,0,3,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,7,3,06,5,5,2,3,1,04,2,1,1,1,0,2,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,1,6,05,0,0,0,3,1,07,4,0,0,0,0,4,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,2,1,02,1,5,0,7,1,04,4,0,1,1,0,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,1,0,2,1,02,1,5,0,7,1,04,4,0,1,1,0,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,2,1,02,1,5,0,7,1,04,4,0,1,1,0,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,2,1,02,1,5,0,7,1,04,4,0,1,1,0,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,4,1,02,1,5,1,7,1,04,4,0,1,1,0,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,1,4,09,0,0,0,7,1,04,4,0,1,1,0,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,2,0,2,1,02,1,5,0,8,1,04,4,0,1,1,1,4,1,1,1,53,033,024703,3002,3,9999,99999,99999999,9,99999,99999999,421582,0,0,0,0,0,42660,09,999,99999,99999999,A,01531933,92931,S,01939496,500,9,99999,99999999,+47.5377269,-122.1819443,L,1,42644,99999,99999,9,N,N,48645,A,02411243,23305,4,99999,99999,07230,041,041,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,48645,U,003227,98056
2,000,1,0,3,1,01,1,5,1,4,1,02,2,1,0,0,0,2,1,1,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,3,0,1,4,09,0,0,0,4,1,03,4,0,0,0,0,4,1,2,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,3,0,1,4,09,0,0,0,4,1,03,4,0,0,0,0,4,1,2,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,3,0,5,1,01,1,5,1,4,2,01,2,1,0,0,0,2,1,2,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,1,0,2,5,04,4,1,0,5,1,01,4,0,0,0,0,4,1,1,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,1,0,2,1,02,2,5,0,5,1,01,4,0,1,0,0,4,1,1,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,3,0,6,1,02,1,5,2,5,1,04,4,1,0,0,0,1,1,2,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,3,0,2,2,10,5,5,0,5,1,07,2,1,0,0,0,2,1,2,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,13,089,020200,2001,2,9999,99999,99999999,9,99999,99999999,166692,0,0,0,0,0,12060,05,999,99999,99999999,A,01687424,90150,S,01936090,122,5,99999,99999999,+33.7766755,-084.3457370,L,1,99999,99999,99999,9,Y,N,04000,A,02403126,01504,3,99999,99999,00120,089,042,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,0000LE,30306
2,000,2,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,1,1,45,063,021031,2005,2,9999,99999,99999999,9,99999,99999999,105288,0,0,0,0,0,17900,02,999,99999,99999999,A,01244251,91937,S,01938330,192,5,99999,99999999,+33.9971050,-081.2023035,L,1,99999,99999,99999,9,N,N,41335,A,02406014,01301,3,99999,99999,02700,069,018,01779799,99999,99999999,9,999,99999,99999999,999999,18964,U,99999,U,000033,29072
2,000,1,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,45,063,021031,2005,2,9999,99999,99999999,9,99999,99999999,105288,0,0,0,0,0,17900,02,999,99999,99999999,A,01244251,91937,S,01938330,192,5,99999,99999999,+33.9971050,-081.2023035,L,1,99999,99999,99999,9,N,N,41335,A,02406014,01301,3,99999,99999,02700,069,018,01779799,99999,99999999,9,999,99999,99999999,999999,18964,U,99999,U,000033,29072
2,000,1,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,45,063,021031,2005,2,9999,99999,99999999,9,99999,99999999,105288,0,0,0,0,0,17900,02,999,99999,99999999,A,01244251,91937,S,01938330,192,5,99999,99999999,+33.9971050,-081.2023035,L,1,99999,99999,99999,9,N,N,41335,A,02406014,01301,3,99999,99999,02700,069,018,01779799,99999,99999999,9,999,99999,99999999,999999,18964,U,99999,U,000033,29072
2,000,2,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,45,063,021031,2005,2,9999,99999,99999999,9,99999,99999999,105288,0,0,0,0,0,17900,02,999,99999,99999999,A,01244251,91937,S,01938330,192,5,99999,99999999,+33.9971050,-081.2023035,L,1,99999,99999,99999,9,N,N,41335,A,02406014,01301,3,99999,99999,02700,069,018,01779799,99999,99999999,9,999,99999,99999999,999999,18964,U,99999,U,000033,29072
2,000,2,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,45,063,021031,2005,2,9999,99999,99999999,9,99999,99999999,105288,0,0,0,0,0,17900,02,999,99999,99999999,A,01244251,91937,S,01938330,192,5,99999,99999999,+33.9971050,-081.2023035,L,1,99999,99999,99999,9,N,N,41335,A,02406014,01301,3,99999,99999,02700,069,018,01779799,99999,99999999,9,999,99999,99999999,999999,18964,U,99999,U,000033,29072
2,000,2,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,45,063,021031,2005,2,9999,99999,99999999,9,99999,99999999,105288,0,0,0,0,0,17900,02,999,99999,99999999,A,01244251,91937,S,01938330,192,5,99999,99999999,+33.9971050,-081.2023035,L,1,99999,99999,99999,9,N,N,41335,A,02406014,01301,3,99999,99999,02700,069,018,01779799,99999,99999999,9,999,99999,99999999,999999,18964,U,99999,U,000033,29072
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,20,173,010600,2023,2,9999,99999,99999999,9,99999,99999999,2218200,0,0,0,0,0,48620,04,999,99999,99999999,A,00485049,00425,A,00473997,556,4,99999,99999999,+37.5984577,-097.6163324,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01501,2,99999,99999,06540,093,026,00481813,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,502120,67052
2,000,1,0,5,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,20,173,010600,2023,2,9999,99999,99999999,9,99999,99999999,2218200,0,0,0,0,0,48620,04,999,99999,99999999,A,00485049,00425,A,00473997,556,4,99999,99999999,+37.5984577,-097.6163324,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01501,2,99999,99999,06540,093,026,00481813,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,502120,67052
2,000,2,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,20,173,010600,2023,2,9999,99999,99999999,9,99999,99999999,2218200,0,0,0,0,0,48620,04,999,99999,99999999,A,00485049,00425,A,00473997,556,4,99999,99999999,+37.5984577,-097.6163324,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01501,2,99999,99999,06540,093,026,00481813,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,502120,67052
2,000,1,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,20,173,010600,2023,2,9999,99999,99999999,9,99999,99999999,2218200,0,0,0,0,0,48620,04,999,99999,99999999,A,00485049,00425,A,00473997,556,4,99999,99999999,+37.5984577,-097.6163324,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01501,2,99999,99999,06540,093,026,00481813,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,502120,67052
2,000,1,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,20,173,010600,2023,2,9999,99999,99999999,9,99999,99999999,2218200,0,0,0,0,0,48620,04,999,99999,99999999,A,00485049,00425,A,00473997,556,4,99999,99999999,+37.5984577,-097.6163324,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01501,2,99999,99999,06540,093,026,00481813,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,502120,67052
2,000,1,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,20,173,010600,2023,2,9999,99999,99999999,9,99999,99999999,2218200,0,0,0,0,0,48620,04,999,99999,99999999,A,00485049,00425,A,00473997,556,4,99999,99999999,+37.5984577,-097.6163324,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01501,2,99999,99999,06540,093,026,00481813,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,502120,67052
2,000,3,0,3,1,02,1,5,1,6,1,01,4,0,1,0,0,4,2,2,1,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,3,0,4,1,02,1,5,1,6,1,01,4,1,1,1,0,1,2,2,1,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,3,0,2,3,07,5,5,0,7,1,01,4,0,1,1,0,4,2,2,1,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,3,0,4,1,02,1,5,1,8,1,01,4,0,1,1,1,4,2,2,1,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,32,019,960205,2050,2,9999,99999,99999999,9,99999,99999999,31636,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4056454,-119.2206809,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,2,0,2,5,04,3,2,0,2,1,01,4,0,0,0,0,4,1,1,1,32,019,960205,2051,2,9999,99999,99999999,9,99999,99999999,28726,0,0,0,0,0,22280,02,999,99999,99999999,A,00858645,94777,S,01937471,456,8,99999,99999999,+39.4055591,-119.2193476,L,2,99999,99999,99999,9,N,N,67200,S,02408739,00300,4,99999,99999,00300,038,017,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000024,89429
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,1,1,1,39,083,007500,3006,3,9999,99999,99999999,9,99999,99999999,244752,0,0,0,0,0,34540,07,999,99999,99999999,A,01074054,53102,F,01086410,198,3,99999,99999999,+40.3873623,-082.4563287,L,2,99999,99999,99999,9,Y,N,53102,A,01086410,02600,2,99999,99999,10012,068,019,01085497,99999,99999999,9,999,99999,99999999,999999,60463,U,99999,U,042AAA,43050
2,000,2,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,2,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,2,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,1,6,05,0,0,0,7,1,07,4,0,1,1,0,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,3,1,02,1,5,1,8,1,02,4,0,1,1,1,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,3,1,02,1,5,1,8,1,02,4,0,1,1,1,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,3,1,02,1,5,1,8,1,02,4,0,1,1,1,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,3,1,02,1,5,1,8,1,02,4,0,1,1,1,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,3,1,02,1,5,1,8,1,02,4,0,1,1,1,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,1,0,1,6,05,0,0,0,8,1,02,4,0,1,1,1,4,2,1,1,24,033,800521,3001,3,9999,99999,99999999,9,99999,99999999,125639,0,0,0,0,0,47900,04,999,99999,99999999,A,01714670,90616,N,01929677,548,5,99999,99999999,+38.8994253,-076.7836760,L,1,47894,99999,99999,9,N,N,43900,S,02390000,01105,3,99999,99999,00510,23B,023,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,07-011,20774
2,000,2,0,2,1,02,1,5,0,7,1,03,4,0,1,1,1,4,1,1,1,01,043,964400,2072,2,9999,99999,99999999,9,99999,99999999,89204,0,0,0,0,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2620727,-086.9881429,L,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,1,0,3,5,04,3,2,1,2,1,01,4,1,0,0,0,1,1,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,1,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,2,0,2,1,02,1,5,0,5,1,03,4,0,0,0,0,4,1,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,2,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,1,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,1,0,2,1,02,1,5,0,4,1,07,4,0,1,1,0,4,2,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,01,043,964400,2074,2,9999,99999,99999999,9,99999,99999999,593687,3582,0,0,3582,0,18980,04,999,99999,99999999,A,00161547,93330,S,00165737,142,6,99999,99999999,+34.2555853,-086.9858541,B,2,99999,99999,99999,9,N,N,81528,A,02406865,01000,3,99999,99999,01020,009,004,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000171,35179
2,000,3,0,6,3,06,5,5,1,3,2,07,3,1,0,0,0,3,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,3,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,2,1,36,047,038800,2004,2,9999,99999,99999999,9,99999,99999999,18845,0,0,0,0,0,35620,11,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.5918605,-073.9681103,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04315,1,99999,99999,20580,045,023,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000401,11223
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,113,011105,2001,2,9999,99999,99999999,9,99999,99999999,246501,0,0,0,0,0,19100,30,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.6498659,-096.8262466,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02316,3,99999,99999,16230,111,023,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,003066,75232
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,36,065,025400,1012,1,9999,99999,99999999,9,99999,99999999,2862898,145263,0,0,145263,0,46540,22,999,99999,99999999,A,00974131,50309,A,00979264,999,2,99999,99999999,+43.0630750,-075.2348401,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00402,1,99999,99999,20370,101,047,01779796,99999,99999999,9,999,99999,99999999,999999,89785,U,99999,U,000052,13413
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,157,020300,2024,2,9999,99999,99999999,9,99999,99999999,135831,0,0,0,0,0,35420,07,999,99999,99999999,A,01074090,42182,A,01087058,184,3,99999,99999999,+40.6209645,-081.4316544,L,2,99999,99999,99999,9,N,N,85228,S,02804701,02900,2,99999,99999,05030,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,079ACZ,44612
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,1,1,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,1,0,4,2,1,1,24,033,806100,1007,1,9999,99999,99999999,9,99999,99999999,17385,0,0,0,0,0,47900,05,999,99999,99999999,A,01714670,91440,N,01929500,548,5,99999,99999999,+38.9613701,-076.9496697,L,1,47894,99999,99999,9,N,N,41250,A,02390603,01103,3,99999,99999,00510,022,022,01714934,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,16-003,20782
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,013,930800,1080,1,9999,99999,99999999,9,99999,99999999,5320510,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3044015,-076.7112777,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,013,930800,1080,1,9999,99999,99999999,9,99999,99999999,5320510,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3044015,-076.7112777,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,1,4,09,0,0,0,7,1,02,4,0,1,1,0,4,1,1,1,37,013,930800,1081,1,9999,99999,99999999,9,99999,99999999,1739213,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3060165,-076.7289962,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,1,4,09,0,0,0,7,1,02,4,0,1,1,0,4,1,1,1,37,013,930800,1081,1,9999,99999,99999999,9,99999,99999999,1739213,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3060165,-076.7289962,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,1,4,09,0,0,0,7,1,02,4,0,1,1,0,4,1,1,1,37,013,930800,1081,1,9999,99999,99999999,9,99999,99999999,1739213,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3060165,-076.7289962,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,1,4,09,0,0,0,7,1,02,4,0,1,1,0,4,1,1,1,37,013,930800,1081,1,9999,99999,99999999,9,99999,99999999,1739213,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3060165,-076.7289962,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,1,4,09,0,0,0,7,1,02,4,0,1,1,0,4,1,1,1,37,013,930800,1081,1,9999,99999,99999999,9,99999,99999999,1739213,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3060165,-076.7289962,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,3,1,02,1,5,1,6,1,02,4,0,1,0,0,4,1,1,1,37,013,930800,1082,1,9999,99999,99999999,9,99999,99999999,2032003,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3070985,-076.7390066,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,2,1,02,1,5,0,7,1,02,4,0,1,1,0,4,1,1,1,37,013,930800,1082,1,9999,99999,99999999,9,99999,99999999,2032003,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3070985,-076.7390066,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,1,1,1,37,013,930800,1082,1,9999,99999,99999999,9,99999,99999999,2032003,0,0,0,0,0,47820,03,999,99999,99999999,A,01026333,92664,N,01026410,272,5,99999,99999999,+35.3070985,-076.7390066,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00330,079,003,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0AUROR,27806
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,3,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,2,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,1,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,3,1,02,1,5,1,6,1,01,4,0,1,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,1,0,4,1,02,1,5,1,6,1,01,4,0,1,0,0,4,1,1,1,08,059,009848,3000,3,9999,99999,99999999,9,99999,99999999,2095956,0,0,0,0,0,19740,02,999,99999,99999999,A,00198145,90589,S,01935422,216,8,99999,99999999,+39.6459439,-105.3485529,L,1,99999,99999,99999,9,N,N,25390,S,02408097,00401,4,99999,99999,04800,025,016,01779779,99999,99999999,9,999,99999,99999999,999999,28441,U,99999,U,059047,80439
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,39,123,050301,3025,3,9999,99999,99999999,9,99999,99999999,926992,0,0,0,0,0,45780,09,999,99999,99999999,A,01074074,20058,A,01086760,534,3,99999,99999999,+41.5335619,-082.7889764,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,2,99999,99999,04893,089,002,01085497,99999,99999999,9,999,99999,99999999,999999,78774,U,99999,U,062ABW,43440
2,000,3,0,2,5,12,5,5,0,3,2,06,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,5,1,01,1,5,1,3,2,07,3,1,0,0,0,3,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,1,4,09,0,0,0,3,2,07,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,3,2,11,5,5,1,4,1,01,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,2,2,11,5,5,0,4,1,02,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,2,2,11,5,5,0,4,1,02,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,3,0,2,2,11,5,5,0,4,1,02,4,0,0,0,0,4,1,2,1,36,119,000202,1002,1,9999,99999,99999999,9,99999,99999999,9543,0,0,0,0,0,35620,16,999,99999,99999999,A,00974157,84000,F,00979660,408,2,99999,99999999,+40.9227763,-073.9022684,L,1,35614,99999,99999,9,N,N,84000,A,00979660,03112,1,99999,99999,31920,089,035,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000661,10705
2,000,2,0,2,1,02,2,5,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,2,1,02,2,5,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,2,7,04,3,4,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722100,1018,1,9999,99999,99999999,9,99999,99999999,18392,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+40.0263613,-074.1936218,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035049,08755
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,6,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,2,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,1,0,3,1,01,1,5,1,4,1,01,1,1,0,0,0,1,1,1,1,54,011,010702,2006,2,9999,99999,99999999,9,99999,99999999,7810330,1261,0,0,1261,0,26580,03,999,99999,99999999,A,01550012,90882,N,01928241,170,5,99999,99999999,+38.4663057,-082.2010843,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00800,3,99999,99999,00180,016,005,01779805,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000058,25545
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,1,0,3,1,01,1,5,1,2,1,04,1,1,0,0,0,1,2,1,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,3,0,3,1,01,1,5,1,2,1,06,2,1,0,0,0,2,2,2,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,1,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,1,0,4,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,1,0,5,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,1,0,5,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,1,0,5,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,41,047,002001,2017,2,9999,99999,99999999,9,99999,99999999,235690,0,0,0,0,0,41420,05,999,99999,99999999,A,01135859,92737,S,01938109,440,9,99999,99999999,+44.8715451,-123.0202800,L,1,99999,99999,99999,9,Y,N,64900,A,02411764,04704,4,99999,99999,10820,019,010,01155107,99999,99999999,9,999,99999,99999999,999999,78229,U,64902,U,,97306
2,000,4,0,3,3,06,5,5,1,7,1,01,2,1,1,1,0,2,2,2,1,32,027,960100,1029,1,9999,99999,99999999,9,99999,99999999,84277,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8334372,-117.7547480,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,4,0,5,1,01,1,5,1,2,2,06,3,1,0,0,0,3,1,2,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,3,1,02,1,5,1,4,2,06,4,1,0,0,0,1,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,3,1,02,1,5,1,6,2,06,4,1,1,0,0,2,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,3,1,02,1,5,1,6,2,06,4,0,1,0,0,4,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,2,0,2,1,02,1,5,0,7,2,06,4,0,1,1,0,4,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,2,0,2,1,02,1,5,0,7,2,06,4,0,1,1,0,4,1,1,1,32,027,960100,1030,1,9999,99999,99999999,9,99999,99999999,81770,0,0,0,0,0,99999,02,999,99999,99999999,A,00858646,94448,S,01937446,999,8,99999,99999999,+40.8342914,-117.7599516,L,9,99999,99999,99999,9,N,N,30220,S,02583931,00200,4,99999,99999,00420,032,014,01779793,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000006,89445
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,2,0,3,2,04,3,2,1,6,1,01,4,0,1,1,1,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,3,0,1,4,09,0,0,0,6,1,07,4,0,1,0,0,4,1,2,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,04,025,001904,1090,1,9999,99999,99999999,9,99999,99999999,1900802,0,0,0,0,0,39150,04,999,99999,99999999,A,00042809,92193,S,01934959,999,8,99999,99999999,+34.6837594,-112.3330632,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02502,4,99999,99999,03870,001,001,01779777,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000114,86315
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,2,3,06,5,5,0,2,1,01,2,1,0,0,0,2,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,5,3,06,5,5,1,2,1,01,2,1,0,0,0,2,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,4,7,08,5,5,1,2,2,07,4,1,0,0,0,1,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,3,0,4,7,08,5,5,1,2,2,07,4,0,0,0,0,4,2,2,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,41,029,001801,3014,3,9999,99999,99999999,9,99999,99999999,69669,0,0,0,0,0,32780,02,999,99999,99999999,A,01135853,90119,S,01937955,366,9,99999,99999999,+42.1773021,-122.6729524,L,1,99999,99999,99999,9,N,N,03050,A,02409740,02902,4,99999,99999,01560,005,003,01155107,99999,99999999,9,999,99999,99999999,999999,55981,U,03050,U,,97520
2,000,1,0,4,3,03,3,4,1,3,1,01,2,1,0,0,0,2,2,1,1,08,077,001102,4059,4,9999,99999,99999999,9,99999,99999999,60842,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0945363,-108.4957883,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,1,0,3,1,01,1,5,1,3,2,07,2,1,0,0,0,2,2,1,1,08,077,001102,4059,4,9999,99999,99999999,9,99999,99999999,60842,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0945363,-108.4957883,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,08,077,001102,4059,4,9999,99999,99999999,9,99999,99999999,60842,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0945363,-108.4957883,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,08,077,001102,4059,4,9999,99999,99999999,9,99999,99999999,60842,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0945363,-108.4957883,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,1,0,4,3,07,5,5,2,8,1,01,4,0,1,1,1,4,2,1,1,08,077,001102,4059,4,9999,99999,99999999,9,99999,99999999,60842,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0945363,-108.4957883,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,08,077,001102,4059,4,9999,99999,99999999,9,99999,99999999,60842,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0945363,-108.4957883,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,1,0,4,1,01,1,5,1,3,2,01,2,1,0,0,0,2,1,1,1,08,077,001102,4060,4,9999,99999,99999999,9,99999,99999999,30065,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0934959,-108.4948880,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,1,0,5,1,01,1,5,1,3,2,03,2,1,0,0,0,2,1,1,1,08,077,001102,4060,4,9999,99999,99999999,9,99999,99999999,30065,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0934959,-108.4948880,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,1,0,5,1,01,1,5,1,4,2,03,2,1,0,0,0,2,1,1,1,08,077,001102,4060,4,9999,99999,99999999,9,99999,99999999,30065,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0934959,-108.4948880,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,1,0,4,1,02,1,5,1,4,2,07,4,0,0,0,0,4,1,1,1,08,077,001102,4060,4,9999,99999,99999999,9,99999,99999999,30065,0,0,0,0,0,24300,03,999,99999,99999999,A,00198154,91596,S,01935477,999,8,99999,99999999,+39.0934959,-108.4948880,L,1,99999,99999,99999,9,N,N,28800,S,02408269,02501,4,99999,99999,04350,055,007,01779779,99999,99999999,9,999,99999,99999999,999999,34273,U,99999,U,077051,81504
2,000,3,0,2,1,02,1,5,0,6,2,06,4,0,1,0,0,4,1,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,3,2,11,5,5,1,7,2,07,4,0,1,1,1,4,1,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,3,2,11,5,5,1,8,1,01,4,0,1,1,1,4,1,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,1,4,09,0,0,0,8,1,04,4,0,1,1,1,4,1,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,3,3,06,5,5,1,2,1,01,2,1,0,0,0,2,2,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,3,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,2,2,1,12,086,006205,4002,4,9999,99999,99999999,9,99999,99999999,15218,0,0,0,0,0,33100,27,999,99999,99999999,A,00295755,92158,S,01935851,370,5,99999,99999999,+25.7624636,-080.2599269,L,1,33124,99999,99999,9,Y,N,14250,A,02404126,08616,3,99999,99999,00390,112,037,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000633,33134
2,000,1,0,4,1,01,1,5,2,3,1,02,2,1,0,0,0,2,1,1,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,1,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,1,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,3,0,6,2,11,5,5,2,7,1,01,4,1,1,1,0,3,1,2,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,3,0,1,4,09,0,0,0,7,1,02,4,0,1,1,0,4,1,2,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,3,0,2,3,06,5,5,0,2,1,01,1,1,0,0,0,1,2,2,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,3,0,3,3,06,5,5,1,2,1,01,3,1,0,0,0,3,2,2,1,28,009,950200,2017,2,9999,99999,99999999,9,99999,99999999,133548,0,0,0,0,0,99999,01,999,99999,99999999,A,00695729,92997,N,00711783,999,6,99999,99999999,+34.6213034,-089.1863168,L,9,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,00600,013,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000105,38633
2,000,2,0,5,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,3,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,2,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,3,0,6,1,02,1,5,1,5,1,01,4,1,0,0,0,2,1,2,1,42,027,010802,2008,2,9999,99999,99999999,9,99999,99999999,27278625,0,0,0,0,0,44300,12,999,99999,99999999,A,01214720,31960,A,01216125,524,2,99999,99999999,+40.9275242,-077.3782929,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01200,1,99999,99999,18810,076,034,01779798,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000250,16820
2,000,3,0,2,7,08,5,5,0,4,1,02,4,0,0,0,0,4,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,2,7,08,5,5,0,4,1,02,4,0,0,0,0,4,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,2,7,08,5,5,0,4,1,02,4,0,0,0,0,4,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,3,3,07,5,5,2,5,1,02,4,1,0,0,0,1,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,3,3,07,5,5,2,6,1,02,4,1,1,0,0,1,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,3,3,07,5,5,2,6,1,02,4,1,1,0,0,1,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,3,3,07,5,5,2,6,1,02,4,1,1,0,0,2,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,2,3,07,5,5,0,7,1,02,4,0,1,1,0,4,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,2,3,07,5,5,0,7,1,02,4,0,1,1,0,4,2,2,1,26,163,554100,2012,2,9999,99999,99999999,9,99999,99999999,35522,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4407995,-083.2931683,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,26,163,554100,2013,2,9999,99999,99999999,9,99999,99999999,31068,0,0,0,0,0,19820,13,999,99999,99999999,A,01623022,67625,A,01626960,220,3,99999,99999999,+42.4364149,-083.2888729,L,1,19804,99999,99999,9,9,9,99999,9,99999999,03202,2,99999,99999,29460,010,005,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163822,48240
2,000,1,0,4,1,01,1,5,1,3,1,03,2,1,0,0,0,2,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,3,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,2,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,1,0,4,1,01,1,5,1,4,1,03,2,1,0,0,0,2,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,3,0,2,1,02,1,5,0,4,1,07,4,0,0,0,0,4,2,2,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,13,063,040424,2011,2,9999,99999,99999999,9,99999,99999999,331983,0,0,0,0,0,12060,13,999,99999,99999999,A,01672399,91200,S,01936270,122,5,99999,99999999,+33.5551705,-084.3362528,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02301,3,99999,99999,01230,075,044,01705317,99999,99999999,9,999,99999,99999999,999999,03817,U,99999,U,00JB18,30260
2,000,1,0,4,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,1,1,12,101,031706,2014,2,9999,99999,99999999,9,99999,99999999,69514,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2106165,-082.6447602,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,4,3,06,5,5,1,5,1,01,2,1,0,0,0,2,2,1,1,12,101,031706,2014,2,9999,99999,99999999,9,99999,99999999,69514,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2106165,-082.6447602,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,12,101,031706,2014,2,9999,99999,99999999,9,99999,99999999,69514,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2106165,-082.6447602,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,4,1,02,1,5,2,5,1,01,4,0,1,1,1,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,1,0,4,1,02,1,5,2,5,1,01,4,0,1,1,1,4,1,1,1,12,101,031706,2015,2,9999,99999,99999999,9,99999,99999999,18476,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,92327,S,01935864,999,5,99999,99999999,+28.2139326,-082.6467860,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10102,3,99999,99999,01530,037,010,00294478,99999,99999999,9,999,99999,99999999,999999,86599,U,99999,U,000153,34655
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,2,7,08,5,5,0,6,1,01,4,0,1,0,0,4,2,2,1,06,085,506801,1000,1,9999,99999,99999999,9,99999,99999999,260119,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2406037,-121.9652256,L,1,99999,99999,99999,9,N,N,44112,A,02412917,08507,4,22830,22800,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95032
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,1,0,3,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,3,0,3,3,06,5,5,1,4,1,01,2,1,1,1,0,2,2,2,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,2,0,1,6,05,0,0,0,5,1,01,4,0,0,0,0,4,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,2,0,1,6,05,0,0,0,5,1,01,4,0,0,0,0,4,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,2,0,1,6,05,0,0,0,5,1,01,4,0,0,0,0,4,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,1,0,3,3,07,5,5,1,5,1,01,4,0,1,1,1,4,2,1,1,39,075,976302,2046,2,9999,99999,99999999,9,99999,99999999,1370966,1352,0,0,1352,0,99999,07,999,99999,99999999,A,01074050,80626,A,01086339,999,3,99999,99999999,+40.5394646,-081.7103472,B,9,99999,99999,99999,9,N,N,80612,S,02628984,01500,2,99999,99999,04768,098,031,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,038AAX,44687
2,000,2,0,3,3,07,5,5,1,7,1,01,4,0,1,1,0,4,2,1,1,26,089,970601,1019,1,9999,99999,99999999,9,99999,99999999,265520,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8317908,-085.7191891,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,2,0,3,1,02,1,5,1,7,1,07,4,0,1,1,0,4,2,1,1,26,089,970601,1019,1,9999,99999,99999999,9,99999,99999999,265520,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8317908,-085.7191891,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,26,089,970601,1019,1,9999,99999,99999999,9,99999,99999999,265520,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8317908,-085.7191891,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,2,0,3,1,02,1,5,1,8,1,07,4,0,1,1,1,4,2,1,1,26,089,970601,1019,1,9999,99999,99999999,9,99999,99999999,265520,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8317908,-085.7191891,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,1,0,2,5,04,3,2,0,1,1,01,4,0,0,0,0,4,1,1,1,26,089,970601,1020,1,9999,99999,99999999,9,99999,99999999,1947340,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8248762,-085.7227904,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,1,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,1,1,26,089,970601,1020,1,9999,99999,99999999,9,99999,99999999,1947340,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8248762,-085.7227904,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,1,0,1,4,09,0,0,0,1,1,01,4,1,0,0,0,4,1,1,1,26,089,970601,1020,1,9999,99999,99999999,9,99999,99999999,1947340,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8248762,-085.7227904,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,3,0,3,2,10,5,5,1,2,1,04,1,1,0,0,0,1,1,2,1,26,089,970601,1020,1,9999,99999,99999999,9,99999,99999999,1947340,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8248762,-085.7227904,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,26,089,970601,1020,1,9999,99999,99999999,9,99999,99999999,1947340,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8248762,-085.7227904,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,1,0,5,2,10,5,5,1,4,1,01,3,1,0,0,0,3,1,1,1,26,089,970601,1020,1,9999,99999,99999999,9,99999,99999999,1947340,0,0,0,0,0,45900,01,999,99999,99999999,A,01622987,74500,A,01627089,999,3,99999,99999999,+44.8248762,-085.7227904,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,2,99999,99999,33870,101,035,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,089011,49684
2,000,3,0,2,3,06,5,5,0,2,2,02,2,1,0,0,0,2,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,3,03,3,4,1,2,2,06,1,1,0,0,0,1,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,1,0,3,1,01,1,5,1,3,1,02,2,1,0,0,0,2,2,1,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,1,0,4,3,03,3,4,1,3,1,02,2,1,0,0,0,2,2,1,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,1,01,2,5,1,3,1,02,3,1,0,0,0,3,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,3,03,3,4,1,3,1,02,2,1,0,0,0,2,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,3,06,5,5,1,3,1,02,3,1,0,0,0,3,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,3,06,5,5,1,3,1,02,3,1,0,0,0,3,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,3,06,5,5,1,3,1,02,3,1,0,0,0,3,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,3,0,4,3,06,5,5,1,3,1,02,3,1,0,0,0,3,2,2,1,36,005,038200,1000,1,9999,99999,99999999,9,99999,99999999,16431,0,0,0,0,0,35620,16,999,99999,99999999,C,00974101,08510,G,00978756,408,2,99999,99999999,+40.8775181,-073.8550843,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04212,1,99999,99999,20580,083,036,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000598,10469
2,000,1,0,5,3,07,5,5,2,5,1,02,4,1,0,0,0,2,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,1,6,05,0,0,0,7,1,04,4,0,1,1,0,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,2,1,02,2,5,0,8,1,01,4,0,1,1,1,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,6,3,07,5,5,2,8,1,02,4,1,1,1,1,3,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,2,0,2,3,07,5,5,0,8,1,02,4,0,1,1,1,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,2,0,2,3,07,5,5,0,8,1,02,4,0,1,1,1,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,1,6,05,0,0,0,9,1,02,4,0,1,1,1,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,1,6,05,0,0,0,9,1,02,4,0,1,1,1,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,1,0,1,6,05,0,0,0,9,1,02,4,0,1,1,1,4,2,1,1,11,001,009301,2021,2,9999,99999,99999999,9,99999,99999999,17099,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9280489,-076.9915387,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00102,3,99999,99999,00030,999,005,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-073,20017
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,36,065,024302,1041,1,9999,99999,99999999,9,99999,99999999,1123361,20401,0,0,20401,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3090594,-075.4805524,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000034,13363
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,36,065,024302,1041,1,9999,99999,99999999,9,99999,99999999,1123361,20401,0,0,20401,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3090594,-075.4805524,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000034,13363
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,36,065,024302,1041,1,9999,99999,99999999,9,99999,99999999,1123361,20401,0,0,20401,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3090594,-075.4805524,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000034,13363
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,36,065,024302,1041,1,9999,99999,99999999,9,99999,99999999,1123361,20401,0,0,20401,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3090594,-075.4805524,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000034,13363
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,36,065,024302,1041,1,9999,99999,99999999,9,99999,99999999,1123361,20401,0,0,20401,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3090594,-075.4805524,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000034,13363
2,000,1,0,2,2,10,5,5,0,3,1,01,2,1,0,0,0,2,1,1,1,36,065,024302,1042,1,9999,99999,99999999,9,99999,99999999,13956,0,0,0,0,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3059519,-075.4747685,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,76231,U,99999,U,000034,13363
2,000,1,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,36,065,024302,1042,1,9999,99999,99999999,9,99999,99999999,13956,0,0,0,0,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3059519,-075.4747685,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,76231,U,99999,U,000034,13363
2,000,1,0,2,2,10,5,5,0,5,1,01,2,1,0,0,0,2,1,1,1,36,065,024302,1042,1,9999,99999,99999999,9,99999,99999999,13956,0,0,0,0,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3059519,-075.4747685,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,76231,U,99999,U,000034,13363
2,000,1,0,7,1,01,1,5,2,5,1,01,2,1,1,1,1,3,1,1,1,36,065,024302,1042,1,9999,99999,99999999,9,99999,99999999,13956,0,0,0,0,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3059519,-075.4747685,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,76231,U,99999,U,000034,13363
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,36,065,024302,1042,1,9999,99999,99999999,9,99999,99999999,13956,0,0,0,0,0,46540,22,999,99999,99999999,A,00974131,41762,A,00979137,999,2,99999,99999999,+43.3059519,-075.4747685,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00401,1,99999,99999,24900,118,047,01779796,99999,99999999,9,999,99999,99999999,999999,76231,U,99999,U,000034,13363
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,53,053,073501,2001,2,9999,99999,99999999,9,99999,99999999,708420,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2396279,-122.2867508,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,53,053,073501,2001,2,9999,99999,99999999,9,99999,99999999,708420,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2396279,-122.2867508,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,53,053,073501,2001,2,9999,99999,99999999,9,99999,99999999,708420,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2396279,-122.2867508,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,53,053,073501,2001,2,9999,99999,99999999,9,99999,99999999,708420,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2396279,-122.2867508,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,53,053,073501,2001,2,9999,99999,99999999,9,99999,99999999,708420,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2396279,-122.2867508,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,1,0,4,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,53,053,073501,2002,2,9999,99999,99999999,9,99999,99999999,75648,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2374651,-122.2811504,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,1,0,4,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,53,053,073501,2002,2,9999,99999,99999999,9,99999,99999999,75648,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2374651,-122.2811504,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,1,0,4,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,53,053,073501,2002,2,9999,99999,99999999,9,99999,99999999,75648,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2374651,-122.2811504,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,2,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,1,1,1,53,053,073501,2002,2,9999,99999,99999999,9,99999,99999999,75648,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2374651,-122.2811504,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,1,0,4,1,01,1,5,1,3,1,01,1,1,0,0,0,1,1,1,1,53,053,073501,2002,2,9999,99999,99999999,9,99999,99999999,75648,0,0,0,0,0,42660,10,999,99999,99999999,A,01529159,92672,S,01939605,500,9,99999,99999999,+47.2374651,-122.2811504,L,1,45104,99999,99999,9,N,N,20645,A,02410400,25303,4,99999,99999,06960,031,031,01779804,99999,99999999,9,999,99999,99999999,999999,80389,U,20645,U,031803,98372
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,1,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,423,002013,1035,1,9999,99999,99999999,9,99999,99999999,53998,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2454662,-095.2867143,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,1,1,1,48,423,002013,1037,1,9999,99999,99999999,9,99999,99999999,177550,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2507508,-095.2872555,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,1,1,1,48,423,002013,1037,1,9999,99999,99999999,9,99999,99999999,177550,0,0,0,0,0,46340,01,999,99999,99999999,A,01383997,94205,S,01939323,540,7,99999,99999999,+32.2507508,-095.2872555,L,1,99999,99999,99999,9,Y,N,74144,A,02412122,01502,3,99999,99999,45600,006,001,01779801,99999,99999999,9,999,99999,99999999,999999,89326,U,99999,U,000058,75703
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,47,187,050801,3017,3,9999,99999,99999999,9,99999,99999999,66869,0,0,0,0,0,34980,07,999,99999,99999999,A,01639801,92088,N,02464350,400,6,99999,99999999,+35.9186953,-086.8852095,L,1,99999,99999,99999,9,Y,N,27740,A,02403658,02101,3,01260,47187,99999,065,023,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009736,37064
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,27,021,960801,2002,2,9999,99999,99999999,9,99999,99999999,4192270,104197,0,0,104197,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3196105,-094.3587755,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56473
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,27,021,960801,2002,2,9999,99999,99999999,9,99999,99999999,4192270,104197,0,0,104197,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3196105,-094.3587755,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56473
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,27,021,960801,2002,2,9999,99999,99999999,9,99999,99999999,4192270,104197,0,0,104197,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3196105,-094.3587755,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56473
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,27,021,960801,2002,2,9999,99999,99999999,9,99999,99999999,4192270,104197,0,0,104197,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3196105,-094.3587755,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56473
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,27,021,960801,2002,2,9999,99999,99999999,9,99999,99999999,4192270,104197,0,0,104197,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3196105,-094.3587755,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56473
2,000,1,0,4,1,01,1,5,1,2,1,01,2,1,0,0,0,2,2,1,1,27,021,960801,2003,2,9999,99999,99999999,9,99999,99999999,140519,0,0,0,0,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3284887,-094.3391587,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56473
2,000,1,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,1,1,27,021,960801,2006,2,9999,99999,99999999,9,99999,99999999,548054,0,0,0,0,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3318281,-094.3536146,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56401
2,000,1,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,1,1,27,021,960801,2006,2,9999,99999,99999999,9,99999,99999999,548054,0,0,0,0,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3318281,-094.3536146,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56401
2,000,1,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,1,1,27,021,960801,2006,2,9999,99999,99999999,9,99999,99999999,548054,0,0,0,0,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3318281,-094.3536146,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56401
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,27,021,960801,2006,2,9999,99999,99999999,9,99999,99999999,548054,0,0,0,0,0,14660,08,999,99999,99999999,A,00659456,63958,A,00665757,999,4,99999,99999999,+46.3318281,-094.3536146,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00201,2,99999,99999,28350,09A,009,00662849,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000265,56401
2,000,4,0,2,7,04,3,4,0,1,1,01,4,0,0,0,0,4,2,2,1,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,4,0,7,3,03,4,3,1,1,2,01,1,1,1,1,0,1,2,2,1,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,4,1,01,1,5,1,2,1,01,2,1,0,0,0,2,2,1,1,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,2,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
4,801,0,0,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,0,26,121,003702,3001,3,9999,99999,99999999,9,99999,99999999,203845,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4017290,-086.3300772,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,3,0,3,5,12,5,5,1,1,1,02,4,0,0,0,0,4,1,2,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,5,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,6,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,3,1,01,1,5,1,3,1,04,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,4,1,01,1,5,1,3,2,06,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,5,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,5,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,7,1,01,1,5,1,4,1,06,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,4,1,01,1,5,1,4,2,07,2,1,0,0,0,2,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,4,1,02,1,5,1,5,1,01,4,0,0,0,0,4,1,1,1,34,027,041500,2031,2,9999,99999,99999999,9,99999,99999999,247618,0,0,0,0,0,35620,11,999,99999,99999999,A,00882231,17650,A,00882204,408,2,99999,99999999,+40.8663390,-074.4977179,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01501,1,03870,10740,99999,025,025,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,040402,07834
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,3,3,07,5,5,1,7,1,01,4,0,1,1,0,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,119,912000,2010,2,9999,99999,99999999,9,99999,99999999,2122318,0,0,0,0,0,49780,12,999,99999,99999999,A,01074072,82236,A,01086737,198,3,99999,99999999,+39.8951835,-081.9712248,L,2,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04884,097,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,060ADF,43701
2,000,1,0,4,1,02,1,5,1,6,1,01,4,0,1,1,0,4,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,2,0,3,1,02,1,5,1,6,1,04,4,0,1,0,0,4,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,1,0,4,1,02,1,5,1,7,1,01,4,0,1,1,0,4,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,2,0,3,1,02,1,5,1,7,1,04,4,0,1,1,1,4,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,2,0,2,1,02,1,5,0,7,2,04,4,0,1,1,0,4,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,2,0,7,1,02,1,5,2,8,1,01,4,1,1,1,1,3,1,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,1,0,4,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,1,0,4,1,01,1,5,1,3,2,03,2,1,0,0,0,2,2,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,06,059,075701,4010,4,9999,99999,99999999,9,99999,99999999,33677,0,0,0,0,0,31080,45,999,99999,99999999,A,00277294,90050,S,01935009,348,9,99999,99999999,+33.7653450,-117.8280543,L,1,11244,99999,99999,9,Y,N,80854,A,02412117,05922,4,99999,99999,40150,068,037,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,92780
2,000,3,0,2,1,02,1,5,0,1,1,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,2,1,02,1,5,0,1,1,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,4,2,04,3,2,1,1,1,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,5,5,12,5,5,1,1,1,01,4,1,0,0,0,3,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,2,1,02,1,5,0,1,1,02,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,2,1,02,1,5,0,1,1,02,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,5,2,04,3,2,1,1,1,07,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,1,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,39,049,002000,3014,3,9999,99999,99999999,9,99999,99999999,20546,0,0,0,0,0,18140,15,999,99999,99999999,A,01074037,18000,F,01086101,198,3,99999,99999999,+39.9830677,-083.0162073,L,1,99999,99999,99999,9,Y,N,18000,A,01086101,03406,2,99999,99999,04380,018,015,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025AGZ,43201
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,3,3,06,5,5,1,2,1,01,3,1,0,0,0,3,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,4,3,07,5,5,1,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,4,3,07,5,5,1,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,45,019,001902,3041,3,9999,99999,99999999,9,99999,99999999,265462,0,0,0,0,0,16700,01,999,99999,99999999,A,01252740,91664,S,01938309,999,5,99999,99999999,+32.7530210,-079.9661095,L,1,99999,99999,99999,9,Y,N,13330,A,02404030,02301,3,99999,99999,01440,115,041,01779799,99999,99999999,9,999,99999,99999999,999999,15508,U,99999,U,000417,29412
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,1,0,4,1,02,1,5,1,9,1,01,4,0,1,1,1,4,1,1,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,1,0,3,1,01,1,5,1,1,1,01,1,1,0,0,0,1,2,1,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,3,0,4,3,03,3,4,1,1,1,01,1,1,0,0,0,1,2,2,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,3,0,4,3,03,3,4,1,1,1,01,1,1,0,0,0,1,2,2,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,3,0,4,3,03,3,4,1,1,1,01,1,1,0,0,0,1,2,2,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,3,0,3,3,06,5,5,1,1,1,07,1,1,0,0,0,1,2,2,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,2,1,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,1,0,3,1,01,1,5,1,2,1,01,2,1,0,0,0,2,2,1,1,29,077,003600,2015,2,9999,99999,99999999,9,99999,99999999,47524,0,0,0,0,0,44180,07,999,99999,99999999,A,00758493,70009,N,00766694,999,4,99999,99999999,+37.2454238,-093.2676496,L,1,99999,99999,99999,9,Y,N,70000,A,02395942,02702,2,99999,99999,28860,131,030,01779791,99999,99999999,9,999,99999,99999999,999999,83953,U,99999,U,000030,65803
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,195,931500,3035,3,9999,99999,99999999,9,99999,99999999,26398,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9369446,-082.4802687,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,195,931500,3035,3,9999,99999,99999999,9,99999,99999999,26398,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9369446,-082.4802687,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,195,931500,3035,3,9999,99999,99999999,9,99999,99999999,26398,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9369446,-082.4802687,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,195,931500,3035,3,9999,99999,99999999,9,99999,99999999,26398,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9369446,-082.4802687,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,4,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,51,195,931500,3036,3,9999,99999,99999999,9,99999,99999999,17441,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9359639,-082.4797094,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,4,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,51,195,931500,3036,3,9999,99999,99999999,9,99999,99999999,17441,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9359639,-082.4797094,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,4,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,51,195,931500,3036,3,9999,99999,99999999,9,99999,99999999,17441,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9359639,-082.4797094,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,4,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,51,195,931500,3036,3,9999,99999,99999999,9,99999,99999999,17441,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9359639,-082.4797094,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,4,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,51,195,931500,3036,3,9999,99999,99999999,9,99999,99999999,17441,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9359639,-082.4797094,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,4,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,51,195,931500,3036,3,9999,99999,99999999,9,99999,99999999,17441,0,0,0,0,0,13720,09,999,99999,99999999,A,01496656,91738,N,01927255,999,5,99999,99999999,+36.9359639,-082.4797094,L,2,99999,99999,99999,9,N,N,67704,S,02629844,18500,3,99999,99999,04080,004,040,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000402,24230
2,000,2,0,4,1,02,1,5,1,5,2,07,4,0,0,0,0,4,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,1,0,5,3,07,5,5,2,6,1,04,4,1,1,0,0,1,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,2,0,1,6,05,0,0,0,6,1,04,4,0,1,0,0,4,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,2,0,1,6,05,0,0,0,6,1,04,4,0,1,0,0,4,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,2,0,3,3,07,5,5,1,6,1,04,4,0,1,0,0,4,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,3,0,1,6,05,0,0,0,6,1,04,4,0,1,0,0,4,2,2,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,3,0,1,6,05,0,0,0,6,1,04,4,0,1,0,0,4,2,2,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,3,0,1,6,05,0,0,0,6,1,04,4,0,1,0,0,4,2,2,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,2,0,3,1,02,1,5,1,6,1,04,4,0,1,1,0,4,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,2,0,3,1,02,1,5,1,6,1,04,4,0,1,1,0,4,2,1,1,06,037,408213,1003,1,9999,99999,99999999,9,99999,99999999,296605,0,0,0,0,0,31080,39,999,99999,99999999,A,00277283,90810,S,01935085,348,9,99999,99999999,+33.9907865,-117.8945525,L,1,31084,99999,99999,9,N,N,63218,S,02409220,03714,4,99999,99999,33750,055,029,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91748
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,26,099,264200,3010,3,9999,99999,99999999,9,99999,99999999,31139,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516552,-082.9729904,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,2,3,07,5,5,0,7,1,02,4,0,1,1,0,4,2,1,1,26,099,264200,3010,3,9999,99999,99999999,9,99999,99999999,31139,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516552,-082.9729904,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,26,099,264200,3010,3,9999,99999,99999999,9,99999,99999999,31139,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516552,-082.9729904,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,2,0,3,2,03,3,2,1,2,1,02,1,1,0,0,0,1,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,3,2,10,5,5,1,3,1,02,2,1,0,0,0,2,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,2,0,2,1,02,1,5,0,4,1,02,4,0,0,0,0,4,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,3,1,02,1,5,1,5,1,01,4,1,0,0,0,2,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,1,0,3,1,02,1,5,1,5,1,01,4,1,0,0,0,2,1,1,1,26,099,264200,3011,3,9999,99999,99999999,9,99999,99999999,39343,0,0,0,0,0,19820,09,999,99999,99999999,A,01622992,84000,F,01627213,220,3,99999,99999999,+42.4516155,-082.9740875,L,1,47664,99999,99999,9,Y,N,84000,A,01627213,03006,2,99999,99999,12450,022,009,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,099311,48089
2,000,3,0,2,3,06,5,5,0,2,1,03,2,1,0,0,0,2,2,2,1,38,079,941800,2015,2,4345,80020,01934334,R,99999,99999999,8544,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8110200,-099.7926644,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,3,0,2,3,06,5,5,0,2,1,03,2,1,0,0,0,2,2,2,1,38,079,941800,2015,2,4345,80020,01934334,R,99999,99999999,8544,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8110200,-099.7926644,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,3,0,3,3,06,5,5,1,7,1,01,2,1,1,1,0,3,2,2,1,38,079,941800,2015,2,4345,80020,01934334,R,99999,99999999,8544,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8110200,-099.7926644,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,3,0,3,3,03,3,4,1,1,1,03,1,1,0,0,0,1,2,2,1,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,2,0,3,3,06,5,5,1,3,1,03,2,1,0,0,0,2,2,1,1,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,2,0,3,3,06,5,5,1,3,1,03,2,1,0,0,0,2,2,1,1,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,2,0,5,1,01,1,5,1,4,1,03,2,1,0,0,0,2,2,1,1,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,4,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,4,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,4,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,1,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,5,1,02,1,5,2,4,1,01,4,1,0,0,0,2,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,5,1,02,1,5,2,4,1,01,4,1,0,0,0,3,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,5,2,04,3,2,1,4,1,01,4,1,0,0,0,2,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,5,2,04,3,2,1,4,1,01,4,0,1,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,2,0,2,5,04,3,2,0,5,1,01,4,0,0,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,47,189,030305,1010,1,9999,99999,99999999,9,99999,99999999,368418,0,0,0,0,0,34980,06,999,99999,99999999,A,01639802,90190,N,02464300,400,6,99999,99999999,+36.2383797,-086.5846255,L,1,99999,99999,99999,9,N,N,31100,S,02402550,01900,3,99999,99999,04550,057,017,01325873,99999,99999999,9,999,99999,99999999,999999,61273,U,99999,U,009801,37138
2,000,3,0,2,3,06,5,5,0,2,1,01,1,1,0,0,0,1,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,3,3,07,5,5,1,2,1,01,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,4,3,07,5,5,1,2,1,01,4,0,1,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,1,6,05,0,0,0,2,1,02,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,1,6,05,0,0,0,2,1,02,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,1,6,05,0,0,0,2,1,02,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,1,6,05,0,0,0,2,1,02,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,02,1,5,1,5,1,04,4,0,0,0,0,4,1,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,02,1,5,1,5,1,04,4,0,0,0,0,4,1,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,02,1,5,1,5,1,04,4,0,0,0,0,4,1,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,02,1,5,1,7,1,04,4,0,1,1,1,4,1,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,3,3,07,5,5,1,1,1,04,4,0,0,0,0,4,2,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,01,1,5,1,3,1,04,2,1,0,0,0,2,2,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,4,1,01,1,5,1,3,2,07,1,1,0,0,0,1,2,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,5,1,01,1,5,1,3,2,07,2,1,0,0,0,2,2,1,1,39,049,006239,1006,1,9999,99999,99999999,9,99999,99999999,36379,0,0,0,0,0,18140,12,999,99999,99999999,A,01074037,81242,A,01086117,198,3,99999,99999999,+40.0905409,-083.1496952,L,1,99999,99999,99999,9,N,N,22694,A,02394565,03404,2,99999,99999,04702,021,016,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ARN,43016
2,000,1,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,4,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,2,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,4,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,2,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,7,1,01,4,0,1,1,1,4,1,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,7,1,01,4,0,1,1,1,4,1,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,2,1,02,1,5,0,7,1,04,4,0,1,1,0,4,1,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,2,1,02,1,5,0,7,1,04,4,0,1,1,0,4,1,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,9,1,01,4,0,1,1,1,4,1,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,01,1,5,1,2,1,04,1,1,0,0,0,1,2,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,01,1,5,1,2,1,04,1,1,0,0,0,1,2,1,1,06,037,920109,1005,1,9999,99999,99999999,9,99999,99999999,53415,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4508135,-118.5526448,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,25,017,358600,5000,5,9999,99999,99999999,9,99999,99999999,215983,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4706692,-071.2387493,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,25,017,358600,5000,5,9999,99999,99999999,9,99999,99999999,215983,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4706692,-071.2387493,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,1,0,6,1,01,1,5,2,3,1,04,2,1,1,0,0,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,1,0,6,1,01,1,5,2,3,1,04,2,1,1,1,1,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,1,0,4,1,01,1,5,1,4,1,04,2,1,0,0,0,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,1,0,4,1,01,1,5,1,4,1,04,2,1,0,0,0,2,1,1,1,25,017,358600,5001,5,9999,99999,99999999,9,99999,99999999,59159,0,0,0,0,0,14460,05,715,99999,99999999,N,00606935,35215,A,00619401,148,1,99999,99999999,+42.4700943,-071.2399988,L,1,15764,71634,71650,1,N,N,35250,S,02378152,00607,1,99999,99999,06840,132,024,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,001027,02420
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,2,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,48,041,000800,2023,2,9999,99999,99999999,9,99999,99999999,43818,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6450459,-096.3526602,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,48,041,000800,2024,2,9999,99999,99999999,9,99999,99999999,11587,0,0,0,0,0,17780,17,999,99999,99999999,A,01383806,90495,S,01938574,999,7,99999,99999999,+30.6468083,-096.3566394,L,1,99999,99999,99999,9,Y,N,10912,A,02409927,07401,3,99999,99999,11790,014,005,01779801,99999,99999999,9,999,99999,99999999,999999,18748,U,99999,U,000013,77802
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,2,1,33,017,084301,3021,3,9999,99999,99999999,9,99999,99999999,11732,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2962100,-070.9736488,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,3,0,2,5,04,3,2,0,2,1,01,4,0,0,0,0,4,1,2,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,3,0,2,5,04,3,2,0,2,1,01,4,0,0,0,0,4,1,2,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,3,0,2,5,04,3,2,0,3,1,01,4,0,0,0,0,4,1,2,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,3,0,2,5,04,3,2,0,3,1,01,4,0,0,0,0,4,1,2,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,2,1,01,4,0,0,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,3,0,4,3,03,3,4,1,3,1,01,2,1,0,0,0,2,2,2,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,5,1,01,1,5,1,3,1,01,2,1,1,0,0,2,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,1,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,3,3,06,5,5,1,2,2,07,2,1,0,0,0,2,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,2,1,02,1,5,0,3,2,01,4,0,0,0,0,4,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,4,1,01,1,5,1,3,2,07,2,1,0,0,0,2,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,4,1,01,1,5,1,3,2,07,2,1,0,0,0,2,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,3,3,06,5,5,1,3,2,07,2,1,0,0,0,2,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,4,1,01,1,5,1,4,2,07,2,1,0,0,0,2,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,2,0,3,1,02,1,5,1,4,2,07,4,0,0,0,0,4,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,1,1,0,4,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,2,0,3,1,02,1,5,1,5,1,01,4,0,1,1,1,4,2,1,1,48,113,016204,1000,1,9999,99999,99999999,9,99999,99999999,49133,0,0,0,0,0,19100,33,999,99999,99999999,A,01383842,93682,S,01939217,206,7,99999,99999999,+32.7160879,-096.9964120,L,1,19124,99999,99999,9,N,N,30464,A,02410632,02319,3,99999,99999,21420,105,009,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,004534,75051
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,2,3,06,5,5,0,3,1,01,2,1,0,0,0,2,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,3,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,4,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,4,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,3,0,2,7,08,5,5,0,3,1,01,4,0,0,0,0,4,2,2,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,2,0,2,3,06,5,5,0,4,1,01,2,1,0,0,0,2,2,1,1,36,053,030401,2031,2,2555,54862,02419043,R,99999,99999999,18528,0,0,0,0,0,45060,22,999,99999,99999999,A,00974125,71993,A,00979535,532,2,99999,99999999,+43.0467392,-075.8892695,L,1,99999,99999,99999,9,N,N,15561,A,02391607,01500,1,99999,99999,07470,121,053,01779796,99999,99999999,B,999,99999,99999999,T00900,16642,U,99999,U,000051,13037
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,2,0,2,2,11,5,5,0,8,1,01,4,0,1,1,1,4,1,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,3,0,6,1,01,1,5,1,2,1,01,2,1,0,0,0,2,2,2,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,3,0,6,1,01,1,5,1,2,1,01,2,1,0,0,0,2,2,2,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,1,0,3,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,1,0,3,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,1,0,3,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,1,0,6,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,30,063,000901,4012,4,9999,99999,99999999,9,99999,99999999,3378022,151630,0,0,151630,0,33540,00,999,99999,99999999,A,01719596,92142,S,01940663,999,8,99999,99999999,+46.8436365,-114.0890336,B,1,99999,99999,99999,9,N,N,55675,S,02408996,00200,4,25890,18540,99999,098,049,00767982,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0098TR,59804
2,000,3,0,3,1,01,1,5,1,4,1,02,2,1,1,0,0,2,2,2,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,3,0,1,6,05,0,0,0,5,1,01,4,0,0,0,0,4,2,2,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,1,0,3,3,07,5,5,1,5,1,02,4,0,0,0,0,4,2,1,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,1,0,3,7,08,5,5,1,8,1,02,4,0,1,1,1,4,2,1,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,3,0,2,3,07,5,5,0,8,1,02,4,0,1,1,1,4,2,2,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,3,0,2,3,07,5,5,0,8,1,02,4,0,1,1,1,4,2,2,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,3,0,2,3,07,5,5,0,8,1,02,4,0,1,1,1,4,2,2,1,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,05,035,030102,3013,3,9999,99999,99999999,9,99999,99999999,38546,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1510207,-090.1648513,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,1,0,3,1,02,1,5,1,3,1,02,4,0,0,0,0,4,1,1,1,05,035,030102,3014,3,9999,99999,99999999,9,99999,99999999,20258,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1517072,-090.1640777,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,1,0,3,1,02,1,5,1,4,1,02,4,0,0,0,0,4,1,1,1,05,035,030102,3014,3,9999,99999,99999999,9,99999,99999999,20258,0,0,0,0,0,32820,01,999,99999,99999999,A,00069162,92508,N,00068751,368,7,99999,99999999,+35.1517072,-090.1640777,L,1,99999,99999,99999,9,N,N,74540,A,02405710,00600,3,99999,99999,08040,050,024,00068085,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,000041,72301
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,08,093,000300,1107,1,9999,99999,99999999,9,99999,99999999,1489873,3150,0,0,3150,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2569344,-106.0673530,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,08,093,000300,1108,1,9999,99999,99999999,9,99999,99999999,2219357,22297,0,0,22297,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2442043,-106.0604996,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,1,1,1,08,093,000300,1108,1,9999,99999,99999999,9,99999,99999999,2219357,22297,0,0,22297,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2442043,-106.0604996,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,1,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,1,1,08,093,000300,1108,1,9999,99999,99999999,9,99999,99999999,2219357,22297,0,0,22297,0,19740,05,999,99999,99999999,A,00198162,91254,S,01935459,216,8,99999,99999999,+39.2442043,-106.0604996,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02101,4,99999,99999,03840,060,002,01779779,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,093002,80440
2,000,2,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,2,0,2,2,11,5,5,0,8,1,01,4,0,1,1,1,4,1,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,4,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,2,7,04,3,4,0,4,1,01,4,0,0,0,0,4,2,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,1,0,2,7,04,3,4,0,6,1,01,4,0,1,0,0,4,2,1,1,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,55,083,100600,1047,1,9999,99999,99999999,9,99999,99999999,781378,0,0,0,0,0,24580,08,999,99999,99999999,A,01581102,09425,A,01582854,267,3,99999,99999999,+45.0407767,-088.3687172,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,2,99999,99999,14700,036,012,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,004161,54174
2,000,2,0,4,1,01,1,5,1,3,1,01,1,1,0,0,0,1,1,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,6,1,02,1,5,2,7,1,01,4,1,1,1,0,2,1,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,2,1,02,1,5,0,7,1,07,4,0,1,1,0,4,1,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,3,0,2,2,11,5,5,0,7,2,07,4,0,1,1,0,4,1,2,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,3,1,02,1,5,1,7,2,07,4,0,1,1,1,4,1,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,55,087,011104,1010,1,9999,99999,99999999,9,99999,99999999,37230,0,0,0,0,0,11540,08,999,99999,99999999,A,01581104,30075,A,01583295,118,3,99999,99999999,+44.2784403,-088.4434077,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00400,2,99999,99999,00390,055,019,01779806,99999,99999999,9,999,99999,99999999,999999,02764,U,99999,U,004411,54914
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,2,1,1,05,125,010516,2004,2,9999,99999,99999999,9,99999,99999999,68069,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6583978,-092.9450349,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,3,3,07,5,5,1,8,1,01,4,0,1,1,1,4,2,1,1,05,125,010516,2005,2,9999,99999,99999999,9,99999,99999999,92741,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6625771,-092.9388385,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,05,125,010516,2008,2,9999,99999,99999999,9,99999,99999999,145240,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6598489,-092.9429654,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,05,125,010516,2008,2,9999,99999,99999999,9,99999,99999999,145240,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6598489,-092.9429654,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,2,1,1,05,125,010516,2008,2,9999,99999,99999999,9,99999,99999999,145240,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6598489,-092.9429654,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,2,1,1,05,125,010516,2008,2,9999,99999,99999999,9,99999,99999999,145240,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6598489,-092.9429654,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,05,125,010516,2010,2,9999,99999,99999999,9,99999,99999999,153063,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6672595,-092.9641942,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,6,2,10,5,5,1,2,1,01,3,1,0,0,0,3,1,1,1,05,125,010516,2011,2,9999,99999,99999999,9,99999,99999999,95217,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6683956,-092.9639106,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,05,125,010516,2012,2,9999,99999,99999999,9,99999,99999999,141224,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6674220,-092.9745337,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,05,125,010516,2015,2,9999,99999,99999999,9,99999,99999999,123699,0,0,0,0,0,30780,02,999,99999,99999999,A,00067102,92370,N,00069046,340,7,99999,99999999,+34.6651910,-092.9764604,L,1,99999,99999,99999,9,N,N,33482,S,02402601,01400,3,99999,99999,06420,022,014,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000035,71909
2,000,2,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,1,1,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,2,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,1,1,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,2,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,1,1,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,37,061,090504,1012,1,9999,99999,99999999,9,99999,99999999,8592248,316827,0,0,316827,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9893913,-077.7967513,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,1,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,1,1,37,061,090504,1013,1,9999,99999,99999999,9,99999,99999999,216153,0,0,0,0,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9705377,-077.7997192,L,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28572
2,000,2,0,2,2,11,5,5,0,1,1,01,4,0,0,0,0,4,1,1,1,37,061,090504,1014,1,9999,99999,99999999,9,99999,99999999,403025,0,0,0,0,0,99999,07,999,99999,99999999,A,01026132,92972,N,01026649,999,5,99999,99999999,+34.9675937,-077.7952217,L,9,99999,99999,99999,9,9,9,99999,9,99999999,03900,3,99999,99999,01200,004,010,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00SMCA,28518
2,000,3,0,7,2,10,5,5,1,1,2,01,1,1,0,0,0,1,1,2,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,3,0,4,2,10,5,5,1,2,2,01,3,1,0,0,0,3,1,2,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,4,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,2,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,4,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,2,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,4,0,2,5,04,3,2,0,4,2,07,4,0,0,0,0,4,1,2,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,2,0,4,1,01,1,5,1,5,2,01,3,1,0,0,0,3,1,1,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,48,481,741000,3030,3,9999,99999,99999999,9,99999,99999999,2368856,28719,0,0,28719,0,20900,27,999,99999,99999999,A,01384026,91180,S,01938714,288,7,99999,99999999,+29.1649873,-096.2669192,B,2,99999,99999,99999,9,9,9,99999,9,99999999,05000,3,99999,99999,18280,085,018,01779801,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000401,77437
2,000,1,0,3,5,12,5,5,1,5,2,06,4,0,1,1,0,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,2,0,2,5,12,5,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,2,0,2,5,12,5,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,1,0,4,1,02,1,5,1,7,2,07,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,071,050104,3005,3,9999,99999,99999999,9,99999,99999999,56439,11633,0,0,11633,0,15980,19,999,99999,99999999,A,00295758,90234,S,01935699,163,5,99999,99999999,+26.4471267,-081.8251044,B,1,99999,99999,99999,9,N,N,21150,A,02771501,07101,3,99999,99999,01080,076,027,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000012,33928
2,000,1,0,2,2,11,5,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,031,014408,3009,3,9999,99999,99999999,9,99999,99999999,16059,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2736981,-081.4371426,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32224
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,12,031,014408,3009,3,9999,99999,99999999,9,99999,99999999,16059,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2736981,-081.4371426,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32224
2,000,3,0,4,5,12,5,5,1,1,1,01,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,5,12,5,5,0,2,1,01,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,4,5,12,5,5,1,2,1,01,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,4,5,12,5,5,1,2,1,01,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,1,02,1,5,0,3,1,04,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,2,11,5,5,0,4,1,01,4,0,0,0,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,1,0,3,1,01,1,5,1,3,2,06,1,1,0,0,0,1,2,1,1,34,029,722900,1028,1,9999,99999,99999999,9,99999,99999999,32612,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9782444,-074.2067074,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,4,1,01,1,5,1,3,2,07,2,1,0,0,0,2,2,1,1,34,029,722900,1028,1,9999,99999,99999999,9,99999,99999999,32612,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9782444,-074.2067074,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,6,1,02,1,5,2,5,1,01,4,0,1,1,1,4,2,1,1,34,029,722900,1028,1,9999,99999,99999999,9,99999,99999999,32612,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9782444,-074.2067074,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,34,029,722900,1028,1,9999,99999,99999999,9,99999,99999999,32612,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9782444,-074.2067074,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,3,3,07,5,5,2,7,1,01,4,1,1,1,0,2,2,1,1,34,029,722900,1028,1,9999,99999,99999999,9,99999,99999999,32612,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9782444,-074.2067074,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,3,3,07,5,5,2,8,1,01,4,0,1,1,1,4,2,1,1,34,029,722900,1028,1,9999,99999,99999999,9,99999,99999999,32612,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9782444,-074.2067074,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,1,1,34,029,722900,1029,1,9999,99999,99999999,9,99999,99999999,47594,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9796031,-074.2035572,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,1,1,34,029,722900,1029,1,9999,99999,99999999,9,99999,99999999,47594,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9796031,-074.2035572,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,1,1,34,029,722900,1029,1,9999,99999,99999999,9,99999,99999999,47594,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9796031,-074.2035572,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,1,0,6,1,01,1,5,1,3,2,01,3,1,0,0,0,3,1,1,1,34,029,722900,1029,1,9999,99999,99999999,9,99999,99999999,47594,0,0,0,0,0,35620,03,999,99999,99999999,A,00882279,73125,A,00882074,408,2,99999,99999999,+39.9796031,-074.2035572,L,1,35154,99999,99999,9,N,N,73110,S,02390394,01202,1,99999,99999,16230,010,010,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,035051,08753
2,000,3,0,2,7,04,3,4,0,1,1,01,4,0,0,0,0,4,2,2,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,2,7,04,3,4,0,1,1,01,4,0,0,0,0,4,2,2,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,2,7,04,3,4,0,1,1,01,4,0,0,0,0,4,2,2,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,2,7,04,3,4,0,1,1,01,4,0,0,0,0,4,2,2,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,4,1,01,1,5,1,2,1,01,2,1,0,0,0,2,2,2,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,2,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,1,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,5,1,01,1,5,1,4,2,01,2,1,0,0,0,2,2,2,1,39,167,020101,1038,1,9999,99999,99999999,9,99999,99999999,12745,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2783874,-081.5956648,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,2,0,3,3,07,5,5,1,3,1,01,4,0,0,0,0,4,2,1,1,39,167,020101,1039,1,9999,99999,99999999,9,99999,99999999,6602,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2782371,-081.5964031,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,39,167,020101,1039,1,9999,99999,99999999,9,99999,99999999,6602,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2782371,-081.5964031,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,39,167,020101,1039,1,9999,99999,99999999,9,99999,99999999,6602,0,0,0,0,0,31930,06,999,99999,99999999,A,01074095,05424,F,01087127,425,3,99999,99999999,+39.2782371,-081.5964031,L,2,99999,99999,99999,9,N,N,05424,A,01087127,04200,2,99999,99999,04361,094,030,01085497,99999,99999999,9,999,99999,99999999,999999,67672,U,99999,U,084AAA,45714
2,000,1,0,5,1,02,1,5,1,5,1,01,4,0,0,0,0,4,2,1,1,34,013,020800,3023,3,9999,99999,99999999,9,99999,99999999,69267,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7752554,-074.3303528,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,1,0,3,1,01,2,5,1,5,1,01,2,1,0,0,0,2,2,1,1,34,013,020800,3023,3,9999,99999,99999999,9,99999,99999999,69267,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7752554,-074.3303528,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,2,0,4,1,02,1,5,1,6,1,01,4,0,1,0,0,4,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,2,0,2,1,02,1,5,0,6,1,04,4,0,1,0,0,4,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,2,0,2,1,02,1,5,0,6,1,04,4,0,1,0,0,4,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,2,0,2,1,02,1,5,0,7,1,04,4,0,1,1,1,4,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,2,0,1,4,09,0,0,0,9,1,01,4,0,1,1,1,4,1,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,2,0,6,1,01,1,5,2,3,2,01,3,1,1,0,0,3,2,1,1,34,013,020800,3024,3,9999,99999,99999999,9,99999,99999999,68958,0,0,0,0,0,35620,11,999,99999,99999999,A,00882276,40890,A,00882219,408,2,99999,99999999,+40.7740665,-074.3265999,L,1,35084,99999,99999,9,9,9,99999,9,99999999,01404,1,99999,99999,08820,027,027,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,050010,07039
2,000,1,0,3,1,02,1,5,1,3,1,01,4,0,0,0,0,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,3,1,02,1,5,1,3,1,01,4,0,0,0,0,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,4,1,02,1,5,2,4,1,01,4,1,0,0,0,2,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,3,1,02,1,5,1,5,1,07,4,1,0,0,0,2,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,3,1,02,1,5,1,6,1,01,4,0,1,0,0,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,1,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,101,032802,1024,1,9999,99999,99999999,9,99999,99999999,65161,0,0,0,0,0,45300,12,999,99999,99999999,A,00295739,93770,S,01935982,999,5,99999,99999999,+28.2953350,-082.1761505,L,1,99999,99999,99999,9,9,9,99999,9,99999999,10101,3,99999,99999,01530,038,020,00294478,99999,99999999,9,999,99999,99999999,999999,98182,U,99999,U,000006,33525
2,000,3,0,4,3,06,5,5,1,2,1,01,3,1,0,0,0,3,2,2,1,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,3,0,4,3,06,5,5,1,2,1,01,3,1,0,0,0,3,2,2,1,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,3,0,2,3,06,5,5,0,2,1,02,2,1,0,0,0,2,2,2,1,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,3,0,5,7,08,5,5,1,4,1,02,4,0,1,1,0,4,2,2,1,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,3,0,1,6,05,0,0,0,6,1,02,4,0,1,0,0,4,2,2,1,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,3,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,2,1,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,42,069,102600,1012,1,9999,99999,99999999,9,99999,99999999,6760,0,0,0,0,0,42540,08,999,99999,99999999,A,01213675,69000,F,01215328,999,2,99999,99999999,+41.3955486,-075.6626727,L,1,99999,99999,99999,9,Y,N,69000,A,01215328,00701,1,99999,99999,21090,112,022,01779798,99999,99999999,9,999,99999,99999999,999999,80227,U,99999,U,002015,18505
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,3,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,2,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,2,0,2,1,02,1,5,0,9,1,01,4,0,1,1,1,4,1,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,29,091,090500,2000,2,9999,99999,99999999,9,99999,99999999,886610,0,0,0,0,0,48460,08,999,99999,99999999,A,00758500,33382,N,00766785,999,4,99999,99999999,+36.7031446,-091.8576476,L,2,99999,99999,99999,9,9,9,99999,9,99999999,02600,2,11850,99999,99999,154,033,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,65775
2,000,1,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,1,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,1,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,1,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,1,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,3,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,3,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,3,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,3,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,3,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,2,1,12,127,082506,2000,2,9999,99999,99999999,9,99999,99999999,1308779,0,0,0,0,0,19660,06,999,99999,99999999,A,00306921,92847,S,01935904,422,5,99999,99999999,+29.1298558,-081.0144844,L,1,99999,99999,99999,9,N,N,58575,A,02404555,12703,3,99999,99999,01920,025,014,00294478,99999,99999999,9,999,99999,99999999,999999,22612,U,99999,U,000180,32129
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,06,037,190801,2006,2,9999,99999,99999999,9,99999,99999999,21514,0,0,0,0,0,31080,28,999,99999,99999999,A,00277283,91750,S,01935180,348,9,99999,99999999,+34.0948388,-118.3254810,L,1,31084,99999,99999,9,Y,N,44000,A,02410877,03732,4,99999,99999,22710,050,026,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,90028
2,000,1,0,2,1,02,1,5,0,6,1,02,4,0,1,0,0,4,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,4,2,04,3,2,2,6,1,02,4,1,1,0,0,1,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,3,2,11,5,5,1,6,1,02,4,0,1,1,1,4,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,2,0,2,1,02,1,5,0,6,1,04,4,0,1,0,0,4,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,2,0,2,1,02,1,5,0,6,1,04,4,0,1,0,0,4,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,7,1,01,1,5,2,6,2,06,2,1,1,0,0,3,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,7,1,01,1,5,1,7,1,01,2,1,1,1,0,2,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,2,5,04,4,1,0,7,1,01,4,0,1,1,0,4,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,5,2,11,5,5,2,7,1,01,4,1,1,1,0,1,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,1,0,5,2,11,5,5,2,7,1,01,4,1,1,1,0,2,1,1,1,10,001,040204,3009,3,9999,99999,99999999,9,99999,99999999,503169,0,0,0,0,0,20100,00,999,99999,99999999,A,00217271,93700,S,01935626,428,5,99999,99999999,+39.2753544,-075.6186397,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00200,3,99999,99999,01620,029,015,01779781,99999,99999999,9,999,99999,99999999,999999,24580,U,99999,U,001-29,19977
2,000,3,0,3,1,01,1,5,1,3,1,02,1,1,0,0,0,1,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,1,0,3,1,02,1,5,1,3,2,03,4,0,0,0,0,4,1,1,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,4,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,4,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,4,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,1,0,0,4,1,1,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,2,5,12,5,5,0,3,1,01,4,0,0,0,0,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,7,2,03,3,2,1,3,1,02,3,1,0,0,0,3,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,7,2,03,3,2,1,3,1,02,3,1,0,0,0,3,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,1,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,2,1,27,123,042602,1025,1,9999,99999,99999999,9,99999,99999999,18401,0,0,0,0,0,33460,04,999,99999,99999999,A,00659507,47221,F,02395261,378,4,99999,99999999,+45.0207360,-092.9859682,L,1,99999,99999,99999,9,N,N,47221,A,02395261,01502,2,99999,99999,23850,43B,043,00662849,99999,99999999,9,999,99999,99999999,999999,57628,U,99999,U,000400,55109
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,3,0,7,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,34,029,715800,2019,2,9999,99999,99999999,9,99999,99999999,535012,0,0,0,0,0,35620,04,999,99999,99999999,A,00882279,38550,A,00882076,408,2,99999,99999999,+40.0680432,-074.2023893,L,1,35154,99999,99999,9,9,9,99999,9,99999999,01203,1,99999,99999,08220,030,030,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,070015,08701
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,44,007,010501,1015,1,9999,99999,99999999,9,99999,99999999,28620,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8081862,-071.3563650,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,44,007,010501,1015,1,9999,99999,99999999,9,99999,99999999,28620,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8081862,-071.3563650,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,2,1,44,007,010501,1015,1,9999,99999,99999999,9,99999,99999999,28620,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8081862,-071.3563650,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,2,1,1,44,007,010501,1015,1,9999,99999,99999999,9,99999,99999999,28620,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8081862,-071.3563650,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,3,0,3,1,02,1,5,1,7,2,06,4,0,1,1,1,4,2,2,1,44,007,010501,1015,1,9999,99999,99999999,9,99999,99999999,28620,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8081862,-071.3563650,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,5,1,02,1,5,1,5,2,07,4,0,0,0,0,4,1,1,1,44,007,010501,1016,1,9999,99999,99999999,9,99999,99999999,10624,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8082878,-071.3544637,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,5,1,02,1,5,1,5,2,07,4,0,0,0,0,4,1,1,1,44,007,010501,1016,1,9999,99999,99999999,9,99999,99999999,10624,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8082878,-071.3544637,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,5,1,02,1,5,2,6,1,02,4,0,1,1,1,4,1,1,1,44,007,010501,1016,1,9999,99999,99999999,9,99999,99999999,10624,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8082878,-071.3544637,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,2,0,2,1,02,1,5,0,8,1,04,4,0,1,1,1,4,1,1,1,44,007,010501,1016,1,9999,99999,99999999,9,99999,99999999,10624,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8082878,-071.3544637,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,4,1,01,1,5,1,2,1,06,1,1,0,0,0,1,2,1,1,44,007,010501,1016,1,9999,99999,99999999,9,99999,99999999,10624,0,0,0,0,0,39300,01,715,99999,99999999,N,01219781,22960,F,01220071,148,1,99999,99999999,+41.8082878,-071.3544637,L,1,99999,99999,77200,1,N,N,22960,A,01220071,00106,1,99999,99999,00330,065,014,01219835,99999,99999999,9,999,99999,99999999,999999,72505,U,99999,U,441018,02914
2,000,1,0,2,3,06,5,5,0,4,1,01,2,1,0,0,0,2,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,3,06,5,5,0,4,1,01,2,1,0,0,0,2,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,4,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,3,1,01,1,5,1,5,1,01,2,1,0,0,0,2,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,3,07,5,5,0,5,1,01,4,0,1,0,0,4,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,4,1,02,1,5,2,6,1,01,4,0,1,0,0,4,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,7,08,5,5,0,7,1,01,4,0,1,1,0,4,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,1,02,1,5,0,7,1,02,4,0,1,1,0,4,2,1,1,26,125,190700,1012,1,9999,99999,99999999,9,99999,99999999,723948,0,0,0,0,0,19820,08,999,99999,99999999,A,01623005,59820,A,01626833,220,3,99999,99999999,+42.7459432,-083.1832882,L,1,47664,99999,99999,9,9,9,99999,9,99999999,02902,2,99999,99999,29940,046,012,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,125227,48363
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,2,1,1,51,109,950500,1001,1,9999,99999,99999999,9,99999,99999999,1067605,0,0,0,0,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9201047,-077.7301170,L,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,6,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,5,1,02,1,5,1,2,1,01,4,1,0,0,0,1,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,3,2,10,5,5,1,2,1,02,2,1,0,0,0,2,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,6,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,1,0,6,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,51,109,950500,1002,1,9999,99999,99999999,9,99999,99999999,5248364,14612,0,0,14612,0,99999,07,999,99999,99999999,A,01494707,93999,N,01927351,999,5,99999,99999999,+37.9138576,-077.7416856,B,9,99999,99999,99999,9,9,9,99999,9,99999999,10901,3,99999,99999,02280,056,022,01779803,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000601,23024
2,000,4,0,3,3,07,5,5,1,5,1,01,4,0,0,0,0,4,2,2,1,12,021,011210,1003,1,9999,99999,99999999,9,99999,99999999,14625,0,0,0,0,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.2982381,-081.6285035,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000118,34120
2,000,4,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,2,1,12,021,011210,1003,1,9999,99999,99999999,9,99999,99999999,14625,0,0,0,0,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.2982381,-081.6285035,L,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,08974,U,99999,U,000118,34120
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,5,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,1,0,6,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,12,021,011211,1000,1,9999,99999,99999999,9,99999,99999999,20952906,928265,0,0,928265,0,34940,25,999,99999,99999999,A,00295754,91560,S,01935803,163,5,99999,99999999,+26.3466070,-081.5789870,B,1,99999,99999,99999,9,9,9,99999,9,99999999,02103,3,99999,99999,00330,080,028,00294478,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000120,34120
2,000,3,0,3,1,01,1,5,1,3,2,01,2,1,0,0,0,2,1,2,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,3,0,4,1,02,1,5,1,4,2,07,4,0,0,0,0,4,1,2,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,3,0,4,1,02,1,5,1,4,2,07,4,0,0,0,0,4,1,2,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,2,0,7,1,01,1,5,2,4,2,07,2,1,1,1,1,2,1,1,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,3,0,2,1,02,1,5,0,5,2,07,4,0,0,0,0,4,1,2,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,3,0,6,1,02,1,5,1,6,2,06,4,0,1,0,0,4,1,2,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,2,0,2,1,02,1,5,0,6,2,07,4,0,1,0,0,4,1,1,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,2,0,2,1,02,1,5,0,6,2,07,4,0,1,0,0,4,1,1,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,3,0,2,1,02,1,5,0,7,2,06,4,0,1,1,1,4,1,2,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,2,0,2,1,02,1,5,0,7,2,07,4,0,1,1,0,4,1,1,1,12,086,014702,2009,2,9999,99999,99999999,9,99999,99999999,32178,0,0,0,0,0,33100,26,999,99999,99999999,A,00295755,91705,S,01935814,370,5,99999,99999999,+25.7448181,-080.3975378,L,1,33124,99999,99999,9,N,N,70700,S,02402913,08618,3,99999,99999,00390,118,039,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,000449,33175
2,000,3,0,5,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,2,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,5,2,10,5,5,2,3,1,04,3,1,1,1,0,3,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,4,1,01,1,5,1,3,2,06,3,1,0,0,0,3,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,3,0,4,1,01,1,5,1,3,2,07,2,1,0,0,0,2,1,2,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,2,1,02,1,5,0,4,2,06,4,0,0,0,0,4,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,4,1,02,1,5,1,4,2,06,4,0,0,0,0,4,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,4,1,02,1,5,1,4,2,06,4,0,0,0,0,4,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,1,0,4,1,02,1,5,1,4,2,06,4,0,0,0,0,4,1,1,1,06,029,003124,2001,2,9999,99999,99999999,9,99999,99999999,92745,0,0,0,0,0,12540,23,999,99999,99999999,A,02054176,90180,S,01935022,999,9,99999,99999999,+35.3015526,-119.0696166,L,1,99999,99999,99999,9,Y,N,03526,A,02409774,02908,4,06390,19540,99999,034,016,01779778,99999,99999999,9,999,99999,99999999,999999,04681,U,99999,U,,93313
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,51,013,102500,2009,2,9999,99999,99999999,9,99999,99999999,52397,0,0,0,0,0,47900,08,999,99999,99999999,A,01480097,90072,F,01480097,548,5,99999,99999999,+38.8637132,-077.0854088,L,1,47894,99999,99999,9,Y,N,03000,S,02389148,01302,3,99999,99999,00270,049,031,01779803,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,000026,22204
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,1,4,09,0,0,0,3,1,02,4,0,0,0,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,2,2,11,5,5,0,3,1,02,4,0,1,1,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,2,2,11,5,5,0,3,1,02,4,0,1,1,0,4,1,2,1,36,047,097400,2001,2,9999,99999,99999999,9,99999,99999999,17081,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6466005,-073.8980856,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04318,1,99999,99999,20580,058,019,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001616,11236
2,000,3,0,3,1,01,1,5,1,2,1,02,1,1,0,0,0,1,2,2,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,3,0,2,7,04,3,4,0,2,1,02,4,0,0,0,0,4,2,2,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,3,0,4,7,04,3,4,1,2,1,07,4,0,0,0,0,4,2,2,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,3,0,2,7,08,5,5,0,2,1,07,4,0,0,0,0,4,2,2,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,3,0,4,3,06,5,5,1,3,1,01,3,1,0,0,0,3,2,2,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,3,0,5,3,06,5,5,1,3,2,06,2,1,0,0,0,2,2,2,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,39,099,812001,3017,3,9999,99999,99999999,9,99999,99999999,219371,0,0,0,0,0,49660,13,999,99999,99999999,A,01074062,07468,A,01086558,566,3,99999,99999999,+41.0010475,-080.6742446,L,1,99999,99999,99999,9,9,9,99999,9,99999999,01003,2,99999,99999,04830,059,033,01085497,99999,99999999,9,999,99999,99999999,999999,97831,U,99999,U,050AKY,44512
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,2,0,2,3,07,5,5,0,7,1,01,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,1,0,1,6,05,0,0,0,7,1,02,4,0,1,1,0,4,2,1,1,06,095,251901,1015,1,9999,99999,99999999,9,99999,99999999,185087,0,0,0,0,0,46700,05,999,99999,99999999,A,00277312,93530,S,01935358,488,9,99999,99999999,+38.1399768,-122.2443513,L,1,99999,99999,99999,9,Y,N,81666,A,02412142,09501,4,99999,99999,40740,014,003,01779778,99999,99999999,9,999,99999,99999999,999999,90028,U,99999,U,,94589
2,000,1,0,6,1,01,1,5,1,2,2,01,2,1,0,0,0,2,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,3,1,01,1,5,1,2,2,06,1,1,0,0,0,1,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,4,1,01,1,5,1,2,2,06,1,1,0,0,0,1,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,2,1,02,1,5,0,2,2,06,4,0,0,0,0,4,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,2,1,02,1,5,0,2,2,06,4,0,0,0,0,4,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,6,1,01,1,5,1,3,1,03,2,1,0,0,0,2,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,6,1,01,1,5,1,3,2,01,2,1,0,0,0,2,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,6,1,02,1,5,2,3,2,01,4,0,0,0,0,4,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,7,1,01,1,5,1,3,2,06,3,1,0,0,0,3,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,1,0,4,3,06,5,5,1,3,2,06,2,1,0,0,0,2,2,1,1,04,013,082211,3005,3,9999,99999,99999999,9,99999,99999999,177403,0,0,0,0,0,38060,03,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.4297840,-112.3153024,L,1,99999,99999,99999,9,N,N,04720,A,02409765,00133,4,04440,08520,99999,019,019,01779777,99999,99999999,9,999,99999,99999999,999999,69192,U,99999,U,000121,85323
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,34,039,031602,3002,3,9999,99999,99999999,9,99999,99999999,24241,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6872425,-074.2061061,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,3,1,01,1,5,1,2,2,06,1,1,0,0,0,1,1,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,3,1,01,1,5,1,2,2,06,1,1,0,0,0,1,1,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,5,1,01,1,5,1,2,2,06,3,1,0,0,0,3,1,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,5,1,01,1,5,1,3,2,06,3,1,0,0,0,3,1,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,3,1,01,1,5,1,4,2,06,1,1,0,0,0,1,1,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,3,1,01,1,5,1,4,2,06,1,1,0,0,0,1,1,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,1,6,05,0,0,0,1,2,06,4,0,0,0,0,4,2,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,1,6,05,0,0,0,2,2,06,4,0,0,0,0,4,2,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,3,0,1,6,05,0,0,0,2,2,07,4,0,0,0,0,4,2,2,1,34,039,031602,3005,3,9999,99999,99999999,9,99999,99999999,39417,0,0,0,0,0,35620,08,999,99999,99999999,A,00882235,21000,F,00885205,408,2,99999,99999999,+40.6851460,-074.2069994,L,1,35084,99999,99999,9,N,N,21000,A,00885205,01905,1,99999,99999,04590,020,020,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,020403,07208
2,000,2,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,2,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,2,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,5,1,01,4,0,1,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,5,1,01,4,0,1,0,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,6,1,01,4,1,1,0,0,2,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,6,1,01,4,0,1,1,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,1,0,4,1,02,1,5,1,7,1,01,4,0,1,1,1,4,1,1,1,53,073,000808,1003,1,9999,99999,99999999,9,99999,99999999,121359,0,0,0,0,0,13380,02,999,99999,99999999,A,01529224,90176,S,01939449,999,9,99999,99999999,+48.7216830,-122.3324767,L,1,99999,99999,99999,9,N,N,68200,S,02410015,27301,4,99999,99999,00420,040,040,01779804,99999,99999999,9,999,99999,99999999,999999,06652,U,99999,U,000176,98229
2,000,3,0,1,4,09,0,0,0,7,2,06,4,0,1,1,0,4,1,2,1,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,28,115,950102,3005,3,9999,99999,99999999,9,99999,99999999,404020,0,0,0,0,0,46180,01,999,99999,99999999,A,00695803,90522,N,00712036,539,6,99999,99999999,+34.3344615,-089.0484133,L,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000101,38863
2,000,3,0,3,2,03,3,2,1,2,1,07,2,1,0,0,0,2,1,2,1,28,115,950102,3006,3,9999,99999,99999999,9,99999,99999999,1708405,23481,0,0,23481,0,46180,01,999,99999,99999999,A,00695803,91260,N,00712037,539,6,99999,99999999,+34.3231169,-089.0798466,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000202,38841
2,000,3,0,4,2,03,4,1,1,4,1,01,1,1,0,0,0,1,1,2,1,28,115,950102,3006,3,9999,99999,99999999,9,99999,99999999,1708405,23481,0,0,23481,0,46180,01,999,99999,99999999,A,00695803,91260,N,00712037,539,6,99999,99999999,+34.3231169,-089.0798466,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000202,38841
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,28,115,950102,3006,3,9999,99999,99999999,9,99999,99999999,1708405,23481,0,0,23481,0,46180,01,999,99999,99999999,A,00695803,91260,N,00712037,539,6,99999,99999999,+34.3231169,-089.0798466,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000202,38841
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,28,115,950102,3006,3,9999,99999,99999999,9,99999,99999999,1708405,23481,0,0,23481,0,46180,01,999,99999,99999999,A,00695803,91260,N,00712037,539,6,99999,99999999,+34.3231169,-089.0798466,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000202,38841
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,28,115,950102,3006,3,9999,99999,99999999,9,99999,99999999,1708405,23481,0,0,23481,0,46180,01,999,99999,99999999,A,00695803,91260,N,00712037,539,6,99999,99999999,+34.3231169,-089.0798466,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00500,3,99999,99999,03660,015,003,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000202,38841
2,000,3,0,1,4,09,0,0,0,5,1,04,4,0,0,0,0,4,1,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,3,3,03,3,4,1,1,1,02,1,1,0,0,0,1,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,4,7,04,3,4,1,1,2,01,4,1,0,0,0,1,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,4,3,03,3,4,1,2,1,02,3,1,0,0,0,3,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,28,117,950500,2043,2,9999,99999,99999999,9,99999,99999999,805244,0,0,0,0,0,46180,01,999,99999,99999999,A,00695779,92007,N,00712043,539,6,99999,99999999,+34.5174666,-088.6620243,L,2,99999,99999,99999,9,N,N,02700,A,02403150,00200,3,99999,99999,00540,018,005,01779790,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000304,38824
2,000,2,0,7,1,01,1,5,1,4,2,07,2,1,0,0,0,2,1,1,1,31,055,002000,3016,3,9999,99999,99999999,9,99999,99999999,5300,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2339857,-095.9392476,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,2,0,4,1,01,1,5,1,3,2,06,2,1,0,0,0,2,2,1,1,31,055,002000,3016,3,9999,99999,99999999,9,99999,99999999,5300,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2339857,-095.9392476,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,2,5,04,3,2,0,2,2,01,4,0,0,0,0,4,1,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,4,3,06,5,5,1,3,2,01,2,1,0,0,0,2,2,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,4,3,06,5,5,1,3,2,01,2,1,0,0,0,2,2,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,4,3,06,5,5,1,3,2,01,2,1,0,0,0,2,2,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,1,6,05,0,0,0,3,2,07,4,0,0,0,0,4,2,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,31,055,002000,3017,3,9999,99999,99999999,9,99999,99999999,12124,0,0,0,0,0,36540,02,999,99999,99999999,A,00835849,92237,F,02396064,420,4,99999,99999999,+41.2337330,-095.9403710,L,1,99999,99999,99999,9,Y,N,37000,A,02396064,00904,2,99999,99999,74820,999,007,01779792,99999,99999999,9,999,99999,99999999,999999,65269,U,99999,U,004-02,68108
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,2,0,2,5,12,5,5,0,7,1,02,4,0,1,1,0,4,1,1,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,2,0,2,1,02,1,5,0,8,1,04,4,0,1,1,1,4,1,1,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,1,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,1,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,3,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,2,2,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,3,0,3,1,01,1,5,1,2,1,01,1,1,0,0,0,1,2,2,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,06,001,401000,6011,6,9999,99999,99999999,9,99999,99999999,15887,0,0,0,0,0,41860,13,999,99999,99999999,A,01675839,92230,S,01935228,488,9,99999,99999999,+37.8294409,-122.2717984,L,1,36084,99999,99999,9,Y,N,53000,A,02411292,00111,4,99999,99999,28050,015,009,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94608
2,000,3,0,5,1,01,1,5,1,2,2,06,2,1,0,0,0,2,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,2,1,02,1,5,0,2,2,06,4,0,0,0,0,4,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,4,1,01,1,5,1,2,2,07,2,1,0,0,0,2,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,2,2,10,5,5,0,4,1,01,2,1,0,0,0,2,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,4,1,02,1,5,1,4,1,02,4,0,0,0,0,4,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,2,2,10,5,5,0,5,1,01,2,1,0,0,0,2,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,3,0,2,2,10,5,5,0,5,1,01,2,1,0,0,0,2,1,2,1,34,005,700303,3007,3,9999,99999,99999999,9,99999,99999999,13085,0,0,0,0,0,37980,03,999,99999,99999999,A,00882272,12940,A,00882096,428,2,99999,99999999,+40.0185923,-075.0043174,L,1,15804,99999,99999,9,9,9,99999,9,99999999,02001,1,99999,99999,03120,007,007,01779795,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,040001,08077
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,11,001,000804,1011,1,9999,99999,99999999,9,99999,99999999,9327,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9248067,-077.0928228,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,2,3,06,5,5,0,2,1,02,2,1,0,0,0,2,2,1,1,11,001,000804,1011,1,9999,99999,99999999,9,99999,99999999,9327,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9248067,-077.0928228,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,2,3,06,5,5,0,5,1,02,2,1,0,0,0,2,2,1,1,11,001,000804,1011,1,9999,99999,99999999,9,99999,99999999,9327,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9248067,-077.0928228,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,11,001,000804,1011,1,9999,99999,99999999,9,99999,99999999,9327,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9248067,-077.0928228,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,11,001,000804,1011,1,9999,99999,99999999,9,99999,99999999,9327,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9248067,-077.0928228,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,11,001,000804,1012,1,9999,99999,99999999,9,99999,99999999,17862,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9197154,-077.0976346,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,1,4,09,0,0,0,3,2,02,4,0,0,0,0,4,1,1,1,11,001,000804,1012,1,9999,99999,99999999,9,99999,99999999,17862,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9197154,-077.0976346,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,5,1,01,1,5,1,3,2,07,3,1,0,0,0,3,1,1,1,11,001,000804,1012,1,9999,99999,99999999,9,99999,99999999,17862,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9197154,-077.0976346,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,1,4,09,0,0,0,5,2,01,4,0,0,0,0,4,1,1,1,11,001,000804,1012,1,9999,99999,99999999,9,99999,99999999,17862,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9197154,-077.0976346,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,1,0,1,4,09,0,0,0,5,2,01,4,0,0,0,0,4,1,1,1,11,001,000804,1012,1,9999,99999,99999999,9,99999,99999999,17862,0,0,0,0,0,47900,98,999,99999,99999999,F,01702382,50000,F,02390665,548,5,99999,99999999,+38.9197154,-077.0976346,L,1,47894,99999,99999,9,Y,N,50000,N,02390665,00101,3,99999,99999,00030,999,003,01702382,99999,99999999,9,999,99999,99999999,999999,92242,U,99999,U,02-008,20007
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,55,077,960100,2030,2,9999,99999,99999999,9,99999,99999999,1121152,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9441225,-089.2357438,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,55,077,960100,2030,2,9999,99999,99999999,9,99999,99999999,1121152,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9441225,-089.2357438,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,7,2,11,5,5,1,1,1,01,4,1,0,0,0,2,1,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,3,0,7,3,03,3,4,1,2,1,01,3,1,0,0,0,3,2,2,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,1,0,4,3,04,3,4,2,5,1,01,4,1,0,0,0,1,2,1,1,55,077,960100,2031,2,9999,99999,99999999,9,99999,99999999,1361402,0,0,0,0,0,99999,06,999,99999,99999999,A,01581098,56150,A,01583795,999,3,99999,99999999,+43.9406893,-089.2432667,L,9,99999,99999,99999,9,9,9,99999,9,99999999,01000,2,99999,99999,16440,041,014,01779806,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,003455,54960
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,115,969000,1002,1,9999,99999,99999999,9,99999,99999999,2011704,13693,0,0,13693,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7611787,-082.0153363,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,39,115,969000,1002,1,9999,99999,99999999,9,99999,99999999,2011704,13693,0,0,13693,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7611787,-082.0153363,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,1,4,1,1,1,39,115,969000,1002,1,9999,99999,99999999,9,99999,99999999,2011704,13693,0,0,13693,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7611787,-082.0153363,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,115,969000,1002,1,9999,99999,99999999,9,99999,99999999,2011704,13693,0,0,13693,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7611787,-082.0153363,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,115,969000,1002,1,9999,99999,99999999,9,99999,99999999,2011704,13693,0,0,13693,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7611787,-082.0153363,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,39,115,969000,1002,1,9999,99999,99999999,9,99999,99999999,2011704,13693,0,0,13693,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7611787,-082.0153363,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,3,2,11,5,5,1,1,1,01,4,0,1,1,1,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,3,5,12,5,5,1,3,1,01,4,1,0,0,0,2,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,3,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,5,1,01,1,5,1,3,1,02,3,1,0,0,0,3,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,2,1,02,1,5,0,3,1,02,4,0,0,0,0,4,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,1,4,09,0,0,0,3,1,04,4,0,0,0,0,4,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,3,0,1,4,09,0,0,0,3,1,04,4,0,0,0,0,4,1,2,1,01,089,010612,1006,1,9999,99999,99999999,9,99999,99999999,184740,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91674,S,00161618,290,6,99999,99999999,+34.7590733,-086.7164289,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00402,3,99999,99999,01800,025,002,01779775,99999,99999999,9,999,99999,99999999,999999,40780,U,99999,U,000078,35806
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1027,1,9999,99999,99999999,9,99999,99999999,859066,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1079777,-115.9591915,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1028,1,9999,99999,99999999,9,99999,99999999,263047,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1105065,-115.9541945,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,16,015,950202,1028,1,9999,99999,99999999,9,99999,99999999,263047,0,0,0,0,0,14260,01,999,99999,99999999,A,00395157,91173,S,01936716,147,8,99999,99999999,+44.1105065,-115.9541945,L,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,4,99999,99999,01170,008,008,01779783,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,158030,83622
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,2,2,07,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,2,2,07,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,2,2,07,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,2,2,07,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,3,1,03,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,4,1,03,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,4,1,06,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,1,4,09,0,0,0,4,2,07,4,0,0,0,0,4,1,2,1,35,001,001702,3007,3,9999,99999,99999999,9,99999,99999999,11487,0,0,0,0,0,10740,01,999,99999,99999999,A,01702363,90060,S,01937492,106,8,99999,99999999,+35.0745828,-106.6148776,L,1,99999,99999,99999,9,Y,N,02000,A,02409678,00702,4,99999,99999,00060,018,016,00897535,99999,99999999,9,999,99999,99999999,999999,01171,U,99999,U,000243,87106
2,000,3,0,2,3,06,5,5,0,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,2,3,06,5,5,0,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,2,3,06,5,5,0,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,3,3,06,5,5,1,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,3,3,06,5,5,1,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,3,3,06,5,5,1,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,4,3,06,5,5,1,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,4,3,06,5,5,1,2,1,02,1,1,0,0,0,1,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,2,3,06,5,5,0,2,1,02,2,1,0,0,0,2,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,3,0,2,3,06,5,5,0,2,1,02,2,1,0,0,0,2,2,2,1,48,113,019019,1002,1,9999,99999,99999999,9,99999,99999999,287653,0,0,0,0,0,19100,32,999,99999,99999999,A,01383842,92792,S,01939038,206,7,99999,99999999,+32.9190814,-096.7149017,L,1,19124,99999,99999,9,Y,N,19000,A,02410288,02307,3,99999,99999,37020,102,008,01779801,99999,99999999,9,999,99999,99999999,999999,22042,U,99999,U,001028,75243
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,1,1,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,5,1,02,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,18,057,111103,2004,2,9999,99999,99999999,9,99999,99999999,133956,10612,0,0,10612,0,26900,05,999,99999,99999999,A,00450356,13060,A,00453209,294,3,99999,99999999,+39.9390119,-086.2187427,B,1,99999,99999,99999,9,Y,N,10342,A,02393750,01901,2,99999,99999,01200,024,029,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,000280,46032
2,000,3,0,5,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,3,3,06,5,5,1,3,1,01,3,1,0,0,0,3,2,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,5,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,17,057,952800,3013,3,9999,99999,99999999,9,99999,99999999,42652,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6935892,-090.0044152,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,5,1,01,1,5,1,4,1,01,2,1,0,0,0,2,1,1,1,17,057,952800,3014,3,9999,99999,99999999,9,99999,99999999,36156,0,0,0,0,0,37900,17,999,99999,99999999,A,00424230,25544,A,00428993,999,3,99999,99999999,+40.6934764,-090.0011712,L,1,99999,99999,99999,9,N,N,25531,A,02394746,00100,2,99999,99999,00044,091,046,01779784,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00FA05,61531
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,05,001,480700,2020,2,9999,99999,99999999,9,99999,99999999,5425522,393796,0,0,393796,0,99999,01,999,99999,99999999,A,00063755,92085,N,00063664,999,7,99999,99999999,+34.3236954,-091.3115291,B,9,99999,99999,99999,9,9,9,99999,9,99999999,01600,3,99999,99999,00001,013,028,00068085,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000022,72042
2,000,3,0,3,5,04,4,1,1,2,1,01,4,0,0,0,0,4,1,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,3,2,04,3,2,1,5,1,01,4,0,0,0,0,4,1,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,2,5,04,3,2,0,5,1,01,4,0,0,0,0,4,1,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,2,5,04,4,1,0,8,1,01,4,0,1,1,1,4,1,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,4,3,03,3,4,1,2,1,01,2,1,0,0,0,2,2,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,4,3,03,3,4,1,2,1,01,2,1,0,0,0,2,2,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,4,3,03,3,4,1,2,1,01,2,1,0,0,0,2,2,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,4,3,03,3,4,1,2,1,01,2,1,0,0,0,2,2,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,3,0,2,3,06,5,5,0,2,1,01,2,1,0,0,0,2,2,2,1,42,037,050700,4002,4,9999,99999,99999999,9,99999,99999999,11079,0,0,0,0,0,14100,09,999,99999,99999999,A,01213665,05888,F,01215123,146,2,99999,99999999,+41.0506408,-076.2429001,L,1,99999,99999,99999,9,Y,N,05888,A,01215123,00803,1,99999,99999,03480,109,027,01779798,99999,99999999,9,999,99999,99999999,999999,08434,U,99999,U,000095,18603
2,000,2,0,1,4,09,0,0,0,9,1,01,4,0,1,1,1,4,1,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,1,4,09,0,0,0,9,1,01,4,0,1,1,1,4,1,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,2,1,02,1,5,0,9,2,06,4,0,1,1,1,4,1,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,1,0,4,3,03,3,4,1,3,1,01,3,1,0,0,0,3,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,3,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,4,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,2,7,08,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,1,0,4,1,01,1,5,1,5,2,06,2,1,0,0,0,2,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,2,3,07,5,5,0,7,1,01,4,0,1,1,0,4,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,41,005,023404,2009,2,9999,99999,99999999,9,99999,99999999,9587,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3986952,-122.2841020,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,41,005,023404,2009,2,9999,99999,99999999,9,99999,99999999,9587,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3986952,-122.2841020,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,2,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,41,005,023404,2009,2,9999,99999,99999999,9,99999,99999999,9587,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3986952,-122.2841020,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,41,005,023404,2009,2,9999,99999,99999999,9,99999,99999999,9587,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3986952,-122.2841020,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,41,005,023404,2009,2,9999,99999,99999999,9,99999,99999999,9587,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3986952,-122.2841020,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,41,005,023404,2009,2,9999,99999,99999999,9,99999,99999999,9587,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3986952,-122.2841020,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,1,0,4,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,41,005,023404,2010,2,9999,99999,99999999,9,99999,99999999,15965,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3995322,-122.2893407,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,1,0,4,1,01,1,5,1,2,1,01,1,1,0,0,0,1,1,1,1,41,005,023404,2010,2,9999,99999,99999999,9,99999,99999999,15965,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3995322,-122.2893407,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,41,005,023404,2010,2,9999,99999,99999999,9,99999,99999999,15965,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3995322,-122.2893407,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,2,1,1,41,005,023404,2010,2,9999,99999,99999999,9,99999,99999999,15965,0,0,0,0,0,38900,03,999,99999,99999999,A,01155127,92788,S,01938112,440,9,99999,99999999,+45.3995322,-122.2893407,L,1,99999,99999,99999,9,N,N,65250,A,02411809,00503,4,99999,99999,10890,052,026,01155107,99999,99999999,9,999,99999,99999999,999999,78823,U,65250,U,,97055
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,2,1,01,115,040506,2066,2,9999,99999,99999999,9,99999,99999999,332120,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6707895,-086.4185491,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,2,1,01,115,040506,2066,2,9999,99999,99999999,9,99999,99999999,332120,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6707895,-086.4185491,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,2,1,01,115,040506,2066,2,9999,99999,99999999,9,99999,99999999,332120,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6707895,-086.4185491,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,1,1,01,115,040506,2066,2,9999,99999,99999999,9,99999,99999999,332120,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6707895,-086.4185491,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,1,1,1,01,115,040506,2067,2,9999,99999,99999999,9,99999,99999999,70739,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6710243,-086.4136412,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,1,1,1,01,115,040506,2067,2,9999,99999,99999999,9,99999,99999999,70739,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6710243,-086.4136412,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,1,1,01,115,040506,2067,2,9999,99999,99999999,9,99999,99999999,70739,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6710243,-086.4136412,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,1,1,01,115,040506,2067,2,9999,99999,99999999,9,99999,99999999,70739,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6710243,-086.4136412,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,01,115,040506,2067,2,9999,99999,99999999,9,99999,99999999,70739,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6710243,-086.4136412,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,01,115,040506,2067,2,9999,99999,99999999,9,99999,99999999,70739,0,0,0,0,0,13820,03,999,99999,99999999,A,00164997,92988,S,00165946,142,6,99999,99999999,+33.6710243,-086.4136412,L,1,99999,99999,99999,9,N,N,56400,A,02407036,00900,3,99999,99999,03062,050,011,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000007,35120
2,000,1,0,3,7,04,4,3,1,2,2,01,4,0,0,0,0,4,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,5,3,06,5,5,2,2,2,06,1,1,0,0,0,1,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,4,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,4,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,2,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,3,3,06,5,5,1,3,1,02,2,1,0,0,0,2,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,2,3,06,5,5,0,3,1,07,2,1,0,0,0,2,2,1,1,04,013,422615,2013,2,9999,99999,99999999,9,99999,99999999,258442,0,0,0,0,0,38060,05,999,99999,99999999,A,00037026,92601,S,01934968,429,8,99999,99999999,+33.3999022,-111.6026623,L,1,99999,99999,99999,9,Y,N,46000,A,02411087,00101,4,99999,99999,04970,016,016,01779777,99999,99999999,9,999,99999,99999999,999999,69184,U,99999,U,000226,85208
2,000,1,0,4,1,01,1,5,1,3,1,04,2,1,0,0,0,2,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,2,1,02,1,5,0,3,1,04,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,3,06,5,5,1,3,1,04,2,1,0,0,0,2,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,2,7,04,3,4,0,3,2,01,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,4,1,01,1,5,1,3,2,07,1,1,0,0,0,1,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,06,037,920111,2002,2,9999,99999,99999999,9,99999,99999999,119498,0,0,0,0,0,31080,25,999,99999,99999999,A,00277283,92110,S,01935216,348,9,99999,99999999,+34.4559829,-118.5390324,L,1,31084,99999,99999,9,N,N,69088,A,02411819,03773,4,35970,42510,99999,038,021,01779778,99999,99999999,9,999,99999,99999999,999999,79309,U,99999,U,,91354
2,000,2,0,7,1,01,1,5,2,3,1,01,2,1,1,1,0,2,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,4,1,02,1,5,1,7,1,01,4,0,1,1,0,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,4,1,02,1,5,2,7,1,04,4,0,1,1,1,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,105,014130,1027,1,9999,99999,99999999,9,99999,99999999,29590,0,0,0,0,0,29460,09,999,99999,99999999,A,00295747,91404,S,01935790,422,5,99999,99999999,+27.9627086,-081.5998964,L,1,99999,99999,99999,9,N,N,38950,A,02404869,10504,3,99999,99999,01590,041,026,00294478,99999,99999999,9,999,99999,99999999,999999,96697,U,99999,U,000519,33859
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,5,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,13,145,120404,3021,3,9999,99999,99999999,9,99999,99999999,1703660,0,0,0,0,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6618283,-084.8568198,L,1,99999,99999,99999,9,N,N,14024,S,02812684,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000CA,31804
2,000,1,0,4,1,01,1,5,1,2,1,01,2,1,0,0,0,2,1,1,1,13,145,120404,3022,3,9999,99999,99999999,9,99999,99999999,1573333,171246,0,0,171246,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6329073,-084.8080630,B,1,99999,99999,99999,9,N,N,27064,S,02812683,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000EL,31807
2,000,1,0,4,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,13,145,120404,3022,3,9999,99999,99999999,9,99999,99999999,1573333,171246,0,0,171246,0,17980,03,999,99999,99999999,A,00326700,93288,S,01936632,194,5,99999,99999999,+32.6329073,-084.8080630,B,1,99999,99999,99999,9,N,N,27064,S,02812683,03700,3,99999,99999,02700,134,029,01705317,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000EL,31807
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,3,0,3,3,07,5,5,1,4,1,02,4,0,0,0,0,4,2,2,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,1,0,3,3,06,5,5,1,4,1,07,2,1,0,0,0,2,2,1,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,1,0,3,3,07,5,5,1,4,1,07,4,0,0,0,0,4,2,1,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,1,0,4,1,01,1,5,1,4,2,07,2,1,0,0,0,2,2,1,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,1,0,2,7,04,3,4,0,5,1,01,4,0,0,0,0,4,2,1,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,1,0,2,7,04,3,4,0,5,1,01,4,0,0,0,0,4,2,1,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,1,0,2,7,04,3,4,0,5,1,01,4,0,0,0,0,4,2,1,1,26,163,581101,4009,4,9999,99999,99999999,9,99999,99999999,164231,0,0,0,0,0,19820,12,999,99999,99999999,A,01623022,74960,F,01627097,220,3,99999,99999999,+42.2101271,-083.2081967,L,1,19804,99999,99999,9,N,N,74960,A,01627097,03206,2,99999,99999,32340,013,004,01779789,99999,99999999,9,999,99999,99999999,999999,23824,U,99999,U,163877,48195
2,000,3,0,2,7,04,3,4,0,4,1,01,4,0,0,0,0,4,2,2,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,3,1,02,1,5,1,4,1,07,4,0,1,1,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,3,1,01,1,5,1,5,1,01,2,1,0,0,0,2,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,7,04,4,3,0,5,1,01,4,0,1,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,41,015,950401,2129,2,9999,99999,99999999,9,99999,99999999,367963,0,0,0,0,0,15060,04,999,99999,99999999,A,01155129,91275,S,01938023,999,9,99999,99999999,+42.0088736,-124.2188694,L,2,99999,99999,99999,9,9,9,99999,9,99999999,09100,4,99999,99999,02310,001,001,01155107,99999,99999999,9,999,99999,99999999,999999,10621,U,99999,U,,97415
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,01,089,010903,2015,2,9999,99999,99999999,9,99999,99999999,215996,0,0,0,0,0,26620,05,999,99999,99999999,A,00161570,91467,S,00165865,290,6,99999,99999999,+34.6390675,-086.4992349,L,1,99999,99999,99999,9,Y,N,37000,A,02404746,00401,3,99999,99999,01800,020,007,01779775,99999,99999999,9,999,99999,99999999,999999,40813,U,99999,U,000061,35763
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,1,4,09,0,0,0,2,1,04,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,2,1,02,1,5,0,2,2,01,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,7,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,3,1,01,1,5,1,3,1,04,2,1,0,0,0,2,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,3,0,1,4,09,0,0,0,3,1,04,4,0,0,0,0,4,1,2,1,42,101,001201,2000,2,9999,99999,99999999,9,99999,99999999,7980,0,0,0,0,0,37980,03,999,99999,99999999,C,01209187,60000,F,01215531,428,2,99999,99999999,+39.9480822,-075.1753295,L,1,37964,99999,99999,9,Y,N,60000,A,01215531,03230,1,99999,99999,18990,182,001,01779798,99999,99999999,9,999,99999,99999999,999999,69076,U,99999,U,000802,19103
2,000,4,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,2,0,3,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,1,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,4,0,3,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,2,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,4,0,2,3,06,5,5,0,3,1,01,2,1,0,0,0,2,2,2,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,2,0,3,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,1,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,2,0,3,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,1,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,4,0,2,3,06,5,5,0,4,1,01,2,1,0,0,0,2,2,2,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,4,0,2,3,06,5,5,0,4,1,01,2,1,0,0,0,2,2,2,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,1,0,0,4,2,1,1,36,109,001901,2014,2,9999,99999,99999999,9,99999,99999999,195234,0,0,0,0,0,27060,23,999,99999,99999999,A,00974152,12606,A,00978795,296,2,99999,99999999,+42.3854507,-076.4052670,L,1,99999,99999,99999,9,N,N,10077,S,02806979,02300,1,99999,99999,15570,125,051,01779796,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,14817
2,000,3,0,5,2,10,5,5,1,1,1,07,1,1,0,0,0,1,1,2,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,1,0,2,1,02,1,5,0,2,2,07,4,0,0,0,0,4,1,1,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,1,0,2,1,02,1,5,0,2,2,07,4,0,0,0,0,4,1,1,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,1,0,2,1,02,1,5,0,2,2,07,4,0,0,0,0,4,1,1,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,1,0,2,1,02,1,5,0,3,1,01,4,0,0,0,0,4,1,1,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,1,0,3,1,01,1,5,1,3,1,04,1,1,0,0,0,1,1,1,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,3,0,4,1,01,1,5,1,3,1,04,2,1,0,0,0,2,1,2,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,3,0,4,1,01,1,5,1,3,1,04,2,1,0,0,0,2,1,2,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,3,0,4,1,01,1,5,1,3,1,04,2,1,0,0,0,2,1,2,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,1,0,3,1,02,1,5,1,3,2,06,4,0,0,0,0,4,1,1,1,34,003,045102,3007,3,9999,99999,99999999,9,99999,99999999,37615,0,0,0,0,0,35620,09,999,99999,99999999,A,00882271,62910,F,00885367,408,2,99999,99999999,+40.8316617,-074.0013756,L,1,35614,99999,99999,9,N,N,62910,A,00885367,00303,1,99999,99999,13770,036,036,01779795,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,245005,07657
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,2,1,24,013,512000,1075,1,9999,99999,99999999,9,99999,99999999,74611,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5641338,-077.1680591,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,3,0,2,1,02,1,5,0,1,1,01,4,0,0,0,0,4,2,2,1,24,013,512000,1082,1,9999,99999,99999999,9,99999,99999999,5933,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,91032,N,01929466,548,5,99999,99999999,+39.5656716,-077.1794907,L,1,99999,99999,99999,9,N,N,79350,A,02391455,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,12-001,21791
2,000,1,0,3,5,04,3,2,1,7,1,01,4,1,1,1,0,1,1,1,1,24,013,507500,2018,2,9999,99999,99999999,9,99999,99999999,112124,0,0,0,0,0,12580,08,999,99999,99999999,A,01696228,90576,N,01929683,548,5,99999,99999999,+39.5977085,-077.0023678,L,1,99999,99999,99999,9,N,N,83100,A,02390669,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,94285,U,99999,U,07-004,21158
2,000,3,0,3,1,01,1,5,1,1,1,01,1,1,0,0,0,1,1,2,1,24,013,507500,2021,2,9999,99999,99999999,9,99999,99999999,879890,1441,0,0,1441,0,12580,08,999,99999,99999999,A,01696228,90576,N,01929683,548,5,99999,99999999,+39.5897918,-077.0199313,B,1,99999,99999,99999,9,N,N,83100,A,02390669,00400,3,99999,99999,00210,005,005,01714934,99999,99999999,9,999,99999,99999999,999999,94285,U,99999,U,07-004,21158
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,1,0,4,1,02,1,5,1,9,1,01,4,0,1,1,1,4,1,1,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,1,0,4,1,02,1,5,1,9,1,01,4,0,1,1,1,4,1,1,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,3,0,1,6,05,0,0,0,2,1,01,4,0,0,0,0,4,2,2,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,3,0,2,3,06,5,5,0,2,1,07,2,1,0,0,0,2,2,2,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,3,0,2,3,06,5,5,0,2,1,07,2,1,0,0,0,2,2,2,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,1,0,3,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,18,097,341000,2003,2,9999,99999,99999999,9,99999,99999999,43039,0,0,0,0,0,26900,07,999,99999,99999999,C,00450371,81800,A,00454035,294,3,99999,99999999,+39.7892937,-086.2502015,L,1,99999,99999,99999,9,N,N,71828,A,02397670,02404,2,99999,99999,10920,092,035,00448508,99999,99999999,9,999,99999,99999999,999999,41212,U,99999,U,005680,46224
2,000,3,0,3,3,06,5,5,1,2,1,01,2,1,0,0,0,2,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,2,3,06,5,5,0,3,1,01,2,1,0,0,0,2,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,2,3,06,5,5,0,3,1,01,2,1,0,0,0,2,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,3,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,3,7,08,5,5,1,3,1,01,4,1,0,0,0,2,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,3,3,07,5,5,1,6,1,01,4,0,1,1,0,4,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,2,3,07,5,5,0,7,1,01,4,0,1,1,0,4,2,2,1,08,083,969400,2042,2,9999,99999,99999999,9,99999,99999999,6577,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3438916,-108.5860960,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,1,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,01,117,030900,1041,1,9999,99999,99999999,9,99999,99999999,236288,945,0,0,945,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4527266,-086.4923285,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,01,117,030900,1041,1,9999,99999,99999999,9,99999,99999999,236288,945,0,0,945,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4527266,-086.4923285,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,01,117,030900,1041,1,9999,99999,99999999,9,99999,99999999,236288,945,0,0,945,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4527266,-086.4923285,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,2,0,4,3,07,5,5,2,4,1,01,4,1,0,0,0,1,2,1,1,01,117,030900,1041,1,9999,99999,99999999,9,99999,99999999,236288,945,0,0,945,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4527266,-086.4923285,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,2,0,4,3,07,5,5,2,7,1,01,4,1,1,1,0,2,2,1,1,01,117,030900,1041,1,9999,99999,99999999,9,99999,99999999,236288,945,0,0,945,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4527266,-086.4923285,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,2,0,4,3,07,5,5,2,8,1,01,4,1,1,1,1,1,2,1,1,01,117,030900,1041,1,9999,99999,99999999,9,99999,99999999,236288,945,0,0,945,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4527266,-086.4923285,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,3,0,3,2,03,3,2,1,1,1,01,1,1,0,0,0,1,1,2,1,01,117,030900,1042,1,9999,99999,99999999,9,99999,99999999,9277319,128291,0,0,128291,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4352347,-086.5001117,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,1,0,4,2,03,3,2,1,2,1,01,3,1,0,0,0,3,1,1,1,01,117,030900,1042,1,9999,99999,99999999,9,99999,99999999,9277319,128291,0,0,128291,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4352347,-086.5001117,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,3,0,3,2,03,3,2,1,2,1,01,1,1,0,0,0,1,1,2,1,01,117,030900,1042,1,9999,99999,99999999,9,99999,99999999,9277319,128291,0,0,128291,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4352347,-086.5001117,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,01,117,030900,1042,1,9999,99999,99999999,9,99999,99999999,9277319,128291,0,0,128291,0,13820,06,999,99999,99999999,A,00161584,90558,S,00165949,142,6,99999,99999999,+33.4352347,-086.5001117,B,1,99999,99999,99999,9,N,N,73056,S,02582702,01501,3,99999,99999,03030,045,015,01779775,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000003,35147
2,000,3,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,2,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,3,0,2,1,02,2,5,0,3,1,01,4,0,0,0,0,4,2,2,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,3,0,4,1,01,1,5,1,4,1,01,2,1,0,0,0,2,2,2,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,3,0,5,3,03,3,4,2,4,1,01,2,1,0,0,0,3,2,2,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,3,0,2,7,04,3,4,0,4,1,01,4,0,0,0,0,4,2,2,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,2,0,2,7,04,3,4,0,4,1,01,4,0,1,1,0,4,2,1,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,3,0,2,3,07,5,5,0,5,2,07,4,0,0,0,0,4,2,2,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,2,0,2,7,04,3,4,0,6,1,01,4,0,1,0,0,4,2,1,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,2,0,2,7,04,3,4,0,6,1,01,4,0,1,0,0,4,2,1,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,2,0,2,7,04,3,4,0,7,1,01,4,0,1,1,0,4,2,1,1,19,113,000103,1009,1,9999,99999,99999999,9,99999,99999999,404861,0,0,0,0,0,16300,01,999,99999,99999999,A,00465245,92859,G,00468355,168,4,99999,99999999,+42.0313846,-091.5678350,L,1,99999,99999,99999,9,N,N,49485,A,02395011,00301,2,99999,99999,17220,068,034,01779785,99999,99999999,9,999,99999,99999999,999999,14752,U,99999,U,113160,52302
2,000,1,0,3,1,01,1,5,1,1,1,01,1,1,0,0,0,1,2,1,1,29,147,470500,1089,1,9999,99999,99999999,9,99999,99999999,43826,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3497192,-094.6688669,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,5,1,01,1,5,1,3,1,07,2,1,0,0,0,2,2,2,1,29,147,470500,1089,1,9999,99999,99999999,9,99999,99999999,43826,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3497192,-094.6688669,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,2,7,04,3,4,0,1,1,01,4,0,0,0,0,4,2,2,1,29,147,470500,1090,1,9999,99999,99999999,9,99999,99999999,7446,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3500471,-094.6671023,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,1,0,5,3,06,5,5,1,2,1,01,2,1,0,0,0,2,2,1,1,29,147,470500,1090,1,9999,99999,99999999,9,99999,99999999,7446,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3500471,-094.6671023,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,1,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,2,1,1,29,147,470500,1090,1,9999,99999,99999999,9,99999,99999999,7446,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3500471,-094.6671023,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,1,0,5,3,06,5,5,1,3,1,01,2,1,0,0,0,2,2,1,1,29,147,470500,1090,1,9999,99999,99999999,9,99999,99999999,7446,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3500471,-094.6671023,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,3,3,03,3,4,1,4,1,01,2,1,0,0,0,2,2,2,1,29,147,470500,1090,1,9999,99999,99999999,9,99999,99999999,7446,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3500471,-094.6671023,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,6,3,07,5,5,1,6,1,01,4,1,1,0,0,1,2,2,1,29,147,470500,1090,1,9999,99999,99999999,9,99999,99999999,7446,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3500471,-094.6671023,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,4,1,01,1,5,1,2,1,01,3,1,0,0,0,3,2,2,1,29,147,470500,1091,1,9999,99999,99999999,9,99999,99999999,13421,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3496785,-094.6714637,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,1,6,05,0,0,0,4,1,01,4,0,0,0,0,4,2,2,1,29,147,470500,1091,1,9999,99999,99999999,9,99999,99999999,13421,0,0,0,0,0,32340,06,999,99999,99999999,A,00758528,35954,A,00767090,999,4,99999,99999999,+40.3496785,-094.6714637,L,2,99999,99999,99999,9,N,N,60716,A,02396869,00100,2,99999,99999,21660,001,012,01779791,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,000008,64479
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,3,0,1,6,05,0,0,0,3,1,01,4,0,0,0,0,4,2,2,1,06,075,012802,1004,1,9999,99999,99999999,9,99999,99999999,13839,0,0,0,0,0,41860,12,999,99999,99999999,C,00277302,92605,S,02804911,488,9,99999,99999999,+37.7990575,-122.4384225,L,1,41884,99999,99999,9,Y,N,67000,A,02411786,07514,4,99999,99999,34410,019,011,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94123
2,000,2,0,2,3,07,5,5,0,5,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,3,1,02,1,5,1,7,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,2,3,07,5,5,0,7,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,3,1,02,1,5,1,8,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,3,1,02,1,5,1,8,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,2,3,07,5,5,0,8,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,2,3,07,5,5,0,8,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,2,3,07,5,5,0,8,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,2,0,2,3,07,5,5,0,8,1,01,4,0,1,1,1,4,2,1,1,39,093,080101,2016,2,9999,99999,99999999,9,99999,99999999,17625,0,0,0,0,0,17460,07,999,99999,99999999,A,01074059,56966,F,01086515,184,3,99999,99999999,+41.4053976,-081.9875022,L,1,99999,99999,99999,9,N,N,56966,A,01086515,00602,2,99999,99999,04453,057,013,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,047AHG,44039
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,23,031,005400,2007,2,9999,99999,99999999,9,99999,99999999,20160,0,0,0,0,0,38860,01,775,99999,99999999,A,00581301,64675,F,00582705,438,1,99999,99999999,+43.4948227,-070.4216797,L,1,99999,99999,76750,1,N,N,64675,A,00582705,00900,1,99999,99999,10380,014,031,01779787,99999,99999999,9,999,99999,99999999,999999,71263,U,99999,U,646754,04072
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,23,031,005400,2007,2,9999,99999,99999999,9,99999,99999999,20160,0,0,0,0,0,38860,01,775,99999,99999999,A,00581301,64675,F,00582705,438,1,99999,99999999,+43.4948227,-070.4216797,L,1,99999,99999,76750,1,N,N,64675,A,00582705,00900,1,99999,99999,10380,014,031,01779787,99999,99999999,9,999,99999,99999999,999999,71263,U,99999,U,646754,04072
2,000,0,1,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,23,031,005400,2007,2,9999,99999,99999999,9,99999,99999999,20160,0,0,0,0,0,38860,01,775,99999,99999999,A,00581301,64675,F,00582705,438,1,99999,99999999,+43.4948227,-070.4216797,L,1,99999,99999,76750,1,N,N,64675,A,00582705,00900,1,99999,99999,10380,014,031,01779787,99999,99999999,9,999,99999,99999999,999999,71263,U,99999,U,646754,04072
2,000,2,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,2,0,1,6,05,0,0,0,8,1,01,4,0,1,1,1,4,2,1,1,39,049,007427,3004,3,9999,99999,99999999,9,99999,99999999,11749,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0141567,-082.8595485,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,39,049,007427,3005,3,9999,99999,99999999,9,99999,99999999,137581,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0135597,-082.8574893,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,39,049,007427,3005,3,9999,99999,99999999,9,99999,99999999,137581,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0135597,-082.8574893,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,1,0,5,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,39,049,007427,3005,3,9999,99999,99999999,9,99999,99999999,137581,0,0,0,0,0,18140,03,999,99999,99999999,A,01074037,50064,A,01086108,198,3,99999,99999999,+40.0135597,-082.8574893,L,1,99999,99999,99999,9,N,N,29106,A,02394837,03401,2,99999,99999,04696,019,003,01085497,99999,99999999,9,999,99999,99999999,999999,19234,U,99999,U,025ASJ,43230
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,38,079,941800,2016,2,4345,80020,01934334,R,99999,99999999,3865986,29581,0,0,29581,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8132525,-099.7767176,B,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,A,999,99999,99999999,T00200,99999,9,99999,R,000903,58316
2,000,4,0,1,6,05,0,0,0,2,1,03,4,0,0,0,0,4,2,2,1,38,079,941800,2017,2,4345,80020,01934334,R,99999,99999999,351531,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8275552,-099.7854347,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,B,999,99999,99999999,T00100,99999,9,99999,R,000903,58316
2,000,4,0,1,6,05,0,0,0,7,1,03,4,0,1,1,0,4,2,2,1,38,079,941800,2017,2,4345,80020,01934334,R,99999,99999999,351531,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8275552,-099.7854347,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,B,999,99999,99999999,T00100,99999,9,99999,R,000903,58316
2,000,2,0,4,1,01,1,5,1,3,1,03,2,1,0,0,0,2,1,1,1,38,079,941800,2018,2,4345,80020,01934334,R,99999,99999999,1243640,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8163019,-099.8228021,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,B,999,99999,99999999,T00100,99999,9,99999,R,000903,58316
2,000,2,0,5,1,01,1,5,1,3,1,03,2,1,0,0,0,2,1,1,1,38,079,941800,2018,2,4345,80020,01934334,R,99999,99999999,1243640,0,0,0,0,0,99999,00,999,99999,99999999,A,01034228,80010,S,01036301,999,4,99999,99999999,+48.8163019,-099.8228021,L,9,99999,99999,99999,9,N,N,72250,S,02393232,00400,2,99999,99999,02530,009,009,01779797,99999,99999999,B,999,99999,99999999,T00100,99999,9,99999,R,000903,58316
2,000,2,0,2,7,08,5,5,0,7,1,01,4,0,1,1,0,4,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,2,7,08,5,5,0,7,1,01,4,0,1,1,0,4,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,06,071,002015,2002,2,9999,99999,99999999,9,99999,99999999,96009,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1308059,-117.6147395,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,1,0,4,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,1,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,1,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,1,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,1,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,1,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,3,0,5,1,01,1,5,1,2,1,01,3,1,0,0,0,3,1,2,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,3,0,1,4,09,0,0,0,2,1,02,4,0,0,0,0,4,1,2,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,2,0,6,1,01,1,5,2,2,1,04,1,1,1,1,0,1,1,1,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,3,0,4,1,01,1,5,1,2,2,01,1,1,0,0,0,1,1,2,1,06,071,002015,2003,2,9999,99999,99999999,9,99999,99999999,147703,0,0,0,0,0,40140,31,999,99999,99999999,A,00277300,92260,S,01935231,348,9,99999,99999999,+34.1300175,-117.6084050,L,1,99999,99999,99999,9,N,N,59451,A,02411514,07111,4,02160,08160,99999,040,023,01779778,99999,99999999,9,999,99999,99999999,999999,51445,U,99999,U,,91701
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,1,6,05,0,0,0,6,1,01,4,0,1,0,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,1,0,4,3,07,5,5,2,7,1,01,4,0,1,1,0,4,2,1,1,17,111,870502,3029,3,9999,99999,99999999,9,99999,99999999,22944,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.3922487,-088.3420457,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc19,60097
2,000,2,0,1,4,09,0,0,0,7,2,07,4,0,1,1,0,4,1,1,1,17,111,870502,4000,4,9999,99999,99999999,9,99999,99999999,71548,0,0,0,0,0,16980,14,999,99999,99999999,A,01784815,45707,A,00429300,176,3,99999,99999999,+42.4120265,-088.3392624,L,1,16984,99999,99999,9,9,9,99999,9,99999999,11102,2,18360,25320,99999,063,032,01779784,99999,99999999,9,999,99999,99999999,999999,52623,U,99999,U,00Mc08,60097
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1006,1,5620,18170,01925077,R,99999,99999999,54784,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7479060,-095.3347816,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1007,1,5620,18170,01925077,R,99999,99999999,18300,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7488971,-095.3332966,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,40,101,000801,1007,1,5620,18170,01925077,R,99999,99999999,18300,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7488971,-095.3332966,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,1,1,40,101,000801,1007,1,5620,18170,01925077,R,99999,99999999,18300,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7488971,-095.3332966,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,1,6,05,0,0,0,9,1,01,4,0,1,1,1,4,2,1,1,40,101,000801,1007,1,5620,18170,01925077,R,99999,99999999,18300,0,0,0,0,0,34780,02,999,99999,99999999,A,01101838,91924,S,01937776,538,7,99999,99999999,+35.7488971,-095.3332966,L,2,99999,99999,99999,9,Y,N,50050,A,02411201,20700,3,99999,99999,20970,014,009,01102857,99999,99999999,9,999,99999,99999999,999999,60868,U,99999,U,000007,74403
2,000,2,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,2,0,1,4,09,0,0,0,7,1,01,4,0,1,1,0,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,4,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,4,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,4,0,2,5,04,3,2,0,7,1,01,4,0,1,1,0,4,1,2,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,2,0,1,4,09,0,0,0,9,1,01,4,0,1,1,1,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,2,0,1,4,09,0,0,0,9,1,01,4,0,1,1,1,4,1,1,1,06,041,120002,3004,3,9999,99999,99999999,9,99999,99999999,21088,0,0,0,0,0,41860,02,999,99999,99999999,A,00277285,92670,S,01935272,488,9,99999,99999999,+37.9372207,-122.5365394,L,1,42034,99999,99999,9,N,N,40438,A,02411627,04104,4,20910,38790,99999,010,002,01779778,99999,99999999,9,999,99999,99999999,999999,78904,U,99999,U,,94939
2,000,1,0,5,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,5,1,01,1,5,1,3,1,01,1,1,0,0,0,1,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,3,1,02,1,5,1,3,1,01,4,0,0,0,0,4,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,3,3,07,5,5,1,3,1,01,4,0,0,0,0,4,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,3,3,07,5,5,1,3,1,01,4,0,0,0,0,4,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,3,3,06,5,5,1,3,1,02,1,1,0,0,0,1,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,3,1,02,1,5,1,4,1,01,4,0,0,0,0,4,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,2,0,3,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,2,0,3,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,1,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,1,1,22,061,961000,4014,4,9999,99999,99999999,9,99999,99999999,1996074,23164,0,0,23164,0,40820,05,999,99999,99999999,A,00558077,95577,N,02405103,384,7,99999,99999999,+32.4688134,-092.6944996,B,2,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,00990,011,035,01629543,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0002-2,71270
2,000,3,0,3,1,01,1,5,1,2,1,01,2,1,0,0,0,2,1,2,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,3,0,5,2,11,5,5,1,2,1,02,4,0,0,0,0,4,1,2,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,3,0,2,2,11,5,5,0,2,1,07,4,1,0,0,0,2,1,2,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,4,5,12,5,5,1,3,1,01,4,1,0,0,0,2,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,2,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,2,0,4,1,01,1,5,1,3,1,01,2,1,0,0,0,2,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,2,0,4,1,01,1,5,1,3,1,01,3,1,0,0,0,3,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,3,0,7,2,10,5,5,1,3,1,01,3,1,0,0,0,3,1,2,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,1,0,4,1,01,1,5,1,3,1,07,3,1,0,0,0,3,1,1,1,26,121,003702,2001,2,9999,99999,99999999,9,99999,99999999,330674,0,0,0,0,0,34740,02,999,99999,99999999,A,01623003,86780,F,01627262,266,3,99999,99999999,+43.4066463,-086.3297275,L,1,99999,99999,99999,9,N,N,86780,A,01627262,00700,2,99999,99999,36300,091,034,01779789,99999,99999999,9,999,99999,99999999,999999,94807,U,99999,U,121065,49461
2,000,0,4,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1086,1,9999,99999,99999999,9,99999,99999999,1752096,3406,0,0,3406,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8974133,-088.9228503,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B101,42023
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1086,1,9999,99999,99999999,9,99999,99999999,1752096,3406,0,0,3406,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8974133,-088.9228503,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B101,42023
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1086,1,9999,99999,99999999,9,99999,99999999,1752096,3406,0,0,3406,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8974133,-088.9228503,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B101,42023
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,21,039,960100,1087,1,9999,99999,99999999,9,99999,99999999,217084,1817,0,0,1817,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8952189,-088.9330136,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B101,42023
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1088,1,9999,99999,99999999,9,99999,99999999,226238,2679,0,0,2679,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8832546,-088.8790390,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B102,42023
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1088,1,9999,99999,99999999,9,99999,99999999,226238,2679,0,0,2679,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8832546,-088.8790390,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B102,42023
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1088,1,9999,99999,99999999,9,99999,99999999,226238,2679,0,0,2679,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8832546,-088.8790390,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B102,42023
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1088,1,9999,99999,99999999,9,99999,99999999,226238,2679,0,0,2679,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8832546,-088.8790390,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B102,42023
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,21,039,960100,1088,1,9999,99999,99999999,9,99999,99999999,226238,2679,0,0,2679,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8832546,-088.8790390,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B102,42023
2,000,1,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,1,1,21,039,960100,1089,1,9999,99999,99999999,9,99999,99999999,5862718,71647,0,0,71647,0,99999,01,999,99999,99999999,A,00516866,90968,S,01936966,999,6,99999,99999999,+36.8691314,-088.8799478,B,9,99999,99999,99999,9,9,9,99999,9,99999999,00100,3,99999,99999,00960,001,002,01779786,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,00B102,42023
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,1,1,0,4,1,1,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,5,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,5,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,5,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,5,1,02,4,0,0,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,2,5,12,5,5,0,6,1,01,4,0,1,0,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,7,2,06,4,0,1,1,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,7,2,06,4,0,1,1,0,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,1,4,09,0,0,0,9,2,06,4,0,1,1,1,4,1,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,3,3,06,5,5,1,2,1,07,3,1,0,0,0,3,2,2,1,39,035,124600,1002,1,9999,99999,99999999,9,99999,99999999,35826,0,0,0,0,0,17460,09,999,99999,99999999,A,01074030,16000,F,01085963,184,3,99999,99999999,+41.4287292,-081.7824865,L,1,99999,99999,99999,9,Y,N,16000,A,01085963,00703,2,99999,99999,04378,014,023,01085497,99999,99999999,9,999,99999,99999999,999999,17668,U,99999,U,018BHQ,44135
2,000,3,0,5,3,03,3,4,1,3,2,06,3,1,0,0,0,3,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,5,1,01,1,5,1,3,2,07,2,1,0,0,0,2,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,3,3,06,5,5,1,4,1,01,2,1,0,0,0,2,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,3,3,06,5,5,1,4,2,02,2,1,0,0,0,2,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,1,0,4,1,02,1,5,1,4,2,07,4,0,0,0,0,4,2,1,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,1,6,05,0,0,0,5,1,01,4,0,0,0,0,4,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,3,3,07,5,5,1,5,1,02,4,1,0,0,0,2,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,3,3,07,5,5,1,5,1,02,4,0,0,0,0,4,2,2,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,1,0,2,1,02,1,5,0,8,1,06,4,0,1,1,1,4,2,1,1,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
4,301,0,0,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,0,36,059,412400,2005,2,9999,99999,99999999,9,99999,99999999,33455,0,0,0,0,0,35620,04,999,99999,99999999,A,00974128,34000,A,00979061,408,2,99999,99999999,+40.6581258,-073.6344860,L,1,35004,99999,99999,9,N,N,63264,A,02391098,03210,1,99999,99999,24780,021,009,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,000526,11570
2,000,3,0,3,2,03,3,2,1,1,2,01,2,1,0,0,0,2,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,2,5,12,5,5,0,1,2,01,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,3,1,01,1,5,1,1,2,06,1,1,0,0,0,1,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,3,1,01,1,5,1,1,2,06,1,1,0,0,0,1,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,3,1,01,1,5,1,1,2,06,1,1,0,0,0,1,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,3,2,03,3,2,1,1,2,06,1,1,0,0,0,1,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,2,5,04,3,2,0,1,2,06,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,2,5,04,3,2,0,1,2,06,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,4,2,11,5,5,1,1,2,06,4,1,0,0,0,2,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,1,4,09,0,0,0,1,2,07,4,0,0,0,0,4,1,2,1,48,201,542401,2000,2,9999,99999,99999999,9,99999,99999999,171224,0,0,0,0,0,26420,10,999,99999,99999999,A,01383886,91835,S,01938848,288,7,99999,99999999,+29.7934402,-095.7268558,L,1,99999,99999,99999,9,9,9,99999,9,99999999,04635,3,99999,99999,25170,132,017,01779801,99999,99999999,9,999,99999,99999999,999999,40429,U,99999,U,000731,77449
2,000,3,0,3,1,01,1,5,1,2,1,04,2,1,0,0,0,2,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,1,02,1,5,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,3,0,2,7,04,3,4,0,2,1,04,4,0,0,0,0,4,2,2,1,06,073,008363,4000,4,9999,99999,99999999,9,99999,99999999,49690,0,0,0,0,0,41740,52,999,99999,99999999,A,00277301,92780,S,01935283,999,9,99999,99999999,+32.8671902,-117.2237025,L,1,99999,99999,99999,9,Y,N,66000,A,02411782,07312,4,99999,99999,34320,078,039,01779778,99999,99999999,9,999,99999,99999999,999999,78661,U,99999,U,,92122
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,4,3,04,4,3,1,4,1,01,4,0,0,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,3,1,02,1,5,1,4,1,04,4,0,1,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,4,1,01,1,5,1,4,2,07,2,1,0,0,0,2,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,3,1,02,1,5,1,5,1,02,4,0,0,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,3,1,02,1,5,1,5,1,04,4,0,0,0,0,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,1,0,2,7,04,3,4,0,8,1,01,4,0,1,1,1,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,2,1,1,12,011,010609,1004,1,9999,99999,99999999,9,99999,99999999,8882,0,0,0,0,0,33100,22,999,99999,99999999,A,00295753,90806,S,01935743,370,5,99999,99999999,+26.3127776,-080.2008429,L,1,22744,99999,99999,9,N,N,13275,A,02404091,01101,3,99999,99999,00180,096,029,00294478,99999,99999999,9,999,99999,99999999,999999,56602,U,99999,U,00F007,33073
2,000,3,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,2,11,5,5,0,7,1,01,4,0,1,1,0,4,1,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,2,0,2,1,02,1,5,0,8,1,01,4,0,1,1,1,4,1,1,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,2,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,1,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,2,3,07,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,1,6,05,0,0,0,2,1,04,4,0,0,0,0,4,2,2,1,12,031,014408,3010,3,9999,99999,99999999,9,99999,99999999,38476,0,0,0,0,0,27260,04,999,99999,99999999,C,00293656,91642,S,02583397,300,5,99999,99999999,+30.2733116,-081.4357696,L,1,99999,99999,99999,9,Y,N,35000,A,02404783,03106,3,99999,99999,00480,011,004,00294478,99999,99999999,9,999,99999,99999999,999999,42346,U,99999,U,000056,32250
2,000,3,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,9,1,04,4,0,1,1,1,4,1,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,1,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,1,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,1,6,05,0,0,0,1,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,1,02,1,5,0,2,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,3,0,2,7,08,5,5,0,2,1,01,4,0,0,0,0,4,2,2,1,25,009,217602,2004,2,9999,99999,99999999,9,99999,99999999,92700,0,0,0,0,0,14460,06,715,99999,99999999,N,00606931,05595,F,00618293,148,1,99999,99999999,+42.5644225,-070.8155370,L,1,15764,76524,71650,1,N,N,05595,A,00618293,00706,1,99999,99999,02640,088,021,00606926,99999,99999999,9,999,99999,99999999,999999,09271,U,99999,U,000158,01915
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,0,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,6,1,01,4,0,1,1,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,1,4,09,0,0,0,6,1,02,4,0,1,0,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,26,087,332000,4018,4,9999,99999,99999999,9,99999,99999999,1937129,50517,0,0,50517,0,19820,10,999,99999,99999999,A,01622986,21160,A,01626169,220,3,99999,99999999,+43.1845031,-083.3261680,B,1,47664,99999,99999,9,N,N,54132,S,02804671,01701,2,99999,99999,25680,082,031,01779789,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,087009,48421
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,47,157,011300,1030,1,9999,99999,99999999,9,99999,99999999,13378,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91488,N,02772132,368,6,99999,99999999,+35.1473677,-090.0357870,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,088,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008110,38105
2,000,3,0,2,2,11,5,5,0,1,1,02,4,0,0,0,0,4,1,2,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,3,0,4,2,11,5,5,1,2,1,01,4,0,0,0,0,4,1,2,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,1,0,2,1,02,1,5,0,2,1,02,4,0,0,0,0,4,1,1,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,1,0,1,4,09,0,0,0,2,1,02,4,0,0,0,0,4,1,1,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,1,0,1,4,09,0,0,0,2,1,02,4,0,0,0,0,4,1,1,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,3,0,5,2,11,5,5,1,2,1,02,4,1,0,0,0,3,1,2,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,3,0,2,2,11,5,5,0,2,1,02,4,0,0,0,0,4,1,2,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,3,0,2,2,11,5,5,0,2,1,02,4,0,1,1,0,4,1,2,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,3,0,2,2,11,5,5,0,2,1,02,4,0,1,1,0,4,1,2,1,47,157,011200,1000,1,9999,99999,99999999,9,99999,99999999,171934,0,0,0,0,0,32820,09,999,99999,99999999,A,01639790,91298,N,02772131,368,6,99999,99999999,+35.1686963,-090.0155595,L,1,99999,99999,99999,9,Y,N,48000,A,02405068,02501,3,99999,99999,00148,090,030,01325873,99999,99999999,9,999,99999,99999999,999999,56116,U,99999,U,008123,38107
2,000,3,0,2,1,02,1,5,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,2,1,02,1,5,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,2,1,02,1,5,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,4,3,03,3,4,1,4,1,02,2,1,0,0,0,2,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,2,7,04,3,4,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,2,7,04,3,4,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,2,7,04,3,4,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,1,6,05,0,0,0,4,1,02,4,0,0,0,0,4,2,2,1,05,119,002102,3009,3,9999,99999,99999999,9,99999,99999999,473511,0,0,0,0,0,30780,02,999,99999,99999999,A,00069177,90300,N,00069013,340,7,99999,99999999,+34.7205759,-092.3467261,L,1,99999,99999,99999,9,Y,N,41000,A,02404939,01502,3,99999,99999,09000,034,031,00068085,99999,99999999,9,999,99999,99999999,999999,50392,U,99999,U,000099,72204
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,6,05,0,0,0,3,1,02,4,0,0,0,0,4,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,2,3,06,5,5,0,3,1,02,1,1,0,0,0,1,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,5,3,06,5,5,2,3,1,02,2,1,1,0,0,2,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,3,3,06,5,5,2,3,1,02,2,1,1,1,0,2,2,2,1,36,047,026700,2001,2,9999,99999,99999999,9,99999,99999999,19969,0,0,0,0,0,35620,08,999,99999,99999999,C,00974122,10022,G,00978759,408,2,99999,99999999,+40.6841762,-073.9455277,L,1,35614,99999,99999,9,Y,N,51000,A,02395220,04303,1,99999,99999,20580,056,025,01779796,99999,99999999,9,999,99999,99999999,999999,63217,U,99999,U,001390,11216
2,000,3,0,1,4,09,0,0,0,2,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,2,2,11,5,5,0,3,1,03,4,0,1,1,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,2,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,3,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,2,1,08,083,969400,2043,2,9999,99999,99999999,9,99999,99999999,53263,0,0,0,0,0,99999,03,999,99999,99999999,A,00198157,90817,S,01935434,999,8,99999,99999999,+37.3434258,-108.5811196,L,9,99999,99999,99999,9,N,N,17375,A,02410236,02200,4,99999,99999,03090,058,006,01779779,99999,99999999,9,999,99999,99999999,999999,20368,U,99999,U,083010,81321
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,1,4,09,0,0,0,4,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,2,0,1,4,09,0,0,0,5,1,01,4,0,0,0,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,1,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,1,1,39,115,969000,1003,1,9999,99999,99999999,9,99999,99999999,4531344,14344,0,0,14344,0,99999,15,999,99999,99999999,A,01074070,87066,A,01086696,999,3,99999,99999999,+39.7518018,-082.0330320,B,9,99999,99999,99999,9,9,9,99999,9,99999999,03100,2,99999,99999,04877,078,020,01085497,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,058AAW,43731
2,000,3,0,1,4,09,0,0,0,3,1,01,4,0,0,0,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,2,1,02,1,5,0,4,1,01,4,0,0,0,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,1,4,09,0,0,0,6,1,01,4,0,1,0,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,2,1,02,1,5,0,7,1,01,4,0,1,1,0,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,3,5,12,5,5,1,7,2,06,4,0,1,1,1,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,3,0,1,4,09,0,0,0,8,1,01,4,0,1,1,1,4,1,2,1,37,157,041002,3025,3,9999,99999,99999999,9,99999,99999999,1454699,4556,0,0,4556,0,24660,06,999,99999,99999999,A,01008582,92232,N,01027134,268,5,99999,99999999,+36.2652228,-079.9196299,B,1,99999,99999,99999,9,9,9,99999,9,99999999,00300,3,99999,99999,03990,065,030,01027616,99999,99999999,9,999,99999,99999999,999999,99999,9,99999,R,0000NB,27357
2,000,1,0,2,3,07,5,5,0,4,1,01,4,0,0,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,5,1,01,4,0,0,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,5,1,01,4,0,0,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,4,1,02,1,5,1,5,1,01,4,0,1,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,2,3,07,5,5,0,6,1,01,4,0,1,0,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,4,1,02,1,5,1,7,1,01,4,0,1,1,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,1,0,1,6,05,0,0,0,7,1,01,4,0,1,1,0,4,2,1,1,33,017,084301,3022,3,9999,99999,99999999,9,99999,99999999,17090,0,0,0,0,0,14460,01,999,99999,99999999,A,00873182,65140,F,00873708,148,1,99999,99999999,+43.2972420,-070.9735499,L,1,40484,99999,73050,1,N,N,65140,A,00873708,00301,1,99999,99999,05940,809,006,01779794,99999,99999999,9,999,99999,99999999,999999,24607,U,99999,U,ROCH02,03867
2,000,3,0,3,3,07,5,5,1,7,1,02,4,0,1,1,0,4,2,2,1,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,3,0,3,3,07,5,5,1,7,1,02,4,0,1,1,0,4,2,2,1,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,3,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,0,7,0,0,00,0,0,0,0,0,00,0,0,0,0,0,0,0,0,2,51,700,030600,2021,2,9999,99999,99999999,9,99999,99999999,21167,0,0,0,0,0,47260,03,999,99999,99999999,F,01498555,94851,F,01498555,545,5,99999,99999999,+36.9889186,-076.4172995,L,1,99999,99999,99999,9,Y,N,56000,A,01498555,70000,3,99999,99999,02640,095,002,01779803,99999,99999999,9,999,99999,99999999,999999,90892,U,99999,U,000307,23607
2,000,1,0,4,1,02,1,5,2,4,1,04,4,0,1,1,1,4,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,1,0,3,1,01,1,5,1,4,1,07,2,1,0,0,0,2,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,1,0,6,1,01,1,5,1,4,2,07,3,1,0,0,0,3,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,1,0,6,1,01,1,5,1,4,2,07,3,1,0,0,0,3,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,1,0,2,1,02,1,5,0,5,1,01,4,0,0,0,0,4,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,1,0,3,1,02,1,5,1,5,1,01,4,0,0,0,0,4,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
2,000,2,0,4,1,01,1,5,1,5,1,01,2,1,0,0,0,2,1,1,1,06,085,502703,1002,1,9999,99999,99999999,9,99999,99999999,80471,0,0,0,0,0,41940,18,999,99999,99999999,A,00277307,92830,S,01935288,488,9,99999,99999999,+37.2643881,-121.9462675,L,1,99999,99999,99999,9,N,N,10345,A,02409971,08511,4,07140,07230,99999,028,015,01779778,99999,99999999,9,999,99999,99999999,999999,79039,U,99999,U,,95008
)";
