#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        self.env["runtime"]["HelpManager"].toggle_tutorial_mode()
        return _(
            "Exiting tutorial mode. To enter tutorial mode again press Fenrir+f1"
        )

    def run(self):
        self.env["runtime"]["HelpManager"].toggle_tutorial_mode()
        if self.env["runtime"]["HelpManager"].is_tutorial_mode():
            self.env["runtime"]["OutputManager"].present_text(
                _(
                    "Entering tutorial mode. In this mode commands are described but not "
                    "executed. You can move through the list of commands with the up and "
                    "down arrow keys. To Exit tutorial mode press Fenrir+f1."
                ),
                interrupt=True,
            )

    def set_callback(self, callback):
        pass
