#ifndef __al_included_allegro5_aintern_primitives_types_h
#define __al_included_allegro5_aintern_primitives_types_h

/* Enum: ALLEGRO_VERTEX_CACHE_SIZE
 */
#define ALLEGRO_VERTEX_CACHE_SIZE 256

/* Enum: ALLEGRO_PRIM_TYPE
 */
typedef enum ALLEGRO_PRIM_TYPE
{
  ALLEGRO_PRIM_LINE_LIST,
  ALLEGRO_PRIM_LINE_STRIP,
  ALLEGRO_PRIM_LINE_LOOP,
  ALLEGRO_PRIM_TRIANGLE_LIST,
  ALLEGRO_PRIM_TRIANGLE_STRIP,
  ALLEGRO_PRIM_TRIANGLE_FAN,
  ALLEGRO_PRIM_POINT_LIST,
  ALLEGRO_PRIM_NUM_TYPES
} ALLEGRO_PRIM_TYPE;

enum
{
   ALLEGRO_PRIM_MAX_USER_ATTR = 10
};

/* Enum: ALLEGRO_PRIM_ATTR
 */
typedef enum ALLEGRO_PRIM_ATTR
{
   ALLEGRO_PRIM_POSITION = 1,
   ALLEGRO_PRIM_COLOR_ATTR,
   ALLEGRO_PRIM_TEX_COORD,
   ALLEGRO_PRIM_TEX_COORD_PIXEL,
   ALLEGRO_PRIM_USER_ATTR,
   ALLEGRO_PRIM_ATTR_NUM = ALLEGRO_PRIM_USER_ATTR + ALLEGRO_PRIM_MAX_USER_ATTR
} ALLEGRO_PRIM_ATTR;

/* Enum: ALLEGRO_PRIM_STORAGE
 */
typedef enum ALLEGRO_PRIM_STORAGE
{
   ALLEGRO_PRIM_FLOAT_2,
   ALLEGRO_PRIM_FLOAT_3,
   ALLEGRO_PRIM_SHORT_2,
   ALLEGRO_PRIM_FLOAT_1,
   ALLEGRO_PRIM_FLOAT_4,
   ALLEGRO_PRIM_UBYTE_4,
   ALLEGRO_PRIM_SHORT_4,
   ALLEGRO_PRIM_NORMALIZED_UBYTE_4,
   ALLEGRO_PRIM_NORMALIZED_SHORT_2,
   ALLEGRO_PRIM_NORMALIZED_SHORT_4,
   ALLEGRO_PRIM_NORMALIZED_USHORT_2,
   ALLEGRO_PRIM_NORMALIZED_USHORT_4,
   ALLEGRO_PRIM_HALF_FLOAT_2,
   ALLEGRO_PRIM_HALF_FLOAT_4
} ALLEGRO_PRIM_STORAGE;

/* Enum: ALLEGRO_PRIM_BUFFER_FLAGS
 */
typedef enum ALLEGRO_PRIM_BUFFER_FLAGS
{
   ALLEGRO_PRIM_BUFFER_STREAM       = 0x01,
   ALLEGRO_PRIM_BUFFER_STATIC       = 0x02,
   ALLEGRO_PRIM_BUFFER_DYNAMIC      = 0x04,
   ALLEGRO_PRIM_BUFFER_READWRITE    = 0x08
} ALLEGRO_PRIM_BUFFER_FLAGS;

/* Type: ALLEGRO_VERTEX_ELEMENT
 */
typedef struct ALLEGRO_VERTEX_ELEMENT ALLEGRO_VERTEX_ELEMENT;

struct ALLEGRO_VERTEX_ELEMENT {
   int attribute;
   int storage;
   int offset;
};

/* Type: ALLEGRO_VERTEX_DECL
 */
typedef struct ALLEGRO_VERTEX_DECL ALLEGRO_VERTEX_DECL;

/* Type: ALLEGRO_VERTEX
 */
typedef struct ALLEGRO_VERTEX ALLEGRO_VERTEX;

struct ALLEGRO_VERTEX {
  float x, y, z;
  float u, v;
  ALLEGRO_COLOR color;
};

/* Type: ALLEGRO_VERTEX_BUFFER
 */
typedef struct ALLEGRO_VERTEX_BUFFER ALLEGRO_VERTEX_BUFFER;

/* Type: ALLEGRO_INDEX_BUFFER
 */
typedef struct ALLEGRO_INDEX_BUFFER ALLEGRO_INDEX_BUFFER;

#endif
